from django.db.models.sql import compiler


class SQLCompiler(compiler.SQLCompiler):
    def as_subquery_condition(self, alias, columns, compiler):
        qn = compiler.quote_name_unless_alias
        qn2 = self.connection.ops.quote_name
        sql, params = self.as_sql()
        return '(%s) IN (%s)' % (', '.join('%s.%s' % (qn(alias), qn2(column)) for column in columns), sql), params


class SQLInsertCompiler(compiler.SQLInsertCompiler, SQLCompiler):
    pass


class SQLDeleteCompiler(compiler.SQLDeleteCompiler, SQLCompiler):
    def as_sql(self):
        # Prefer the non-standard DELETE FROM syntax over the SQL generated by
        # the SQLDeleteCompiler's default implementation when multiple tables
        # are involved since MySQL/MariaDB will generate a more efficient query
        # plan than when using a subquery.
        where, having = self.query.where.split_having()
        if self.single_alias or having:
            # DELETE FROM cannot be used when filtering against aggregates
            # since it doesn't allow for GROUP BY and HAVING clauses.
            return super().as_sql()
        result = [
            'DELETE %s FROM' % self.quote_name_unless_alias(
                self.query.get_initial_alias()
            )
        ]
        from_sql, from_params = self.get_from_clause()
        result.extend(from_sql)
        where_sql, where_params = self.compile(where)
        if where_sql:
            result.append('WHERE %s' % where_sql)
        return ' '.join(result), tuple(from_params) + tuple(where_params)


class SQLUpdateCompiler(compiler.SQLUpdateCompiler, SQLCompiler):
    pass


class SQLAggregateCompiler(compiler.SQLAggregateCompiler, SQLCompiler):
    pass
