# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class SoftwareAttachmentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_link_software_attachment(self, body, **kwargs):  # noqa: E501
        """Create a new link as software attachment  # noqa: E501

        Create a software attachments that links to an external resource  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_link_software_attachment(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareAttachmentLinkRequestPost body: Software attachment object that needs to be created (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_link_software_attachment_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_link_software_attachment_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_link_software_attachment_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new link as software attachment  # noqa: E501

        Create a software attachments that links to an external resource  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_link_software_attachment_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareAttachmentLinkRequestPost body: Software attachment object that needs to be created (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_software_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_link_software_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments/links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareAttachmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_software_attachment(self, id, **kwargs):  # noqa: E501
        """Delete a software attachment and the file  # noqa: E501

        Delete a specific software attachment resource and file identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_software_attachment(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_software_attachment_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_software_attachment_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_software_attachment_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a software attachment and the file  # noqa: E501

        Delete a specific software attachment resource and file identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_software_attachment_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_software_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_software_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_software_attachment(self, id, **kwargs):  # noqa: E501
        """Download the software attachments file  # noqa: E501

        Download the file of the software attachment with the original filename. Content-Transfer-Encoding header is set to binary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_software_attachment(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to fetch (required)
        :param str disposition: Disposition type the download should be returned with. Allowed values are \"inline\" and \"attachment\". Default is \"attachment\".
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_software_attachment_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_software_attachment_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def download_software_attachment_with_http_info(self, id, **kwargs):  # noqa: E501
        """Download the software attachments file  # noqa: E501

        Download the file of the software attachment with the original filename. Content-Transfer-Encoding header is set to binary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_software_attachment_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to fetch (required)
        :param str disposition: Disposition type the download should be returned with. Allowed values are \"inline\" and \"attachment\". Default is \"attachment\".
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'disposition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_software_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_software_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'disposition' in params:
            query_params.append(('disposition', params['disposition']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments/{id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_software_attachment_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single software attachment  # noqa: E501

        specific software attachment in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_software_attachment_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to fetch (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_software_attachment_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_software_attachment_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_software_attachment_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single software attachment  # noqa: E501

        specific software attachment in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_software_attachment_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to fetch (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_software_attachment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_software_attachment_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareAttachmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_software_attachments(self, **kwargs):  # noqa: E501
        """Get a range of software attachments  # noqa: E501

        Returns a list of all software attachments that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.'  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_software_attachments(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param date content_date: Expected date format is YYYY-MM-DD or YYYY-MM-DDThh:mm:ss
        :param str remarks: Filter accepts `*` as wildcard
        :param str file_name: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SoftwareAttachmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_software_attachments_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_software_attachments_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_software_attachments_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of software attachments  # noqa: E501

        Returns a list of all software attachments that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.'  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_software_attachments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param date content_date: Expected date format is YYYY-MM-DD or YYYY-MM-DDThh:mm:ss
        :param str remarks: Filter accepts `*` as wildcard
        :param str file_name: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SoftwareAttachmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'content_date', 'remarks', 'file_name', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_software_attachments" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'content_date' in params:
            query_params.append(('content_date', params['content_date']))  # noqa: E501
        if 'remarks' in params:
            query_params.append(('remarks', params['remarks']))  # noqa: E501
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareAttachmentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_link_software_attachment(self, body, id, **kwargs):  # noqa: E501
        """Update a software attachment with a link  # noqa: E501

        update an software attachment that has a link  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_link_software_attachment(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareAttachmentLinkRequestPatch body: Software attachment object that needs to be updated (required)
        :param int id: Id of the software attachment to update (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_link_software_attachment_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_link_software_attachment_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_link_software_attachment_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a software attachment with a link  # noqa: E501

        update an software attachment that has a link  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_link_software_attachment_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareAttachmentLinkRequestPatch body: Software attachment object that needs to be updated (required)
        :param int id: Id of the software attachment to update (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_link_software_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_link_software_attachment`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_link_software_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments/links/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareAttachmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_software_attachment(self, id, **kwargs):  # noqa: E501
        """Update an software attachment and especially its file  # noqa: E501

        The software attachment object and also the file can be changed with a patch call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_software_attachment(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to update (required)
        :param str file:
        :param int software_id:
        :param str content_date:
        :param str remarks:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_software_attachment_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_software_attachment_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_software_attachment_with_http_info(self, id, **kwargs):  # noqa: E501
        """Update an software attachment and especially its file  # noqa: E501

        The software attachment object and also the file can be changed with a patch call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_software_attachment_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the software attachment to update (required)
        :param str file:
        :param int software_id:
        :param str content_date:
        :param str remarks:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'file', 'software_id', 'content_date', 'remarks']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_software_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_software_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'software_id' in params:
            form_params.append(('software_id', params['software_id']))  # noqa: E501
        if 'content_date' in params:
            form_params.append(('content_date', params['content_date']))  # noqa: E501
        if 'remarks' in params:
            form_params.append(('remarks', params['remarks']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_software_attachment(self, file, software_id, content_date, remarks, **kwargs):  # noqa: E501
        """Create and upload a new software attachment  # noqa: E501

        the creation of an software attachment works through a multipart/form-data upload of the file and its filename.  Forbidden content-types are  - application/xhtml+xml - text/html - application/javascript - text/javascript - application/x-shockwave-flash - application/vnd.adobe.flash.movie - video/x-flv - text/php - application/php - application/x-php - application/x-httpd-php  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_software_attachment(file, software_id, content_date, remarks, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param int software_id: (required)
        :param str content_date: (required)
        :param str remarks: (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_software_attachment_with_http_info(file, software_id, content_date, remarks, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_software_attachment_with_http_info(file, software_id, content_date, remarks, **kwargs)  # noqa: E501
            return data

    def upload_software_attachment_with_http_info(self, file, software_id, content_date, remarks, **kwargs):  # noqa: E501
        """Create and upload a new software attachment  # noqa: E501

        the creation of an software attachment works through a multipart/form-data upload of the file and its filename.  Forbidden content-types are  - application/xhtml+xml - text/html - application/javascript - text/javascript - application/x-shockwave-flash - application/vnd.adobe.flash.movie - video/x-flv - text/php - application/php - application/x-php - application/x-httpd-php  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_software_attachment_with_http_info(file, software_id, content_date, remarks, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param int software_id: (required)
        :param str content_date: (required)
        :param str remarks: (required)
        :return: SoftwareAttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'software_id', 'content_date', 'remarks']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_software_attachment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_software_attachment`")  # noqa: E501
        # verify the required parameter 'software_id' is set
        if ('software_id' not in params or
                params['software_id'] is None):
            raise ValueError("Missing the required parameter `software_id` when calling `upload_software_attachment`")  # noqa: E501
        # verify the required parameter 'content_date' is set
        if ('content_date' not in params or
                params['content_date'] is None):
            raise ValueError("Missing the required parameter `content_date` when calling `upload_software_attachment`")  # noqa: E501
        # verify the required parameter 'remarks' is set
        if ('remarks' not in params or
                params['remarks'] is None):
            raise ValueError("Missing the required parameter `remarks` when calling `upload_software_attachment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'software_id' in params:
            form_params.append(('software_id', params['software_id']))  # noqa: E501
        if 'content_date' in params:
            form_params.append(('content_date', params['content_date']))  # noqa: E501
        if 'remarks' in params:
            form_params.append(('remarks', params['remarks']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/software/attachments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwareAttachmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
