# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class NotificationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_client_applications_to_notification(self, body, notification_id, **kwargs):  # noqa: E501
        """add client_applications to a notification  # noqa: E501

        Add one or more client_applications to a notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_client_applications_to_notification(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be added. (required)
        :param int notification_id: Id of the notification to which the client_applications will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_client_applications_to_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_client_applications_to_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
            return data

    def add_client_applications_to_notification_with_http_info(self, body, notification_id, **kwargs):  # noqa: E501
        """add client_applications to a notification  # noqa: E501

        Add one or more client_applications to a notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_client_applications_to_notification_with_http_info(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be added. (required)
        :param int notification_id: Id of the notification to which the client_applications will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_client_applications_to_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_client_applications_to_notification`")  # noqa: E501
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `add_client_applications_to_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{notification_id}/client_applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_notification(self, body, **kwargs):  # noqa: E501
        """Create a new notification  # noqa: E501

        The notification content can be formatted with markdown. The only html tag allowed is ```a```, all other tags will be silently removed. Parameters supporting translation: ```content```. POST sets values in default language: en.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationRequest body: Notification object to create. (required)
        :return: NotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_notification_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new notification  # noqa: E501

        The notification content can be formatted with markdown. The only html tag allowed is ```a```, all other tags will be silently removed. Parameters supporting translation: ```content```. POST sets values in default language: en.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationRequest body: Notification object to create. (required)
        :return: NotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_notification(self, id, **kwargs):  # noqa: E501
        """Delete a notification  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the notification to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_notification_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a notification  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the notification to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_applications_of_notification(self, notification_id, **kwargs):  # noqa: E501
        """Get all client_applications assigned to a notification  # noqa: E501

        Returns a list of client_applications in your accessible scope. If the query has no matches, the response is an empty list. Only client_applications on which the user has the can_read permission are loaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_applications_of_notification(notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int notification_id: Id of the notification to update (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str contact_person_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ClientApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_applications_of_notification_with_http_info(notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_applications_of_notification_with_http_info(notification_id, **kwargs)  # noqa: E501
            return data

    def get_client_applications_of_notification_with_http_info(self, notification_id, **kwargs):  # noqa: E501
        """Get all client_applications assigned to a notification  # noqa: E501

        Returns a list of client_applications in your accessible scope. If the query has no matches, the response is an empty list. Only client_applications on which the user has the can_read permission are loaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_applications_of_notification_with_http_info(notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int notification_id: Id of the notification to update (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str contact_person_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ClientApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_id', 'page', 'per_page', 'name', 'contact_person_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_applications_of_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `get_client_applications_of_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'contact_person_id' in params:
            query_params.append(('contact_person_id', params['contact_person_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{notification_id}/client_applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single notification  # noqa: E501

        Get a specific notification identified by the id in the URL. Parameters supporting translation: ```content```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of notification to fetch (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: NotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_notification_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single notification  # noqa: E501

        Get a specific notification identified by the id in the URL. Parameters supporting translation: ```content```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of notification to fetch (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: NotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_notification_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notifications(self, **kwargs):  # noqa: E501
        """Get a range of notifications  # noqa: E501

        Returns a list of all notifications available in your scope. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```content```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notifications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str name: searches notifications with given name
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: Notifications
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notifications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_notifications_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_notifications_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of notifications  # noqa: E501

        Returns a list of all notifications available in your scope. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```content```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notifications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str name: searches notifications with given name
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: Notifications
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'client_application_id', 'start_datetime', 'start_datetime_from', 'start_datetime_to', 'end_datetime', 'end_datetime_from', 'end_datetime_to', 'name', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notifications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'client_application_id' in params:
            query_params.append(('client_application_id', params['client_application_id']))  # noqa: E501
        if 'start_datetime' in params:
            query_params.append(('start_datetime', params['start_datetime']))  # noqa: E501
        if 'start_datetime_from' in params:
            query_params.append(('start_datetime_from', params['start_datetime_from']))  # noqa: E501
        if 'start_datetime_to' in params:
            query_params.append(('start_datetime_to', params['start_datetime_to']))  # noqa: E501
        if 'end_datetime' in params:
            query_params.append(('end_datetime', params['end_datetime']))  # noqa: E501
        if 'end_datetime_from' in params:
            query_params.append(('end_datetime_from', params['end_datetime_from']))  # noqa: E501
        if 'end_datetime_to' in params:
            query_params.append(('end_datetime_to', params['end_datetime_to']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Notifications',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remote_client_applications_from_notification(self, body, notification_id, **kwargs):  # noqa: E501
        """Remove client_application form a notification  # noqa: E501

        Remove one or more client_applications from a notification  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remote_client_applications_from_notification(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be removed. (required)
        :param int notification_id: Id of the notification from which the client_applications will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remote_client_applications_from_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remote_client_applications_from_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
            return data

    def remote_client_applications_from_notification_with_http_info(self, body, notification_id, **kwargs):  # noqa: E501
        """Remove client_application form a notification  # noqa: E501

        Remove one or more client_applications from a notification  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remote_client_applications_from_notification_with_http_info(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be removed. (required)
        :param int notification_id: Id of the notification from which the client_applications will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remote_client_applications_from_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remote_client_applications_from_notification`")  # noqa: E501
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `remote_client_applications_from_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{notification_id}/client_applications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_client_applications_of_notification(self, body, notification_id, **kwargs):  # noqa: E501
        """Replace the client_applications of a notification  # noqa: E501

        Replaces all client_applications belonging to a notificatoin. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_client_applications_of_notification(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be replaced (required)
        :param int notification_id: Id of the notification of which the client_applications will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_client_applications_of_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_client_applications_of_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
            return data

    def replace_client_applications_of_notification_with_http_info(self, body, notification_id, **kwargs):  # noqa: E501
        """Replace the client_applications of a notification  # noqa: E501

        Replaces all client_applications belonging to a notificatoin. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_client_applications_of_notification_with_http_info(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be replaced (required)
        :param int notification_id: Id of the notification of which the client_applications will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_client_applications_of_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_client_applications_of_notification`")  # noqa: E501
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `replace_client_applications_of_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{notification_id}/client_applications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_notification(self, body, id, **kwargs):  # noqa: E501
        """Update a notification  # noqa: E501

        Update accessible parameters of the requested resource. The notification content can be formatted with markdown. The only html tag allowed is ```a```, all other tags will be silently removed. Parameters supporting translation: ```name, description```. To add a translation set Content-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the notification to update (required)
        :param str content_language: language of the content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_notification_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_notification_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_notification_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a notification  # noqa: E501

        Update accessible parameters of the requested resource. The notification content can be formatted with markdown. The only html tag allowed is ```a```, all other tags will be silently removed. Parameters supporting translation: ```name, description```. To add a translation set Content-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the notification to update (required)
        :param str content_language: language of the content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'content_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_notification`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'content_language' in params:
            header_params['Content-Language'] = params['content_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/notifications/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
