# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class NodeApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_assets_to_node(self, body, node_id, **kwargs):  # noqa: E501
        """Add assets to a node  # noqa: E501

        Add one or more assets to a node. This action requires `can_permit` permission on the node and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the assets will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_assets_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_assets_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def add_assets_to_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Add assets to a node  # noqa: E501

        Add one or more assets to a node. This action requires `can_permit` permission on the node and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the assets will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_assets_to_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_assets_to_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `add_assets_to_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_documents_to_node(self, body, node_id, **kwargs):  # noqa: E501
        """Add documents to a node  # noqa: E501

        Add one or more documents to a node. This action requires `can_update` permission on the node and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Add documents to a node  # noqa: E501

        Add one or more documents to a node. This action requires `can_update` permission on the node and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `add_documents_to_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_instrumentations_to_node(self, body, node_id, **kwargs):  # noqa: E501
        """Add instrumentations to a node  # noqa: E501

        Add one or more instrumentations to a node. This action requires `can_permit` permission on the node and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentations_to_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the instrumentations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_instrumentations_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_instrumentations_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def add_instrumentations_to_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Add instrumentations to a node  # noqa: E501

        Add one or more instrumentations to a node. This action requires `can_permit` permission on the node and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentations_to_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the instrumentations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_instrumentations_to_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_instrumentations_to_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `add_instrumentations_to_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/instrumentations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_node_picture_link(self, body, id, **kwargs):  # noqa: E501
        """Add a link as node picture  # noqa: E501

        Add an external resource as node picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_node_picture_link(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be created (required)
        :param int id: Id of the node (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_node_picture_link_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_node_picture_link_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def add_node_picture_link_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Add a link as node picture  # noqa: E501

        Add an external resource as node picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_node_picture_link_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be created (required)
        :param int id: Id of the node (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_node_picture_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_node_picture_link`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_node_picture_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{id}/pictures/links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_recipes_to_node(self, body, node_id, **kwargs):  # noqa: E501
        """Add recipes to a node  # noqa: E501

        Add one or more recipes to a node. This action requires `can_permit` permission on the node and on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_recipes_to_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipeIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the recipes will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_recipes_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_recipes_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def add_recipes_to_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Add recipes to a node  # noqa: E501

        Add one or more recipes to a node. This action requires `can_permit` permission on the node and on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_recipes_to_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipeIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the recipes will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_recipes_to_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_recipes_to_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `add_recipes_to_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/recipes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_systems_to_node(self, body, node_id, **kwargs):  # noqa: E501
        """Add systems to a node  # noqa: E501

        Add one or more systems to a node. This action requires `can_permit` permission on the node and on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_systems_to_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the systems will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_systems_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_systems_to_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def add_systems_to_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Add systems to a node  # noqa: E501

        Add one or more systems to a node. This action requires `can_permit` permission on the node and on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_systems_to_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemIDs body: Resources that shall be added. (required)
        :param int node_id: Id of the node to which the systems will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_systems_to_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_systems_to_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `add_systems_to_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/systems', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nodes(self, body, **kwargs):  # noqa: E501
        """Create a new node  # noqa: E501

        Create a new node. The name of the given node needs to be unique within its parent. The node will not be created when this constraint is violated. To assign a parent node the user needs `can_permit` permission on the parent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nodes(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeRequest body: Object body that will be created. Name, node status and node type are required (required)
        :return: NodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nodes_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nodes_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_nodes_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new node  # noqa: E501

        Create a new node. The name of the given node needs to be unique within its parent. The node will not be created when this constraint is violated. To assign a parent node the user needs `can_permit` permission on the parent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nodes_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeRequest body: Object body that will be created. Name, node status and node type are required (required)
        :return: NodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nodes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_nodes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_node(self, id, **kwargs):  # noqa: E501
        """Delete a node  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the node to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_node_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_node_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_node_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a node  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the node to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_node_picture(self, node_id, id, **kwargs):  # noqa: E501
        """Delete an node picture  # noqa: E501

        Delete an node picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_picture(node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_node_picture_with_http_info(node_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_node_picture_with_http_info(node_id, id, **kwargs)  # noqa: E501
            return data

    def delete_node_picture_with_http_info(self, node_id, id, **kwargs):  # noqa: E501
        """Delete an node picture  # noqa: E501

        Delete an node picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_picture_with_http_info(node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_node_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `delete_node_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_node_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/pictures/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_node_picture(self, node_id, id, **kwargs):  # noqa: E501
        """Download an node picture  # noqa: E501

        Download an node picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_node_picture(node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_node_picture_with_http_info(node_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_node_picture_with_http_info(node_id, id, **kwargs)  # noqa: E501
            return data

    def download_node_picture_with_http_info(self, node_id, id, **kwargs):  # noqa: E501
        """Download an node picture  # noqa: E501

        Download an node picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_node_picture_with_http_info(node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_node_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `download_node_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_node_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/pictures/{id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets_of_node(self, node_id, **kwargs):  # noqa: E501
        """Get all assets of one node  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_assets_of_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get all assets of one node  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'page', 'per_page', 'include', 'serial_number', 'product_id', 'product_category_id', 'parent_id', 'manufacturer_id', 'status_id', 'status_code', 'production_date', 'production_date_from', 'production_date_to', 'specifications_key', 'specifications_value', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'ownership_claimed', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_assets_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'product_id' in params:
            query_params.append(('product_id', params['product_id']))  # noqa: E501
        if 'product_category_id' in params:
            query_params.append(('product_category_id', params['product_category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'status_code' in params:
            query_params.append(('status_code', params['status_code']))  # noqa: E501
        if 'production_date' in params:
            query_params.append(('production_date', params['production_date']))  # noqa: E501
        if 'production_date_from' in params:
            query_params.append(('production_date_from', params['production_date_from']))  # noqa: E501
        if 'production_date_to' in params:
            query_params.append(('production_date_to', params['production_date_to']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'ownership_claimed' in params:
            query_params.append(('ownership_claimed', params['ownership_claimed']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_node(self, node_id, **kwargs):  # noqa: E501
        """Get all documents of a node  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get all documents of a node  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_documents_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentations_of_node(self, node_id, **kwargs):  # noqa: E501
        """Get all instrumentations of one node  # noqa: E501

        Returns a list of all instrumentations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentations_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentations_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentations_of_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get all instrumentations of one node  # noqa: E501

        Returns a list of all instrumentations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'page', 'per_page', 'include', 'tag', 'status_id', 'type_id', 'parent_id', 'tenant_id', 'specifications_key', 'specifications_value', 'criticality', 'accessibility', 'asset_status_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentations_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_instrumentations_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'criticality' in params:
            query_params.append(('criticality', params['criticality']))  # noqa: E501
        if 'accessibility' in params:
            query_params.append(('accessibility', params['accessibility']))  # noqa: E501
        if 'asset_status_id' in params:
            query_params.append(('asset_status_id', params['asset_status_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/instrumentations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_id_type(self, node_id, **kwargs):  # noqa: E501
        """Get the type of the specific node  # noqa: E501

        Returns the type of the node. Needed if only permission on node but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_id_type(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: NodeTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_id_type_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_id_type_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_node_id_type_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get the type of the specific node  # noqa: E501

        Returns the type of the node. Needed if only permission on node but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_id_type_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: NodeTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'include', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_id_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_node_id_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/type', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_picture(self, node_id, id, **kwargs):  # noqa: E501
        """Get an node picture  # noqa: E501

        Get a single picture of an node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_picture(node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_picture_with_http_info(node_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_picture_with_http_info(node_id, id, **kwargs)  # noqa: E501
            return data

    def get_node_picture_with_http_info(self, node_id, id, **kwargs):  # noqa: E501
        """Get an node picture  # noqa: E501

        Get a single picture of an node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_picture_with_http_info(node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_node_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_node_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/pictures/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_pictures(self, id, **kwargs):  # noqa: E501
        """Get node pictures  # noqa: E501

        Get all pictures of an node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_pictures(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the node (required)
        :param int width: filter by width
        :param int width_from: filter by width_from
        :param int width_to: filter by width_to
        :param int height: filter by height
        :param int height_from: filter by height_from
        :param int height_to: filter by height_to
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_pictures_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_pictures_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_node_pictures_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get node pictures  # noqa: E501

        Get all pictures of an node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_pictures_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the node (required)
        :param int width: filter by width
        :param int width_from: filter by width_from
        :param int width_to: filter by width_to
        :param int height: filter by height
        :param int height_from: filter by height_from
        :param int height_to: filter by height_to
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'width', 'width_from', 'width_to', 'height', 'height_from', 'height_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_pictures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_node_pictures`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))  # noqa: E501
        if 'width_from' in params:
            query_params.append(('width_from', params['width_from']))  # noqa: E501
        if 'width_to' in params:
            query_params.append(('width_to', params['width_to']))  # noqa: E501
        if 'height' in params:
            query_params.append(('height', params['height']))  # noqa: E501
        if 'height_from' in params:
            query_params.append(('height_from', params['height_from']))  # noqa: E501
        if 'height_to' in params:
            query_params.append(('height_to', params['height_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{id}/pictures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PicturesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_types_options(self, node_id, **kwargs):  # noqa: E501
        """Get all possible types of the specified node  # noqa: E501

        Returns a list of all possible node types for the specified node. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_types_options(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: NodeTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_types_options_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_types_options_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_node_types_options_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get all possible types of the specified node  # noqa: E501

        Returns a list of all possible node types for the specified node. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_types_options_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the node (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: NodeTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'page', 'per_page', 'tenant_id', 'name', 'code', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_types_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_node_types_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/type-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeTypes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nodes(self, **kwargs):  # noqa: E501
        """Get a range of nodes  # noqa: E501

        Returns a list of nodes in your accessible scope. If the query has no matches, the response is an empty list.  Possible include values: ```parent, tenant, type, type.parent, specifications, specifications[key1,key2], pictures, instrumentations, instrumentations.specifications, instrumentations.specifications[key1,key2], instrumentations.values, instrumentations.values.unit, instrumentations.values_in_preferred_units, instrumentations.values_in_preferred_units.unit, worst_asset_status``` Hidden nodes are not returned by default, if the hidden nodes should be included, add \"```hidden```\" to the include parameter   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: NodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of nodes  # noqa: E501

        Returns a list of nodes in your accessible scope. If the query has no matches, the response is an empty list.  Possible include values: ```parent, tenant, type, type.parent, specifications, specifications[key1,key2], pictures, instrumentations, instrumentations.specifications, instrumentations.specifications[key1,key2], instrumentations.values, instrumentations.values.unit, instrumentations.values_in_preferred_units, instrumentations.values_in_preferred_units.unit, worst_asset_status``` Hidden nodes are not returned by default, if the hidden nodes should be included, add \"```hidden```\" to the include parameter   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: NodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'name', 'type_id', 'parent_id', 'tenant_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nodes_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single node  # noqa: E501

        Get a specific node in your accessible scope, identified by the id in the URL.  Possible include values: ```parent, tenant, type, specifications, specifications[key1,key2], pictures, instrumentations, instrumentations.specifications, instrumentations.specifications[key1,key2], instrumentations.values, instrumentations.values.unit, instrumentations.values_in_preferred_units, instrumentations.values_in_preferred_units.unit, worst_asset_status```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the node to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: NodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nodes_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nodes_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_nodes_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single node  # noqa: E501

        Get a specific node in your accessible scope, identified by the id in the URL.  Possible include values: ```parent, tenant, type, specifications, specifications[key1,key2], pictures, instrumentations, instrumentations.specifications, instrumentations.specifications[key1,key2], instrumentations.values, instrumentations.values.unit, instrumentations.values_in_preferred_units, instrumentations.values_in_preferred_units.unit, worst_asset_status```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the node to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: NodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nodes_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_nodes_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_recipes_of_node(self, node_id, **kwargs):  # noqa: E501
        """Get all recipes of one node  # noqa: E501

        Returns a list of all recipes that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```Possible include values: pictures, specifications, specifications[key1,key2], tenant, status, type, type.tenant, type.parent ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipes_of_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: RecipesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_recipes_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_recipes_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_recipes_of_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get all recipes of one node  # noqa: E501

        Returns a list of all recipes that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```Possible include values: pictures, specifications, specifications[key1,key2], tenant, status, type, type.tenant, type.parent ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipes_of_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: RecipesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'page', 'per_page', 'include', 'name', 'status_id', 'type_id', 'tenant_id', 'specifications_key', 'specifications_value', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipes_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_recipes_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/recipes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RecipesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specification_keys_of_nodes(self, **kwargs):  # noqa: E501
        """Get existing asset specification keys  # noqa: E501

        Returns the existing specification keys in all readable nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_keys_of_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specification_keys_of_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_specification_keys_of_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_specification_keys_of_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """Get existing asset specification keys  # noqa: E501

        Returns the existing specification keys in all readable nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_keys_of_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'ui_visible']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specification_keys_of_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'ui_visible' in params:
            query_params.append(('ui_visible', params['ui_visible']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/node/specification_keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationKeys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specifications_of_node(self, node_id, **kwargs):  # noqa: E501
        """Get specifications of a node  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the specified node (required)
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationsUIVisibleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specifications_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specifications_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_specifications_of_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get specifications of a node  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: Id of the specified node (required)
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationsUIVisibleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'key', 'ui_visible']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specifications_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_specifications_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'ui_visible' in params:
            query_params.append(('ui_visible', params['ui_visible']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/specifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationsUIVisibleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_systems_of_node(self, node_id, **kwargs):  # noqa: E501
        """Get all systems of one node  # noqa: E501

        Returns a list of all systems that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```pictures, specifications, specifications[key1,key2], tenant, parent, status, type, type.tenant, type.parent, worst_asset_status ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_systems_of_node(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SystemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_systems_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_systems_of_node_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_systems_of_node_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Get all systems of one node  # noqa: E501

        Returns a list of all systems that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```pictures, specifications, specifications[key1,key2], tenant, parent, status, type, type.tenant, type.parent, worst_asset_status ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_systems_of_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int node_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SystemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id', 'page', 'per_page', 'include', 'name', 'status_id', 'type_id', 'tenant_id', 'specifications_key', 'specifications_value', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_systems_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_systems_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/systems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assets_from_node(self, body, node_id, **kwargs):  # noqa: E501
        """Remove assets from a node  # noqa: E501

        Remove one or more assets from a node in your accessible scope. This action requires `can_permit` permission on the node and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the assets will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_assets_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_assets_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def remove_assets_from_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Remove assets from a node  # noqa: E501

        Remove one or more assets from a node in your accessible scope. This action requires `can_permit` permission on the node and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the assets will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assets_from_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_assets_from_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `remove_assets_from_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/assets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_node(self, body, node_id, **kwargs):  # noqa: E501
        """Remove documents from a node  # noqa: E501

        Remove one or more documents from a node. This action requires `can_update` permission on the node and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Remove documents from a node  # noqa: E501

        Remove one or more documents from a node. This action requires `can_update` permission on the node and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `remove_documents_from_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_instrumentations_from_node(self, body, node_id, **kwargs):  # noqa: E501
        """Remove instrumentations from a node  # noqa: E501

        Remove one or more instrumentations from a node in your accessible scope. This action requires `can_permit` permission on the node and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_from_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the instrumentations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_instrumentations_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_instrumentations_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def remove_instrumentations_from_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Remove instrumentations from a node  # noqa: E501

        Remove one or more instrumentations from a node in your accessible scope. This action requires `can_permit` permission on the node and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_from_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the instrumentations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_instrumentations_from_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_instrumentations_from_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `remove_instrumentations_from_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/instrumentations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_recipes_from_node(self, body, node_id, **kwargs):  # noqa: E501
        """Remove recipes from a node  # noqa: E501

        Remove one or more recipes from a node in your accessible scope. This action requires `can_permit` permission on the node and on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_recipes_from_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipeIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the recipes will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_recipes_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_recipes_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def remove_recipes_from_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Remove recipes from a node  # noqa: E501

        Remove one or more recipes from a node in your accessible scope. This action requires `can_permit` permission on the node and on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_recipes_from_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipeIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the recipes will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_recipes_from_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_recipes_from_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `remove_recipes_from_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/recipes', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_specifications_from_node(self, body, node_id, **kwargs):  # noqa: E501
        """Delete specifications of a node  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int node_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_specifications_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_specifications_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def remove_specifications_from_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Delete specifications of a node  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int node_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_specifications_from_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_specifications_from_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `remove_specifications_from_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/specifications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_systems_from_node(self, body, node_id, **kwargs):  # noqa: E501
        """Remove systems from a node  # noqa: E501

        Remove one or more systems from a node in your accessible scope. This action requires `can_permit` permission on the node and on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_systems_from_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the systems will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_systems_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_systems_from_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def remove_systems_from_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Remove systems from a node  # noqa: E501

        Remove one or more systems from a node in your accessible scope. This action requires `can_permit` permission on the node and on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_systems_from_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemIDs body: Resources that shall be removed. (required)
        :param int node_id: Id of the node from which the systems will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_systems_from_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_systems_from_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `remove_systems_from_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/systems', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_specifications_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of a node in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int node_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_specifications_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_specifications_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def rename_specifications_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of a node in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int node_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_specifications_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_specifications_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `rename_specifications_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/specifications/rename', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_assets_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the assets of a node  # noqa: E501

        Replaces all assets belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the assets will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_assets_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_assets_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def replace_assets_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the assets of a node  # noqa: E501

        Replaces all assets belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the assets will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_assets_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_assets_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `replace_assets_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/assets', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the documents of a node  # noqa: E501

        Replaces all documents belonging to a node. You can send a list of resources that will replace all previous values. This action requires `can_update` permission on the node and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the documents of a node  # noqa: E501

        Replaces all documents belonging to a node. You can send a list of resources that will replace all previous values. This action requires `can_update` permission on the node and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `replace_documents_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_instrumentations_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the instrumentations of a node  # noqa: E501

        Replaces all instrumentations belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_instrumentations_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the instrumentations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_instrumentations_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_instrumentations_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def replace_instrumentations_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the instrumentations of a node  # noqa: E501

        Replaces all instrumentations belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_instrumentations_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the instrumentations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_instrumentations_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_instrumentations_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `replace_instrumentations_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/instrumentations', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_recipes_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the recipes of a node  # noqa: E501

        Replaces all recipes belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_recipes_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipeIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the recipes will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_recipes_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_recipes_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def replace_recipes_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the recipes of a node  # noqa: E501

        Replaces all recipes belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_recipes_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipeIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the recipes will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_recipes_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_recipes_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `replace_recipes_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/recipes', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_systems_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the systems of a node  # noqa: E501

        Replaces all systems belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_systems_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the systems will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_systems_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_systems_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def replace_systems_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Replace the systems of a node  # noqa: E501

        Replaces all systems belonging to a node in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the node and on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_systems_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SystemIDs body: Resources that shall be replaced (required)
        :param int node_id: Id of the node of which the systems will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_systems_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_systems_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `replace_systems_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/systems', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node(self, body, id, **kwargs):  # noqa: E501
        """Update a node  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope. To assign a parent node the user needs `can_permit` permission on the parent and on the current node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the node to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_node_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a node  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope. To assign a parent node the user needs `can_permit` permission on the parent and on the current node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the node to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_node`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_picture(self, image, node_id, id, **kwargs):  # noqa: E501
        """Update an node picture  # noqa: E501

        Upload a new node picture. Check the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_picture(image, node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_picture_with_http_info(image, node_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_picture_with_http_info(image, node_id, id, **kwargs)  # noqa: E501
            return data

    def update_node_picture_with_http_info(self, image, node_id, id, **kwargs):  # noqa: E501
        """Update an node picture  # noqa: E501

        Upload a new node picture. Check the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_picture_with_http_info(image, node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image', 'node_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image' is set
        if ('image' not in params or
                params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `update_node_picture`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `update_node_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_node_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/pictures/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_picture_link(self, body, node_id, id, **kwargs):  # noqa: E501
        """Update a node picture link  # noqa: E501

        Update a node picture link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_picture_link(body, node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be updated (required)
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_picture_link_with_http_info(body, node_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_picture_link_with_http_info(body, node_id, id, **kwargs)  # noqa: E501
            return data

    def update_node_picture_link_with_http_info(self, body, node_id, id, **kwargs):  # noqa: E501
        """Update a node picture link  # noqa: E501

        Update a node picture link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_picture_link_with_http_info(body, node_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be updated (required)
        :param int node_id: Id of the node (required)
        :param int id: Id of the node picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_picture_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_node_picture_link`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `update_node_picture_link`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_node_picture_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/pictures/links/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_specifications_of_node(self, body, node_id, **kwargs):  # noqa: E501
        """Update specifications of a node  # noqa: E501

        Update the specification object of a node in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_node(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationUIVisibleRequest) body: The specifications objects to patch. (required)
        :param int node_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_specifications_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_specifications_of_node_with_http_info(body, node_id, **kwargs)  # noqa: E501
            return data

    def update_specifications_of_node_with_http_info(self, body, node_id, **kwargs):  # noqa: E501
        """Update specifications of a node  # noqa: E501

        Update the specification object of a node in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_node_with_http_info(body, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationUIVisibleRequest) body: The specifications objects to patch. (required)
        :param int node_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_specifications_of_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_specifications_of_node`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `update_specifications_of_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{node_id}/specifications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_node_picture(self, image, id, **kwargs):  # noqa: E501
        """Upload an node picture  # noqa: E501

        Upload a new node picture. Checks the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_node_picture(image, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int id: Id of the node (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_node_picture_with_http_info(image, id, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_node_picture_with_http_info(image, id, **kwargs)  # noqa: E501
            return data

    def upload_node_picture_with_http_info(self, image, id, **kwargs):  # noqa: E501
        """Upload an node picture  # noqa: E501

        Upload a new node picture. Checks the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_node_picture_with_http_info(image, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int id: Id of the node (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_node_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image' is set
        if ('image' not in params or
                params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `upload_node_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `upload_node_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/nodes/{id}/pictures', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
