# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class InstrumentationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_assets_to_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add assets to an instrumentation  # noqa: E501

        Add one or more assets to an instrumentation. This action requires `can_permit` permission on the instrumentation and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the assets will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_assets_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_assets_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def add_assets_to_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add assets to an instrumentation  # noqa: E501

        Add one or more assets to an instrumentation. This action requires `can_permit` permission on the instrumentation and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the assets will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_assets_to_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_assets_to_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `add_assets_to_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_bill_of_materials_to_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add bill of materials to an instrumentation  # noqa: E501

        Add one or more bill of materials to an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bill_of_materials_to_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the bill of materials will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_bill_of_materials_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_bill_of_materials_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def add_bill_of_materials_to_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add bill of materials to an instrumentation  # noqa: E501

        Add one or more bill of materials to an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bill_of_materials_to_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the bill of materials will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_bill_of_materials_to_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_bill_of_materials_to_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `add_bill_of_materials_to_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/bill_of_materials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_documents_to_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add documents to an instrumentation  # noqa: E501

        Add one or more documents to an instrumentation. This action requires `can_update` permission on the instrumentation and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add documents to an instrumentation  # noqa: E501

        Add one or more documents to an instrumentation. This action requires `can_update` permission on the instrumentation and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `add_documents_to_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_instrumentation_picture_link(self, body, id, **kwargs):  # noqa: E501
        """Add a link as instrumentation picture  # noqa: E501

        Add an external resource as instrumentation picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentation_picture_link(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be created (required)
        :param int id: Id of the instrumentation (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_instrumentation_picture_link_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_instrumentation_picture_link_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def add_instrumentation_picture_link_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Add a link as instrumentation picture  # noqa: E501

        Add an external resource as instrumentation picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentation_picture_link_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be created (required)
        :param int id: Id of the instrumentation (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_instrumentation_picture_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_instrumentation_picture_link`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_instrumentation_picture_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{id}/pictures/links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_nodes_to_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add nodes to an instrumentation  # noqa: E501

        Add one or more nodes to an instrumentation in your accessible scope. This action requires `can_permit` permission on the instrumentation and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_nodes_to_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the nodes will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_nodes_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_nodes_to_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def add_nodes_to_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Add nodes to an instrumentation  # noqa: E501

        Add one or more nodes to an instrumentation in your accessible scope. This action requires `can_permit` permission on the instrumentation and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_nodes_to_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be added. (required)
        :param int instrumentation_id: Id of the instrumentation to which the nodes will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_nodes_to_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_nodes_to_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `add_nodes_to_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_for_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create a new event for an instrumentation  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoInstrumentations body: Object to be created. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_for_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_for_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def create_event_for_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create a new event for an instrumentation  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoInstrumentations body: Object to be created. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_for_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_event_for_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `create_event_for_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_instrumentation(self, body, **kwargs):  # noqa: E501
        """Create a new instrumentation  # noqa: E501

        Create a new instrumentation. The tag of the given instrumentation needs to be unique within its parent. The instrumentation will not be created when this constraint is violated.  To assign a parent instrumentation the user needs `can_permit` permission on the parent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instrumentation(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationRequest body: Instrumentation object that needs to be created. tag, instrumentation status and instrumentation type are required (required)
        :return: InstrumentationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instrumentation_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instrumentation_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_instrumentation_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new instrumentation  # noqa: E501

        Create a new instrumentation. The tag of the given instrumentation needs to be unique within its parent. The instrumentation will not be created when this constraint is violated.  To assign a parent instrumentation the user needs `can_permit` permission on the parent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instrumentation_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationRequest body: Instrumentation object that needs to be created. tag, instrumentation status and instrumentation type are required (required)
        :return: InstrumentationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_instrumentation_threshold(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create an instrumentation threshold  # noqa: E501

        Create a new instrumentation threshold. This action requires ```can_udpate``` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instrumentation_threshold(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instrumentation_threshold_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instrumentation_threshold_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def create_instrumentation_threshold_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create an instrumentation threshold  # noqa: E501

        Create a new instrumentation threshold. This action requires ```can_udpate``` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instrumentation_threshold_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `create_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_instrumentation(self, id, **kwargs):  # noqa: E501
        """Delete an instrumentation  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the instrumentation to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_instrumentation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_instrumentation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_instrumentation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an instrumentation  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the instrumentation to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_instrumentation_picture(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Delete an instrumentation picture  # noqa: E501

        Delete an instrumentation picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_picture(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_instrumentation_picture_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_instrumentation_picture_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def delete_instrumentation_picture_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Delete an instrumentation picture  # noqa: E501

        Delete an instrumentation picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_picture_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrumentation_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `delete_instrumentation_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_instrumentation_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/pictures/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_instrumentation_threshold(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Delete an instrumentation threshold.  # noqa: E501

        Delete an instrumentation threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_threshold(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def delete_instrumentation_threshold_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Delete an instrumentation threshold.  # noqa: E501

        Delete an instrumentation threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_threshold_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `delete_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_instrumentation_picture(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Download an instrumentation picture  # noqa: E501

        Download an instrumentation picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_instrumentation_picture(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_instrumentation_picture_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_instrumentation_picture_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def download_instrumentation_picture_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Download an instrumentation picture  # noqa: E501

        Download an instrumentation picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_instrumentation_picture_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_instrumentation_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `download_instrumentation_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_instrumentation_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/pictures/{id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all assets of one instrumentation  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_assets_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all assets of one instrumentation  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'serial_number', 'product_id', 'product_category_id', 'parent_id', 'manufacturer_id', 'status_id', 'status_code', 'tenant_id', 'production_date', 'production_date_from', 'production_date_to', 'specifications_key', 'specifications_value', 'node_id', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'ownership_claimed', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_assets_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'product_id' in params:
            query_params.append(('product_id', params['product_id']))  # noqa: E501
        if 'product_category_id' in params:
            query_params.append(('product_category_id', params['product_category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'status_code' in params:
            query_params.append(('status_code', params['status_code']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'production_date' in params:
            query_params.append(('production_date', params['production_date']))  # noqa: E501
        if 'production_date_from' in params:
            query_params.append(('production_date_from', params['production_date_from']))  # noqa: E501
        if 'production_date_to' in params:
            query_params.append(('production_date_to', params['production_date_to']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'ownership_claimed' in params:
            query_params.append(('ownership_claimed', params['ownership_claimed']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets_of_instrumentation_history(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all assets an instrumentation was assigned to  # noqa: E501

        Returns a list of all assets history available in your scope which have been assigned to the specified instrumentation. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_instrumentation_history(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str asset_id: One or multiple ids (comma list). Expected id format is integer
        :param str event: Filter accepts `create` or `destroy`
        :param date event_datetime_from: Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date event_datetime_to: Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `event` or `event_datetime`, add `-` as a prefix for descending order.
        :return: InstrumentationAssetsHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_of_instrumentation_history_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_of_instrumentation_history_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_assets_of_instrumentation_history_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all assets an instrumentation was assigned to  # noqa: E501

        Returns a list of all assets history available in your scope which have been assigned to the specified instrumentation. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_instrumentation_history_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str asset_id: One or multiple ids (comma list). Expected id format is integer
        :param str event: Filter accepts `create` or `destroy`
        :param date event_datetime_from: Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date event_datetime_to: Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `event` or `event_datetime`, add `-` as a prefix for descending order.
        :return: InstrumentationAssetsHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'asset_id', 'event', 'event_datetime_from', 'event_datetime_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_of_instrumentation_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_assets_of_instrumentation_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'asset_id' in params:
            query_params.append(('asset_id', params['asset_id']))  # noqa: E501
        if 'event' in params:
            query_params.append(('event', params['event']))  # noqa: E501
        if 'event_datetime_from' in params:
            query_params.append(('event_datetime_from', params['event_datetime_from']))  # noqa: E501
        if 'event_datetime_to' in params:
            query_params.append(('event_datetime_to', params['event_datetime_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/assets/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationAssetsHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bill_of_materials_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all bill of materials of an instrumentation  # noqa: E501

        Returns a list of all bill of materials that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_materials_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str author: Filter accepts `*` as wildcard
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :return: BillOfMaterialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bill_of_materials_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bill_of_materials_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_bill_of_materials_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all bill of materials of an instrumentation  # noqa: E501

        Returns a list of all bill of materials that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_materials_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str author: Filter accepts `*` as wildcard
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :return: BillOfMaterialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'name', 'author', '_date', 'date_from', 'date_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bill_of_materials_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_bill_of_materials_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/bill_of_materials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillOfMaterialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all documents of an instrumentation  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all documents of an instrumentation  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_documents_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all events of one instrumentation  # noqa: E501

        Returns a list of all events belonging to an instrumentation in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_events_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_events_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all events of one instrumentation  # noqa: E501

        Returns a list of all events belonging to an instrumentation in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'name', 'type_id', 'status_id', 'start_datetime', 'start_datetime_from', 'start_datetime_to', 'end_datetime', 'end_datetime_from', 'end_datetime_to', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_events_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'start_datetime' in params:
            query_params.append(('start_datetime', params['start_datetime']))  # noqa: E501
        if 'start_datetime_from' in params:
            query_params.append(('start_datetime_from', params['start_datetime_from']))  # noqa: E501
        if 'start_datetime_to' in params:
            query_params.append(('start_datetime_to', params['start_datetime_to']))  # noqa: E501
        if 'end_datetime' in params:
            query_params.append(('end_datetime', params['end_datetime']))  # noqa: E501
        if 'end_datetime_from' in params:
            query_params.append(('end_datetime_from', params['end_datetime_from']))  # noqa: E501
        if 'end_datetime_to' in params:
            query_params.append(('end_datetime_to', params['end_datetime_to']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single instrumentation  # noqa: E501

        Get a specific instrumentation in your accessible scope, identified by the id in the URL.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type, type.parent, type.tenant, values, values.unit, values.asset, values_in_preferred_units, values_in_preferred_units.unit, values_in_preferred_units.asset ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the instrumentation to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: InstrumentationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single instrumentation  # noqa: E501

        Get a specific instrumentation in your accessible scope, identified by the id in the URL.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type, type.parent, type.tenant, values, values.unit, values.asset, values_in_preferred_units, values_in_preferred_units.unit, values_in_preferred_units.asset ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the instrumentation to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: InstrumentationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_instrumentation_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_id_status(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get the status of the specific instrumentation  # noqa: E501

        Returns the status of the instrumentation. Needed if only permission on instrumentation but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_id_status(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_id_status_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_id_status_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_id_status_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get the status of the specific instrumentation  # noqa: E501

        Returns the status of the instrumentation. Needed if only permission on instrumentation but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_id_status_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_id_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_id_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_id_type(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get the type of the specific instrumentation  # noqa: E501

        Returns the type of the instrumentation. Needed if only permission on instrumentation but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_id_type(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_id_type_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_id_type_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_id_type_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get the type of the specific instrumentation  # noqa: E501

        Returns the type of the instrumentation. Needed if only permission on instrumentation but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_id_type_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_id_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_id_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/type', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_picture(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Get an instrumentation picture  # noqa: E501

        Get a single picture of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_picture(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_picture_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_picture_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_picture_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Get an instrumentation picture  # noqa: E501

        Get a single picture of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_picture_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_instrumentation_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/pictures/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_pictures(self, id, **kwargs):  # noqa: E501
        """Get instrumentation pictures  # noqa: E501

        Get all pictures of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_pictures(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the instrumentation (required)
        :param int width: filter by width
        :param int width_from: filter by width_from
        :param int width_to: filter by width_to
        :param int height: filter by height
        :param int height_from: filter by height_from
        :param int height_to: filter by height_to
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_pictures_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_pictures_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_pictures_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get instrumentation pictures  # noqa: E501

        Get all pictures of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_pictures_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the instrumentation (required)
        :param int width: filter by width
        :param int width_from: filter by width_from
        :param int width_to: filter by width_to
        :param int height: filter by height
        :param int height_from: filter by height_from
        :param int height_to: filter by height_to
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'width', 'width_from', 'width_to', 'height', 'height_from', 'height_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_pictures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_instrumentation_pictures`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))  # noqa: E501
        if 'width_from' in params:
            query_params.append(('width_from', params['width_from']))  # noqa: E501
        if 'width_to' in params:
            query_params.append(('width_to', params['width_to']))  # noqa: E501
        if 'height' in params:
            query_params.append(('height', params['height']))  # noqa: E501
        if 'height_from' in params:
            query_params.append(('height_from', params['height_from']))  # noqa: E501
        if 'height_to' in params:
            query_params.append(('height_to', params['height_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{id}/pictures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PicturesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_statuses_options(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all possible statuses of the specified instrumentation  # noqa: E501

        Returns a list of all possible instrumentation statuses for the specified instrument. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_statuses_options(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_statuses_options_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_statuses_options_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_statuses_options_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all possible statuses of the specified instrumentation  # noqa: E501

        Returns a list of all possible instrumentation statuses for the specified instrument. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_statuses_options_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'tenant_id', 'name', 'code', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_statuses_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_statuses_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/status-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationStatuses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_threshold(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Get an instrumentation threshold  # noqa: E501

        Get a single threshold of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_threshold(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_threshold_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Get an instrumentation threshold  # noqa: E501

        Get a single threshold of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_threshold_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_thresholds(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get instrumentation thresholds  # noqa: E501

        Get all thresholds of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_thresholds(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_thresholds_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_thresholds_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_thresholds_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get instrumentation thresholds  # noqa: E501

        Get all thresholds of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_thresholds_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'threshold_type', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_thresholds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_thresholds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'threshold_type' in params:
            query_params.append(('threshold_type', params['threshold_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_types_options(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all possible types of the specified instrumentation  # noqa: E501

        Returns a list of all possible instrumentation types for the specified instrument. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_types_options(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_types_options_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_types_options_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_types_options_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all possible types of the specified instrumentation  # noqa: E501

        Returns a list of all possible instrumentation types for the specified instrument. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_types_options_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: InstrumentationTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'tenant_id', 'name', 'code', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_types_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_types_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/type-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationTypes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_value_objects_for_key(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get instrumentation value objects for a specific key.  # noqa: E501

        Returns a collection of the history value objects of the value objects for the specified key. For a selected result of the value objects the filter parameters selector and interval are mandatory. With the filter parameters from, to or datetime, it is possible to receive the history of a defined time period. Possible include values: ```asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_value_objects_for_key(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param str key: key for the instrumentation values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date _datetime: exact date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str selector: Supported selector methods are `first, last`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the selector. The value is mandatory if selector is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValueObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_value_objects_for_key_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_value_objects_for_key_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_value_objects_for_key_with_http_info(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get instrumentation value objects for a specific key.  # noqa: E501

        Returns a collection of the history value objects of the value objects for the specified key. For a selected result of the value objects the filter parameters selector and interval are mandatory. With the filter parameters from, to or datetime, it is possible to receive the history of a defined time period. Possible include values: ```asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_value_objects_for_key_with_http_info(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param str key: key for the instrumentation values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date _datetime: exact date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str selector: Supported selector methods are `first, last`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the selector. The value is mandatory if selector is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValueObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'page', 'per_page', 'include', '_from', 'to', '_datetime', 'selector', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_value_objects_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_value_objects_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_instrumentation_value_objects_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if '_datetime' in params:
            query_params.append(('datetime', params['_datetime']))  # noqa: E501
        if 'selector' in params:
            query_params.append(('selector', params['selector']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/value_objects/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValueObjectsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_values(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get latest values for the instrumentation.  # noqa: E501

        Returns a collection of the latest values for all keys of the instrumentation. Possible include values: ```unit, asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_values_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_values_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_values_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get latest values for the instrumentation.  # noqa: E501

        Returns a collection of the latest values for all keys of the instrumentation. Possible include values: ```unit, asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'use_preferred_units', 'key', 'key_unit_id', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'key_unit_id' in params:
            query_params.append(('key_unit_id', params['key_unit_id']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_values_for_key(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get instrumentation values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values_for_key(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param str key: key for the instrumentation values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_values_for_key_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_values_for_key_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_values_for_key_with_http_info(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get instrumentation values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values_for_key_with_http_info(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param str key: key for the instrumentation values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'page', 'per_page', 'include', 'use_preferred_units', '_from', 'to', 'unit_id', 'aggregation', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_values_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_values_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_instrumentation_values_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'unit_id' in params:
            query_params.append(('unit_id', params['unit_id']))  # noqa: E501
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/values/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentations(self, **kwargs):  # noqa: E501
        """Get a range of instrumentations  # noqa: E501

        Returns a list of instrumentations in your accessible scope. If the query has no matches, the response is an empty list.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type, type.tenant, type.parent, values, values.unit, values_in_preferred_units, values_in_preferred_units.unit```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node.  By adding `+` after the id, the filter considers the given node and all its sub components but this is not usable in combination with a comma list.
        :param str asset_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no assets assigned or \"!null\" for any assigned asset
        :param str system_id: One or multiple ids (comma list). Filter accepts \"null\" for all objects with no systems assigned or \"!null\" for any assigned system
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_instrumentations_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of instrumentations  # noqa: E501

        Returns a list of instrumentations in your accessible scope. If the query has no matches, the response is an empty list.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type, type.tenant, type.parent, values, values.unit, values_in_preferred_units, values_in_preferred_units.unit```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node.  By adding `+` after the id, the filter considers the given node and all its sub components but this is not usable in combination with a comma list.
        :param str asset_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no assets assigned or \"!null\" for any assigned asset
        :param str system_id: One or multiple ids (comma list). Filter accepts \"null\" for all objects with no systems assigned or \"!null\" for any assigned system
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'tag', 'status_id', 'type_id', 'parent_id', 'tenant_id', 'specifications_key', 'specifications_value', 'criticality', 'accessibility', 'node_id', 'asset_id', 'system_id', 'asset_status_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'criticality' in params:
            query_params.append(('criticality', params['criticality']))  # noqa: E501
        if 'accessibility' in params:
            query_params.append(('accessibility', params['accessibility']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501
        if 'asset_id' in params:
            query_params.append(('asset_id', params['asset_id']))  # noqa: E501
        if 'system_id' in params:
            query_params.append(('system_id', params['system_id']))  # noqa: E501
        if 'asset_status_id' in params:
            query_params.append(('asset_status_id', params['asset_status_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nodes_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all nodes of one Instrumentation  # noqa: E501

        Returns a list of all nodes that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param bool hidden: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: NodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nodes_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nodes_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_nodes_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all nodes of one Instrumentation  # noqa: E501

        Returns a list of all nodes that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param bool hidden: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: NodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'name', 'type_id', 'parent_id', 'tenant_id', 'hidden', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nodes_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_nodes_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'hidden' in params:
            query_params.append(('hidden', params['hidden']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specification_history_of_instrumentation(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get the history of one specification attribute of an instrumentation.  # noqa: E501

        This might be useful for history data. The response contains a collection of historic values and when they`ve been updated. Since this can be a lot of data the service uses pagination. The history can be filtered by using a date range of source_timestamp and/or updated_at. Please consider that source_timestamp is not required and update on the attribute without giving a source_timestamp wont be included in the resulting response  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_history_of_instrumentation(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :param str key: the exact key (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param datetime source_timestamp_from: source_timestamp filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime source_timestamp_to: source_timestamp filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_from: updated_at filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_to: updated_at filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `source_timestamp` or `updated_at`, add `-` as a prefix for descending order.
        :return: SpecificationHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specification_history_of_instrumentation_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specification_history_of_instrumentation_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
            return data

    def get_specification_history_of_instrumentation_with_http_info(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get the history of one specification attribute of an instrumentation.  # noqa: E501

        This might be useful for history data. The response contains a collection of historic values and when they`ve been updated. Since this can be a lot of data the service uses pagination. The history can be filtered by using a date range of source_timestamp and/or updated_at. Please consider that source_timestamp is not required and update on the attribute without giving a source_timestamp wont be included in the resulting response  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_history_of_instrumentation_with_http_info(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :param str key: the exact key (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param datetime source_timestamp_from: source_timestamp filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime source_timestamp_to: source_timestamp filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_from: updated_at filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_to: updated_at filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `source_timestamp` or `updated_at`, add `-` as a prefix for descending order.
        :return: SpecificationHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'page', 'per_page', 'source_timestamp_from', 'source_timestamp_to', 'updated_at_from', 'updated_at_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specification_history_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_specification_history_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_specification_history_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'source_timestamp_from' in params:
            query_params.append(('source_timestamp_from', params['source_timestamp_from']))  # noqa: E501
        if 'source_timestamp_to' in params:
            query_params.append(('source_timestamp_to', params['source_timestamp_to']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/specifications/{key}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specification_keys_of_instrumentations(self, **kwargs):  # noqa: E501
        """Get existing instrumentation specification keys  # noqa: E501

        Returns the existing specification keys in all readable instrumentations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_keys_of_instrumentations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specification_keys_of_instrumentations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_specification_keys_of_instrumentations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_specification_keys_of_instrumentations_with_http_info(self, **kwargs):  # noqa: E501
        """Get existing instrumentation specification keys  # noqa: E501

        Returns the existing specification keys in all readable instrumentations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_keys_of_instrumentations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'ui_visible']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specification_keys_of_instrumentations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'ui_visible' in params:
            query_params.append(('ui_visible', params['ui_visible']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentation/specification_keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationKeys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specifications_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get specifications of an instrumentation  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationsUIVisibleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specifications_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specifications_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_specifications_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get specifications of an instrumentation  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationsUIVisibleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'ui_visible']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specifications_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_specifications_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'ui_visible' in params:
            query_params.append(('ui_visible', params['ui_visible']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/specifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationsUIVisibleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_systems_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all systems of one instrumentation  # noqa: E501

        Returns a list of all systems that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```pictures, specifications, specifications[key1,key2], tenant, parent, status, type, type.tenant, type.parent ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_systems_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SystemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_systems_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_systems_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_systems_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all systems of one instrumentation  # noqa: E501

        Returns a list of all systems that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```pictures, specifications, specifications[key1,key2], tenant, parent, status, type, type.tenant, type.parent ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_systems_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SystemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'name', 'status_id', 'type_id', 'tenant_id', 'specifications_key', 'specifications_value', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_systems_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_systems_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/systems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assets_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove assets from an instrumentation  # noqa: E501

        Remove one or more assets from an instrumentation in your accessible scope. This action requires `can_permit` permission on the instrumentation and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the assets will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_assets_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_assets_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_assets_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove assets from an instrumentation  # noqa: E501

        Remove one or more assets from an instrumentation in your accessible scope. This action requires `can_permit` permission on the instrumentation and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the assets will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assets_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_assets_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_assets_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/assets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_bill_of_materials_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove bill of materials from an instrumentation  # noqa: E501

        Remove one or more bill of materials from an instrumentation in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_bill_of_materials_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the bill of materials will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_bill_of_materials_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_bill_of_materials_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_bill_of_materials_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove bill of materials from an instrumentation  # noqa: E501

        Remove one or more bill of materials from an instrumentation in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_bill_of_materials_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the bill of materials will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_bill_of_materials_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_bill_of_materials_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_bill_of_materials_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/bill_of_materials', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove documents from an instrumentation  # noqa: E501

        Remove one or more documents from an instrumentation. This action requires `can_update` permission on the instrumentation and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove documents from an instrumentation  # noqa: E501

        Remove one or more documents from an instrumentation. This action requires `can_update` permission on the instrumentation and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_documents_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_event_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove events from an instrumentation  # noqa: E501

        Remove one or more events from an instrumentation in your accessible scope. If the event has no more related instrumentations, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events1 body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_event_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_event_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_event_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove events from an instrumentation  # noqa: E501

        Remove one or more events from an instrumentation in your accessible scope. If the event has no more related instrumentations, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events1 body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_event_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_event_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_event_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/events', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_nodes_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove nodes from an instrumentation  # noqa: E501

        Remove one or more nodes from an instrumentation in your accessible scope. This action requires `can_permit` permission on the instrumentation and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_nodes_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the nodes will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_nodes_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_nodes_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_nodes_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove nodes from an instrumentation  # noqa: E501

        Remove one or more nodes from an instrumentation in your accessible scope. This action requires `can_permit` permission on the instrumentation and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_nodes_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the nodes will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_nodes_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_nodes_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_nodes_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/nodes', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_specifications_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Delete specifications of an instrumentation  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. Multiple specification keys can be sent in the same request. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_specifications_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_specifications_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_specifications_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Delete specifications of an instrumentation  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. Multiple specification keys can be sent in the same request. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_specifications_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_specifications_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_specifications_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/specifications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_specifications_of_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of an instrumentation in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_specifications_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_specifications_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def rename_specifications_of_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of an instrumentation in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_specifications_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_specifications_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `rename_specifications_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/specifications/rename', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_assets_of_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the assets of an instrumentation  # noqa: E501

        Replaces all assets belonging to an instrumentation. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the instrumentation and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the assets will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_assets_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_assets_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def replace_assets_of_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the assets of an instrumentation  # noqa: E501

        Replaces all assets belonging to an instrumentation. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the instrumentation and on the asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the assets will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_assets_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_assets_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `replace_assets_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/assets', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_bill_of_materials_of_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the bill of materials of an instrumentation  # noqa: E501

        Replaces all bill of materials belonging to an instrumentation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_bill_of_materials_of_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the bill of materials will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_bill_of_materials_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_bill_of_materials_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def replace_bill_of_materials_of_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the bill of materials of an instrumentation  # noqa: E501

        Replaces all bill of materials belonging to an instrumentation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_bill_of_materials_of_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the bill of materials will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_bill_of_materials_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_bill_of_materials_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `replace_bill_of_materials_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/bill_of_materials', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the documents of an instrumentation  # noqa: E501

        Replaces all documents belonging to an instrumentation. You can send a list of resources that will replace all previous values. This action requires `can_udpate` permission on the instrumentation and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the documents of an instrumentation  # noqa: E501

        Replaces all documents belonging to an instrumentation. You can send a list of resources that will replace all previous values. This action requires `can_udpate` permission on the instrumentation and `can_read` permission on the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `replace_documents_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_nodes_of_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the nodes of an instrumentation  # noqa: E501

        Replaces all nodes belonging to an instrumentation in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the instrumentation and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_nodes_of_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the nodes will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_nodes_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_nodes_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def replace_nodes_of_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Replace the nodes of an instrumentation  # noqa: E501

        Replaces all nodes belonging to an instrumentation in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the instrumentation and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_nodes_of_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be replaced (required)
        :param int instrumentation_id: Id of the instrumentation of which the nodes will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_nodes_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_nodes_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `replace_nodes_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/nodes', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instrumentation(self, body, id, **kwargs):  # noqa: E501
        """Update an instrumentation  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope. To assign a parent instrumentation the user needs `can_permit` permission on the parent and on the current instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the instrumentation to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instrumentation_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instrumentation_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_instrumentation_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an instrumentation  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope. To assign a parent instrumentation the user needs `can_permit` permission on the parent and on the current instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the instrumentation to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instrumentation`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instrumentation_picture(self, image, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation picture  # noqa: E501

        Upload a new instrumentation picture. Check the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_picture(image, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instrumentation_picture_with_http_info(image, instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instrumentation_picture_with_http_info(image, instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def update_instrumentation_picture_with_http_info(self, image, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation picture  # noqa: E501

        Upload a new instrumentation picture. Check the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_picture_with_http_info(image, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image', 'instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrumentation_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image' is set
        if ('image' not in params or
                params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `update_instrumentation_picture`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `update_instrumentation_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_instrumentation_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/pictures/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instrumentation_picture_link(self, body, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation picture link  # noqa: E501

        Update an instrumentation picture link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_picture_link(body, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be updated (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instrumentation_picture_link_with_http_info(body, instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instrumentation_picture_link_with_http_info(body, instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def update_instrumentation_picture_link_with_http_info(self, body, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation picture link  # noqa: E501

        Update an instrumentation picture link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_picture_link_with_http_info(body, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be updated (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrumentation_picture_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instrumentation_picture_link`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `update_instrumentation_picture_link`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_instrumentation_picture_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/pictures/links/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instrumentation_threshold(self, body, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation threshold  # noqa: E501

        Replaces the threshold belonging to an instrumentation. This action requires `can_update` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_threshold(body, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instrumentation_threshold_with_http_info(body, instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instrumentation_threshold_with_http_info(body, instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def update_instrumentation_threshold_with_http_info(self, body, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation threshold  # noqa: E501

        Replaces the threshold belonging to an instrumentation. This action requires `can_update` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_threshold_with_http_info(body, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `update_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_specifications_of_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Update specifications of an instrumentation  # noqa: E501

        Update the specification object of an instrumentation in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationUIVisibleRequest) body: The specifications objects to patch. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_specifications_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_specifications_of_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def update_specifications_of_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Update specifications of an instrumentation  # noqa: E501

        Update the specification object of an instrumentation in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationUIVisibleRequest) body: The specifications objects to patch. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_specifications_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_specifications_of_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `update_specifications_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/specifications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_instrumentation_picture(self, image, id, **kwargs):  # noqa: E501
        """Upload an instrumentation picture  # noqa: E501

        Upload a new instrumentation picture. Checks the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_instrumentation_picture(image, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int id: Id of the instrumentation (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_instrumentation_picture_with_http_info(image, id, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_instrumentation_picture_with_http_info(image, id, **kwargs)  # noqa: E501
            return data

    def upload_instrumentation_picture_with_http_info(self, image, id, **kwargs):  # noqa: E501
        """Upload an instrumentation picture  # noqa: E501

        Upload a new instrumentation picture. Checks the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_instrumentation_picture_with_http_info(image, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int id: Id of the instrumentation (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_instrumentation_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image' is set
        if ('image' not in params or
                params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `upload_instrumentation_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `upload_instrumentation_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{id}/pictures', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
