# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class EventApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_documents_to_event(self, body, event_id, **kwargs):  # noqa: E501
        """Add documents to an event  # noqa: E501

        Add one or more documents to an event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int event_id: Id of the asset to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Add documents to an event  # noqa: E501

        Add one or more documents to an event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int event_id: Id of the asset to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `add_documents_to_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event(self, body, **kwargs):  # noqa: E501
        """Create a new event  # noqa: E501

        Event must have a name, status, type and at least one asset or an instrumentation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequest body: Event object that needs to be created. (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_event_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new event  # noqa: E501

        Event must have a name, status, type and at least one asset or an instrumentation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequest body: Event object that needs to be created. (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_for_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Create a new event for an asset  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoAssets body: Object to be created. (required)
        :param int asset_id: Id of the asset (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_for_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_for_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def create_event_for_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Create a new event for an asset  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoAssets body: Object to be created. (required)
        :param int asset_id: Id of the asset (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_for_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_event_for_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `create_event_for_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_for_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create a new event for an instrumentation  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoInstrumentations body: Object to be created. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_for_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_for_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def create_event_for_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create a new event for an instrumentation  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoInstrumentations body: Object to be created. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_for_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_event_for_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `create_event_for_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event(self, id, **kwargs):  # noqa: E501
        """Delete an event  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the event to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_event_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_event_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an event  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the event to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets_of_event(self, event_id, **kwargs):  # noqa: E501
        """Get all assets of one event  # noqa: E501

        Returns a list of all assets of an event that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_event(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_assets_of_event_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get all assets of one event  # noqa: E501

        Returns a list of all assets of an event that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_event_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'page', 'per_page', 'include', 'serial_number', 'product_id', 'product_category_id', 'parent_id', 'manufacturer_id', 'status_id', 'status_code', 'production_date', 'production_date_from', 'production_date_to', 'specifications_key', 'specifications_value', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'ownership_claimed', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_assets_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'product_id' in params:
            query_params.append(('product_id', params['product_id']))  # noqa: E501
        if 'product_category_id' in params:
            query_params.append(('product_category_id', params['product_category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'status_code' in params:
            query_params.append(('status_code', params['status_code']))  # noqa: E501
        if 'production_date' in params:
            query_params.append(('production_date', params['production_date']))  # noqa: E501
        if 'production_date_from' in params:
            query_params.append(('production_date_from', params['production_date_from']))  # noqa: E501
        if 'production_date_to' in params:
            query_params.append(('production_date_to', params['production_date_to']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'ownership_claimed' in params:
            query_params.append(('ownership_claimed', params['ownership_claimed']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_event(self, event_id, **kwargs):  # noqa: E501
        """Get all documents of an event  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_event(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_event_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get all documents of an event  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_event_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'page', 'per_page', 'include', 'name', 'status_id', 'classification_id', 'document_version', 'number', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_documents_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single event  # noqa: E501

        Get a specific event identified by the id in the URL.  Possible include values: ```assets, instrumentations, status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the event to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_event_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single event  # noqa: E501

        Get a specific event identified by the id in the URL.  Possible include values: ```assets, instrumentations, status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the event to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_event_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_id_status(self, event_id, **kwargs):  # noqa: E501
        """Get the status of a specific event  # noqa: E501

        Returns the status of the event. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_id_status(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_id_status_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_id_status_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_event_id_status_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get the status of a specific event  # noqa: E501

        Returns the status of the event. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_id_status_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_id_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_event_id_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_id_type(self, event_id, **kwargs):  # noqa: E501
        """Get the type of a specific event  # noqa: E501

        Returns the type of the event. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_id_type(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_id_type_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_id_type_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_event_id_type_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get the type of a specific event  # noqa: E501

        Returns the type of the event. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_id_type_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_id_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_event_id_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/type', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_statuses_options(self, event_id, **kwargs):  # noqa: E501
        """Get all possible statuses for the specified event  # noqa: E501

        Returns a list of all possible event statuses for the specified event. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_statuses_options(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_statuses_options_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_statuses_options_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_event_statuses_options_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get all possible statuses for the specified event  # noqa: E501

        Returns a list of all possible event statuses for the specified event. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_statuses_options_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'page', 'per_page', 'name', 'code', 'tenant_id', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_statuses_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_event_statuses_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/status-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventStatuses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_typees_options(self, event_id, **kwargs):  # noqa: E501
        """Get all possible types for the specified event  # noqa: E501

        Returns a list of all possible event types for the specified event. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_typees_options(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_typees_options_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_typees_options_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_event_typees_options_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get all possible types for the specified event  # noqa: E501

        Returns a list of all possible event types for the specified event. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_typees_options_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EventTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'page', 'per_page', 'name', 'code', 'tenant_id', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_typees_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_event_typees_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/type-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventTypes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events(self, **kwargs):  # noqa: E501
        """Get a range of events  # noqa: E501

        Returns a list of events. If the query has no matches, the response is an empty list.  Possible include values: ```assets, instrumentations, status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of events  # noqa: E501

        Returns a list of events. If the query has no matches, the response is an empty list.  Possible include values: ```assets, instrumentations, status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'name', 'type_id', 'status_id', 'start_datetime', 'start_datetime_from', 'start_datetime_to', 'end_datetime', 'end_datetime_from', 'end_datetime_to', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'start_datetime' in params:
            query_params.append(('start_datetime', params['start_datetime']))  # noqa: E501
        if 'start_datetime_from' in params:
            query_params.append(('start_datetime_from', params['start_datetime_from']))  # noqa: E501
        if 'start_datetime_to' in params:
            query_params.append(('start_datetime_to', params['start_datetime_to']))  # noqa: E501
        if 'end_datetime' in params:
            query_params.append(('end_datetime', params['end_datetime']))  # noqa: E501
        if 'end_datetime_from' in params:
            query_params.append(('end_datetime_from', params['end_datetime_from']))  # noqa: E501
        if 'end_datetime_to' in params:
            query_params.append(('end_datetime_to', params['end_datetime_to']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all events of one asset  # noqa: E501

        Returns a list of all events belonging to an asset in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_events_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_events_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all events of one asset  # noqa: E501

        Returns a list of all events belonging to an asset in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'type_id', 'status_id', 'start_datetime', 'start_datetime_from', 'start_datetime_to', 'end_datetime', 'end_datetime_from', 'end_datetime_to', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_events_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'start_datetime' in params:
            query_params.append(('start_datetime', params['start_datetime']))  # noqa: E501
        if 'start_datetime_from' in params:
            query_params.append(('start_datetime_from', params['start_datetime_from']))  # noqa: E501
        if 'start_datetime_to' in params:
            query_params.append(('start_datetime_to', params['start_datetime_to']))  # noqa: E501
        if 'end_datetime' in params:
            query_params.append(('end_datetime', params['end_datetime']))  # noqa: E501
        if 'end_datetime_from' in params:
            query_params.append(('end_datetime_from', params['end_datetime_from']))  # noqa: E501
        if 'end_datetime_to' in params:
            query_params.append(('end_datetime_to', params['end_datetime_to']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events_of_instrumentation(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all events of one instrumentation  # noqa: E501

        Returns a list of all events belonging to an instrumentation in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_instrumentation(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_events_of_instrumentation_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_events_of_instrumentation_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get all events of one instrumentation  # noqa: E501

        Returns a list of all events belonging to an instrumentation in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_instrumentation_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'name', 'type_id', 'status_id', 'start_datetime', 'start_datetime_from', 'start_datetime_to', 'end_datetime', 'end_datetime_from', 'end_datetime_to', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events_of_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_events_of_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'start_datetime' in params:
            query_params.append(('start_datetime', params['start_datetime']))  # noqa: E501
        if 'start_datetime_from' in params:
            query_params.append(('start_datetime_from', params['start_datetime_from']))  # noqa: E501
        if 'start_datetime_to' in params:
            query_params.append(('start_datetime_to', params['start_datetime_to']))  # noqa: E501
        if 'end_datetime' in params:
            query_params.append(('end_datetime', params['end_datetime']))  # noqa: E501
        if 'end_datetime_from' in params:
            query_params.append(('end_datetime_from', params['end_datetime_from']))  # noqa: E501
        if 'end_datetime_to' in params:
            query_params.append(('end_datetime_to', params['end_datetime_to']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentations_of_event(self, event_id, **kwargs):  # noqa: E501
        """Get all instrumentations of one event  # noqa: E501

        Returns a list of all instrumentations of an event that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, type, type.tenant, type.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_event(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentations_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentations_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentations_of_event_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get all instrumentations of one event  # noqa: E501

        Returns a list of all instrumentations of an event that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, type, type.tenant, type.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_event_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'page', 'per_page', 'include', 'tag', 'status_id', 'type_id', 'parent_id', 'tenant_id', 'specifications_key', 'specifications_value', 'criticality', 'accessibility', 'node_id', 'asset_status_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentations_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_instrumentations_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'criticality' in params:
            query_params.append(('criticality', params['criticality']))  # noqa: E501
        if 'accessibility' in params:
            query_params.append(('accessibility', params['accessibility']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501
        if 'asset_status_id' in params:
            query_params.append(('asset_status_id', params['asset_status_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/instrumentations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specifications_of_event(self, event_id, **kwargs):  # noqa: E501
        """Get specifications of an event  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_event(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param str key: Filter accepts '*' as wildcard
        :return: SpecificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specifications_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specifications_of_event_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_specifications_of_event_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Get specifications of an event  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_event_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int event_id: Id of the specified event (required)
        :param str key: Filter accepts '*' as wildcard
        :return: SpecificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specifications_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_specifications_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/specifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assets_from_event(self, body, event_id, **kwargs):  # noqa: E501
        """Remove assets from an event  # noqa: E501

        Remove one or more assets from an event. If the event has no more related assets or instrumentations, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int event_id: Id of the event where the asset will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_assets_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_assets_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def remove_assets_from_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Remove assets from an event  # noqa: E501

        Remove one or more assets from an event. If the event has no more related assets or instrumentations, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int event_id: Id of the event where the asset will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assets_from_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_assets_from_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `remove_assets_from_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/assets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_event(self, body, event_id, **kwargs):  # noqa: E501
        """Remove documents from an event  # noqa: E501

        Remove one or more documents from an event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int event_id: Id of the event from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Remove documents from an event  # noqa: E501

        Remove one or more documents from an event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int event_id: Id of the event from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `remove_documents_from_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_event_from_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove events from an asset  # noqa: E501

        Remove one or more events from an asset in your accessible scope. If the event has no more related assets, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_event_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_event_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_event_from_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove events from an asset  # noqa: E501

        Remove one or more events from an asset in your accessible scope. If the event has no more related assets, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_event_from_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_event_from_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_event_from_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/events', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_event_from_instrumentation(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove events from an instrumentation  # noqa: E501

        Remove one or more events from an instrumentation in your accessible scope. If the event has no more related instrumentations, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_instrumentation(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events1 body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_event_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_event_from_instrumentation_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def remove_event_from_instrumentation_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Remove events from an instrumentation  # noqa: E501

        Remove one or more events from an instrumentation in your accessible scope. If the event has no more related instrumentations, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_instrumentation_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events1 body: Resources that shall be removed. (required)
        :param int instrumentation_id: Id of the instrumentation from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_event_from_instrumentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_event_from_instrumentation`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `remove_event_from_instrumentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/events', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_instrumentations_from_event(self, body, event_id, **kwargs):  # noqa: E501
        """Remove instrumentations from an event  # noqa: E501

        Remove one or more instrumentations from an event. If the event has no more related instrumentations or assets, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_from_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int event_id: Id of the event where the instrumentation will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_instrumentations_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_instrumentations_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def remove_instrumentations_from_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Remove instrumentations from an event  # noqa: E501

        Remove one or more instrumentations from an event. If the event has no more related instrumentations or assets, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_from_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int event_id: Id of the event where the instrumentation will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_instrumentations_from_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_instrumentations_from_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `remove_instrumentations_from_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/instrumentations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_specifications_from_event(self, body, event_id, **kwargs):  # noqa: E501
        """Delete specifications of an event  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. Multiple specification keys can be sent in the same request. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int event_id: Id of the specified event (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_specifications_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_specifications_from_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def remove_specifications_from_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Delete specifications of an event  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. Multiple specification keys can be sent in the same request. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int event_id: Id of the specified event (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_specifications_from_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_specifications_from_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `remove_specifications_from_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/specifications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_specifications_of_event(self, body, event_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of an event in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int event_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_specifications_of_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_specifications_of_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def rename_specifications_of_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of an event in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int event_id: Id of the specified node (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_specifications_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_specifications_of_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `rename_specifications_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/specifications/rename', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_event(self, body, event_id, **kwargs):  # noqa: E501
        """Replace the documents of an event  # noqa: E501

        Replaces all documents belonging to an event. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int event_id: Id of the event of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Replace the documents of an event  # noqa: E501

        Replaces all documents belonging to an event. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int event_id: Id of the event of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `replace_documents_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event(self, body, id, **kwargs):  # noqa: E501
        """Update an event  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the event to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_event_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_event_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an event  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the event to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_event`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_specifications_of_event(self, body, event_id, **kwargs):  # noqa: E501
        """Update specifications of an event  # noqa: E501

        Update the specification object of an event in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of a-z A-Z 0-9 . - _ all uppercase A-Z are converted to lower-case a-z. For a key that is send mutliple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_event(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationRequest) body: The specifications objects to patch. (required)
        :param int event_id: Id of the specified event (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_specifications_of_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_specifications_of_event_with_http_info(body, event_id, **kwargs)  # noqa: E501
            return data

    def update_specifications_of_event_with_http_info(self, body, event_id, **kwargs):  # noqa: E501
        """Update specifications of an event  # noqa: E501

        Update the specification object of an event in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of a-z A-Z 0-9 . - _ all uppercase A-Z are converted to lower-case a-z. For a key that is send mutliple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_event_with_http_info(body, event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationRequest) body: The specifications objects to patch. (required)
        :param int event_id: Id of the specified event (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_specifications_of_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_specifications_of_event`")  # noqa: E501
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `update_specifications_of_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['event_id'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_id}/specifications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
