# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class DeliveryApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_assets_to_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Add assets to a delivery  # noqa: E501

        Add one or more assets to a delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int delivery_id: Id of the delivery to which the assets will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_assets_to_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_assets_to_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def add_assets_to_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Add assets to a delivery  # noqa: E501

        Add one or more assets to a delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int delivery_id: Id of the delivery to which the assets will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_assets_to_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_assets_to_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `add_assets_to_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_documents_to_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Add documents to a delivery  # noqa: E501

        Add one or more documents to a delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int delivery_id: Id of the delivery to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Add documents to a delivery  # noqa: E501

        Add one or more documents to a delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int delivery_id: Id of the delivery to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `add_documents_to_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_purchase_orders_to_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Add all purchase oders to a delivery  # noqa: E501

        Add one or more all purchase oders to a delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_purchase_orders_to_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderIDs body: Resources that shall be added. (required)
        :param int delivery_id: Id of the delivery to which the all purchase oders will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_purchase_orders_to_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_purchase_orders_to_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def add_purchase_orders_to_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Add all purchase oders to a delivery  # noqa: E501

        Add one or more all purchase oders to a delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_purchase_orders_to_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderIDs body: Resources that shall be added. (required)
        :param int delivery_id: Id of the delivery to which the all purchase oders will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_purchase_orders_to_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_purchase_orders_to_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `add_purchase_orders_to_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/purchase_orders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_delivery(self, body, **kwargs):  # noqa: E501
        """Create a new delivery  # noqa: E501

        Delivery must have a name, number, sender, receiver and a status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_delivery(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryRequest body: Delivery to create (required)
        :return: DeliveryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_delivery_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_delivery_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_delivery_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new delivery  # noqa: E501

        Delivery must have a name, number, sender, receiver and a status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_delivery_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryRequest body: Delivery to create (required)
        :return: DeliveryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeliveryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_delivery(self, id, **kwargs):  # noqa: E501
        """Delete a delivery  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_delivery(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the delivery to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_delivery_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_delivery_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_delivery_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a delivery  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_delivery_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the delivery to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets_of_delivery(self, delivery_id, **kwargs):  # noqa: E501
        """Get all assets of one delivery  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant, product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_delivery(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_of_delivery_with_http_info(delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_of_delivery_with_http_info(delivery_id, **kwargs)  # noqa: E501
            return data

    def get_assets_of_delivery_with_http_info(self, delivery_id, **kwargs):  # noqa: E501
        """Get all assets of one delivery  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant, product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_delivery_with_http_info(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_id', 'page', 'per_page', 'include', 'serial_number', 'product_id', 'category_id', 'parent_id', 'manufacturer_id', 'status_id', 'status_code', 'production_date', 'production_date_from', 'production_date_to', 'specifications_key', 'specifications_value', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'ownership_claimed', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_of_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `get_assets_of_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'product_id' in params:
            query_params.append(('product_id', params['product_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'status_code' in params:
            query_params.append(('status_code', params['status_code']))  # noqa: E501
        if 'production_date' in params:
            query_params.append(('production_date', params['production_date']))  # noqa: E501
        if 'production_date_from' in params:
            query_params.append(('production_date_from', params['production_date_from']))  # noqa: E501
        if 'production_date_to' in params:
            query_params.append(('production_date_to', params['production_date_to']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'ownership_claimed' in params:
            query_params.append(('ownership_claimed', params['ownership_claimed']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_deliveries(self, **kwargs):  # noqa: E501
        """Get a range of deliveries  # noqa: E501

        Returns a list of deliveries in your accessible scope. If the query has no matches, the response is an empty list. Only deliveries on which the user has the can_read permission are loaded  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deliveries(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param date date_of_shipment: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_from: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: DeliveriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_deliveries_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_deliveries_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_deliveries_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of deliveries  # noqa: E501

        Returns a list of deliveries in your accessible scope. If the query has no matches, the response is an empty list. Only deliveries on which the user has the can_read permission are loaded  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deliveries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param date date_of_shipment: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_from: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: DeliveriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'number', 'name', 'status_id', 'date_of_shipment', 'date_of_shipment_from', 'date_of_shipment_to', 'sender_id', 'receiver_id', 'customer_number', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deliveries" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'date_of_shipment' in params:
            query_params.append(('date_of_shipment', params['date_of_shipment']))  # noqa: E501
        if 'date_of_shipment_from' in params:
            query_params.append(('date_of_shipment_from', params['date_of_shipment_from']))  # noqa: E501
        if 'date_of_shipment_to' in params:
            query_params.append(('date_of_shipment_to', params['date_of_shipment_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'customer_number' in params:
            query_params.append(('customer_number', params['customer_number']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeliveriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_delivery_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single delivery  # noqa: E501

        Get a specific delivery in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_delivery_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the delivery to fetch (required)
        :return: DeliveryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_delivery_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_delivery_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_delivery_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single delivery  # noqa: E501

        Get a specific delivery in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_delivery_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the delivery to fetch (required)
        :return: DeliveryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_delivery_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_delivery_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeliveryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_delivery_id_status(self, delivery_id, **kwargs):  # noqa: E501
        """Get the status of the specific delivery  # noqa: E501

        Returns the status of the delivery. You can apply the query parameters listed below to get a filtered list. Required Permissions: ```can_read``` Parameters supporting translation: ```name, description```. To add a translation set Content-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_delivery_id_status(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: Id of the specified delivery (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DeliveryStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_delivery_id_status_with_http_info(delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_delivery_id_status_with_http_info(delivery_id, **kwargs)  # noqa: E501
            return data

    def get_delivery_id_status_with_http_info(self, delivery_id, **kwargs):  # noqa: E501
        """Get the status of the specific delivery  # noqa: E501

        Returns the status of the delivery. You can apply the query parameters listed below to get a filtered list. Required Permissions: ```can_read``` Parameters supporting translation: ```name, description```. To add a translation set Content-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_delivery_id_status_with_http_info(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: Id of the specified delivery (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DeliveryStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_id', 'include', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_delivery_id_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `get_delivery_id_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeliveryStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_delivery(self, delivery_id, **kwargs):  # noqa: E501
        """Get all documents of one delivery  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_delivery(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_delivery_with_http_info(delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_delivery_with_http_info(delivery_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_delivery_with_http_info(self, delivery_id, **kwargs):  # noqa: E501
        """Get all documents of one delivery  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_delivery_with_http_info(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `get_documents_of_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_purchase_orders_of_delivery(self, delivery_id, **kwargs):  # noqa: E501
        """Get all purchase orders of one delivery  # noqa: E501

        Returns a list of all all purchase oder that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_orders_of_delivery(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str quotation_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: PurchaseOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_purchase_orders_of_delivery_with_http_info(delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_purchase_orders_of_delivery_with_http_info(delivery_id, **kwargs)  # noqa: E501
            return data

    def get_purchase_orders_of_delivery_with_http_info(self, delivery_id, **kwargs):  # noqa: E501
        """Get all purchase orders of one delivery  # noqa: E501

        Returns a list of all all purchase oder that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_orders_of_delivery_with_http_info(delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int delivery_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str quotation_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: PurchaseOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_id', 'page', 'per_page', 'name', 'number', 'status_id', '_date', 'date_from', 'date_to', 'sender_id', 'receiver_id', 'quotation_id', 'customer_number', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_purchase_orders_of_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `get_purchase_orders_of_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'quotation_id' in params:
            query_params.append(('quotation_id', params['quotation_id']))  # noqa: E501
        if 'customer_number' in params:
            query_params.append(('customer_number', params['customer_number']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/purchase_orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PurchaseOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assets_from_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Remove assets from a delivery  # noqa: E501

        Remove one or more assets from a delivery in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int delivery_id: Id of the delivery from which the assets will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_assets_from_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_assets_from_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def remove_assets_from_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Remove assets from a delivery  # noqa: E501

        Remove one or more assets from a delivery in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int delivery_id: Id of the delivery from which the assets will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assets_from_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_assets_from_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `remove_assets_from_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/assets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Remove documents from a delivery  # noqa: E501

        Remove one or more documents from a delivery in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int delivery_id: Id of the delivery from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Remove documents from a delivery  # noqa: E501

        Remove one or more documents from a delivery in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int delivery_id: Id of the delivery from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `remove_documents_from_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_purchase_orders_from_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Remove purchase orders from a delivery  # noqa: E501

        Remove one or more purchase orders from a delivery in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_purchase_orders_from_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderIDs body: Resources that shall be removed. (required)
        :param int delivery_id: Id of the delivery from which the purchase orders will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_purchase_orders_from_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_purchase_orders_from_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def remove_purchase_orders_from_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Remove purchase orders from a delivery  # noqa: E501

        Remove one or more purchase orders from a delivery in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_purchase_orders_from_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderIDs body: Resources that shall be removed. (required)
        :param int delivery_id: Id of the delivery from which the purchase orders will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_purchase_orders_from_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_purchase_orders_from_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `remove_purchase_orders_from_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/purchase_orders', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_assets_of_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Replace the assets of a delivery  # noqa: E501

        Replaces all assets belonging to a delivery. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int delivery_id: Id of the delivery of which the assets will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_assets_of_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_assets_of_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def replace_assets_of_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Replace the assets of a delivery  # noqa: E501

        Replaces all assets belonging to a delivery. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int delivery_id: Id of the delivery of which the assets will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_assets_of_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_assets_of_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `replace_assets_of_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/assets', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Replace the documents of a delivery  # noqa: E501

        Replaces all documents belonging to a delivery. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int delivery_id: Id of the delivery of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Replace the documents of a delivery  # noqa: E501

        Replaces all documents belonging to a delivery. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int delivery_id: Id of the delivery of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `replace_documents_of_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_purchase_orders_of_delivery(self, body, delivery_id, **kwargs):  # noqa: E501
        """Replace the purchase orders of a delivery  # noqa: E501

        Replaces all purchase orders belonging to a delivery. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_purchase_orders_of_delivery(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderIDs body: Resources that shall be replaced (required)
        :param int delivery_id: Id of the delivery of which the purchase orders will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_purchase_orders_of_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_purchase_orders_of_delivery_with_http_info(body, delivery_id, **kwargs)  # noqa: E501
            return data

    def replace_purchase_orders_of_delivery_with_http_info(self, body, delivery_id, **kwargs):  # noqa: E501
        """Replace the purchase orders of a delivery  # noqa: E501

        Replaces all purchase orders belonging to a delivery. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_purchase_orders_of_delivery_with_http_info(body, delivery_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderIDs body: Resources that shall be replaced (required)
        :param int delivery_id: Id of the delivery of which the purchase orders will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delivery_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_purchase_orders_of_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_purchase_orders_of_delivery`")  # noqa: E501
        # verify the required parameter 'delivery_id' is set
        if ('delivery_id' not in params or
                params['delivery_id'] is None):
            raise ValueError("Missing the required parameter `delivery_id` when calling `replace_purchase_orders_of_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_id' in params:
            path_params['delivery_id'] = params['delivery_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{delivery_id}/purchase_orders', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_delivery(self, body, id, **kwargs):  # noqa: E501
        """Update a delivery  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_delivery(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the delivery to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_delivery_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_delivery_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_delivery_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a delivery  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_delivery_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the delivery to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_delivery" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_delivery`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_delivery`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/deliveries/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
