# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class ClientApplicationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_client_applications_to_edge_application(self, body, edge_device_application_id, **kwargs):  # noqa: E501
        """Add client applications to an edge device application  # noqa: E501

        Add one or more client applications to an edge device application. This action requires the edge device admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_client_applications_to_edge_application(body, edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be added. (required)
        :param int edge_device_application_id: Id of the edge device application to which the client applications will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_client_applications_to_edge_application_with_http_info(body, edge_device_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_client_applications_to_edge_application_with_http_info(body, edge_device_application_id, **kwargs)  # noqa: E501
            return data

    def add_client_applications_to_edge_application_with_http_info(self, body, edge_device_application_id, **kwargs):  # noqa: E501
        """Add client applications to an edge device application  # noqa: E501

        Add one or more client applications to an edge device application. This action requires the edge device admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_client_applications_to_edge_application_with_http_info(body, edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be added. (required)
        :param int edge_device_application_id: Id of the edge device application to which the client applications will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'edge_device_application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_client_applications_to_edge_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_client_applications_to_edge_application`")  # noqa: E501
        # verify the required parameter 'edge_device_application_id' is set
        if ('edge_device_application_id' not in params or
                params['edge_device_application_id'] is None):
            raise ValueError("Missing the required parameter `edge_device_application_id` when calling `add_client_applications_to_edge_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_device_application_id' in params:
            path_params['edge_device_application_id'] = params['edge_device_application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/edge_device/applications/{edge_device_application_id}/client_applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_technical_users_to_client_application(self, client_application_id, **kwargs):  # noqa: E501
        """Add Technical Users of Client Application  # noqa: E501

        Creates a new technical user for a client application. Email (username) and password is automatically generated and can not be defined. The generated username and password are part of the response (password can not be later received again but can be changed via password_reset endpoint of technical user).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_technical_users_to_client_application(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :return: TechnicalUserCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_technical_users_to_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_technical_users_to_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
            return data

    def add_technical_users_to_client_application_with_http_info(self, client_application_id, **kwargs):  # noqa: E501
        """Add Technical Users of Client Application  # noqa: E501

        Creates a new technical user for a client application. Email (username) and password is automatically generated and can not be defined. The generated username and password are part of the response (password can not be later received again but can be changed via password_reset endpoint of technical user).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_technical_users_to_client_application_with_http_info(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :return: TechnicalUserCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_technical_users_to_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `add_technical_users_to_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/technical_users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TechnicalUserCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_users_to_client_application_user_role(self, body, client_application_id, userrole_id, **kwargs):  # noqa: E501
        """Add users to a client application user role  # noqa: E501

        Add one or more users to a user role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_client_application_user_role(body, client_application_id, userrole_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserIDs body: Resources that shall be added. (required)
        :param int client_application_id: The resource defined in the URL (required)
        :param int userrole_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_users_to_client_application_user_role_with_http_info(body, client_application_id, userrole_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_users_to_client_application_user_role_with_http_info(body, client_application_id, userrole_id, **kwargs)  # noqa: E501
            return data

    def add_users_to_client_application_user_role_with_http_info(self, body, client_application_id, userrole_id, **kwargs):  # noqa: E501
        """Add users to a client application user role  # noqa: E501

        Add one or more users to a user role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_users_to_client_application_user_role_with_http_info(body, client_application_id, userrole_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserIDs body: Resources that shall be added. (required)
        :param int client_application_id: The resource defined in the URL (required)
        :param int userrole_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'client_application_id', 'userrole_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_users_to_client_application_user_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_users_to_client_application_user_role`")  # noqa: E501
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `add_users_to_client_application_user_role`")  # noqa: E501
        # verify the required parameter 'userrole_id' is set
        if ('userrole_id' not in params or
                params['userrole_id'] is None):
            raise ValueError("Missing the required parameter `userrole_id` when calling `add_users_to_client_application_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'userrole_id' in params:
            path_params['userrole_id'] = params['userrole_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/roles/{userrole_id}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_client_application(self, body, **kwargs):  # noqa: E501
        """Create a new client_application  # noqa: E501

        Create a new client_application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_application(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationRequest body: ClientApplication object that needs to be created. name and contact_person are required. (required)
        :return: ClientApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_client_application_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_client_application_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_client_application_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new client_application  # noqa: E501

        Create a new client_application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_application_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationRequest body: ClientApplication object that needs to be created. name and contact_person are required. (required)
        :return: ClientApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_webhook_to_client_application(self, body, client_application_id, **kwargs):  # noqa: E501
        """Create a new webhook for the Client Application  # noqa: E501

        Create a new web hook to the client application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webhook_to_client_application(body, client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebhookRequest body: Webhook object that needs to be created. url and event_types are required. (required)
        :param int client_application_id: Id of the client_application to update (required)
        :return: WebhookCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_webhook_to_client_application_with_http_info(body, client_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_webhook_to_client_application_with_http_info(body, client_application_id, **kwargs)  # noqa: E501
            return data

    def create_webhook_to_client_application_with_http_info(self, body, client_application_id, **kwargs):  # noqa: E501
        """Create a new webhook for the Client Application  # noqa: E501

        Create a new web hook to the client application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webhook_to_client_application_with_http_info(body, client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebhookRequest body: Webhook object that needs to be created. url and event_types are required. (required)
        :param int client_application_id: Id of the client_application to update (required)
        :return: WebhookCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'client_application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_webhook_to_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_webhook_to_client_application`")  # noqa: E501
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `create_webhook_to_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_client_application(self, id, **kwargs):  # noqa: E501
        """Delete an client_application  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_application(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the client_application to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_client_application_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_client_application_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_client_application_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an client_application  # noqa: E501

        Delete a specific resource in your accessible scope, identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_application_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the client_application to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_users_from_client_application_user_role(self, body, client_application_id, userrole_id, **kwargs):  # noqa: E501
        """Remove users from a client application user role  # noqa: E501

        Remove one or more users from an user role. To work with roles, admin role is required.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_from_client_application_user_role(body, client_application_id, userrole_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserIDs body: Resources that shall be removed. (required)
        :param int client_application_id: The resource defined in the URL (required)
        :param int userrole_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_users_from_client_application_user_role_with_http_info(body, client_application_id, userrole_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_users_from_client_application_user_role_with_http_info(body, client_application_id, userrole_id, **kwargs)  # noqa: E501
            return data

    def delete_users_from_client_application_user_role_with_http_info(self, body, client_application_id, userrole_id, **kwargs):  # noqa: E501
        """Remove users from a client application user role  # noqa: E501

        Remove one or more users from an user role. To work with roles, admin role is required.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_from_client_application_user_role_with_http_info(body, client_application_id, userrole_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserIDs body: Resources that shall be removed. (required)
        :param int client_application_id: The resource defined in the URL (required)
        :param int userrole_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'client_application_id', 'userrole_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_users_from_client_application_user_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_users_from_client_application_user_role`")  # noqa: E501
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `delete_users_from_client_application_user_role`")  # noqa: E501
        # verify the required parameter 'userrole_id' is set
        if ('userrole_id' not in params or
                params['userrole_id'] is None):
            raise ValueError("Missing the required parameter `userrole_id` when calling `delete_users_from_client_application_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'userrole_id' in params:
            path_params['userrole_id'] = params['userrole_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/roles/{userrole_id}/users', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_webhook(self, client_application_id, id, **kwargs):  # noqa: E501
        """Delete a webhook  # noqa: E501

        Delete a specific resource identified by the id in the URL. Required Permissions: ```can_delete```.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application where webhook to update (required)
        :param int id: Id of the webhook to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_webhook_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_webhook_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
            return data

    def delete_webhook_with_http_info(self, client_application_id, id, **kwargs):  # noqa: E501
        """Delete a webhook  # noqa: E501

        Delete a specific resource identified by the id in the URL. Required Permissions: ```can_delete```.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook_with_http_info(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application where webhook to update (required)
        :param int id: Id of the webhook to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `delete_webhook`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_keys_of_client_application(self, client_application_id, **kwargs):  # noqa: E501
        """GetAPI Keys of Client Application  # noqa: E501

        Returns a list of api_keys of an client application. If the query has no matches, the response is an empty list. Only api_keys on which the user has the can_read permission are loaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_keys_of_client_application(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str api_key: Filter accepts `*` as wildcard
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_from_from: Expected date format is YYYY-MM-DD
        :param date valid_from_to: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_until_from: Expected date format is YYYY-MM-DD
        :param date valid_until_to: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ClientApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_keys_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_keys_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
            return data

    def get_api_keys_of_client_application_with_http_info(self, client_application_id, **kwargs):  # noqa: E501
        """GetAPI Keys of Client Application  # noqa: E501

        Returns a list of api_keys of an client application. If the query has no matches, the response is an empty list. Only api_keys on which the user has the can_read permission are loaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_keys_of_client_application_with_http_info(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str api_key: Filter accepts `*` as wildcard
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_from_from: Expected date format is YYYY-MM-DD
        :param date valid_from_to: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_until_from: Expected date format is YYYY-MM-DD
        :param date valid_until_to: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ClientApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'page', 'per_page', 'api_key', 'valid_from', 'valid_from_from', 'valid_from_to', 'valid_until', 'valid_until_from', 'valid_until_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_keys_of_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_api_keys_of_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_from_from' in params:
            query_params.append(('valid_from_from', params['valid_from_from']))  # noqa: E501
        if 'valid_from_to' in params:
            query_params.append(('valid_from_to', params['valid_from_to']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_until_from' in params:
            query_params.append(('valid_until_from', params['valid_until_from']))  # noqa: E501
        if 'valid_until_to' in params:
            query_params.append(('valid_until_to', params['valid_until_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/api_keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_application_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single client_application  # noqa: E501

        Get a specific client_application in your accessible scope, identified by the id in the URL. Possible include values: ```technical_users```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_application_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the client_application to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: ClientApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_application_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_application_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_client_application_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single client_application  # noqa: E501

        Get a specific client_application in your accessible scope, identified by the id in the URL. Possible include values: ```technical_users```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_application_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the client_application to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: ClientApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_application_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_client_application_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_applications(self, **kwargs):  # noqa: E501
        """Get a range of client_applications  # noqa: E501

        Returns a list of client_applications in your accessible scope. If the query has no matches, the response is an empty list. Only client_applications on which the user has the can_read permission are loaded. Possible include values: ```technical_users```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_applications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str contact_person_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ClientApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_applications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_client_applications_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_client_applications_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of client_applications  # noqa: E501

        Returns a list of client_applications in your accessible scope. If the query has no matches, the response is an empty list. Only client_applications on which the user has the can_read permission are loaded. Possible include values: ```technical_users```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_applications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str contact_person_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ClientApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'name', 'contact_person_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_applications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'contact_person_id' in params:
            query_params.append(('contact_person_id', params['contact_person_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_applications_of_edge_device_application(self, edge_device_application_id, **kwargs):  # noqa: E501
        """Get all client applications of one edge device application  # noqa: E501

        Returns a list of all client applications associated with the selected edge device application. Possible include values: ```technical_user``` You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_applications_of_edge_device_application(edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int edge_device_application_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: ClientApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_applications_of_edge_device_application_with_http_info(edge_device_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_applications_of_edge_device_application_with_http_info(edge_device_application_id, **kwargs)  # noqa: E501
            return data

    def get_client_applications_of_edge_device_application_with_http_info(self, edge_device_application_id, **kwargs):  # noqa: E501
        """Get all client applications of one edge device application  # noqa: E501

        Returns a list of all client applications associated with the selected edge device application. Possible include values: ```technical_user``` You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_applications_of_edge_device_application_with_http_info(edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int edge_device_application_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: ClientApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_device_application_id', 'page', 'per_page', 'include', 'name', 'code', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_applications_of_edge_device_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_device_application_id' is set
        if ('edge_device_application_id' not in params or
                params['edge_device_application_id'] is None):
            raise ValueError("Missing the required parameter `edge_device_application_id` when calling `get_client_applications_of_edge_device_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_device_application_id' in params:
            path_params['edge_device_application_id'] = params['edge_device_application_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/edge_device/applications/{edge_device_application_id}/client_applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_current_client_application(self, **kwargs):  # noqa: E501
        """Get current client_application  # noqa: E501

        Returns current client application used to access the api.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_client_application(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClientApplicationPublicResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_current_client_application_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_current_client_application_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_current_client_application_with_http_info(self, **kwargs):  # noqa: E501
        """Get current client_application  # noqa: E501

        Returns current client application used to access the api.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_client_application_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClientApplicationPublicResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_client_application" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/current', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientApplicationPublicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_device_applications_of_client_application(self, client_application_id, **kwargs):  # noqa: E501
        """Get all edge devices applications for an client application  # noqa: E501

        Returns a list of all edge devices applications of an client application. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_device_applications_of_client_application(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: id of the client application to fetch (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str edge_device_type_id: One or multiple ids (comma list). Expected id format is integer
        :param str software_version_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EdgeDeviceApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_device_applications_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_device_applications_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
            return data

    def get_edge_device_applications_of_client_application_with_http_info(self, client_application_id, **kwargs):  # noqa: E501
        """Get all edge devices applications for an client application  # noqa: E501

        Returns a list of all edge devices applications of an client application. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_device_applications_of_client_application_with_http_info(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: id of the client application to fetch (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str code: Filter accepts `*` as wildcard
        :param str edge_device_type_id: One or multiple ids (comma list). Expected id format is integer
        :param str software_version_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: EdgeDeviceApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'page', 'per_page', 'name', 'code', 'edge_device_type_id', 'software_version_id', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_device_applications_of_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_edge_device_applications_of_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'edge_device_type_id' in params:
            query_params.append(('edge_device_type_id', params['edge_device_type_id']))  # noqa: E501
        if 'software_version_id' in params:
            query_params.append(('software_version_id', params['software_version_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/edge_device/applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDeviceApplicationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_technical_users_of_client_application(self, client_application_id, **kwargs):  # noqa: E501
        """Get Technical Users of Client Application  # noqa: E501

        Returns a list of technical of an client application. If the query has no matches, the response is an empty list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_technical_users_of_client_application(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str email: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: TechnicalUsersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_technical_users_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_technical_users_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
            return data

    def get_technical_users_of_client_application_with_http_info(self, client_application_id, **kwargs):  # noqa: E501
        """Get Technical Users of Client Application  # noqa: E501

        Returns a list of technical of an client application. If the query has no matches, the response is an empty list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_technical_users_of_client_application_with_http_info(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str email: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: TechnicalUsersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'page', 'per_page', 'email', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_technical_users_of_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_technical_users_of_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/technical_users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TechnicalUsersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_users_of_client_application_user_role(self, client_application_id, userrole_id, **kwargs):  # noqa: E501
        """Get all users of a user role assigned to a client application  # noqa: E501

        Returns a list of all users that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_of_client_application_user_role(client_application_id, userrole_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :param int userrole_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str first_name: Filter accepts `*` as wildcard
        :param str last_name: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: UsersPublicResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_of_client_application_user_role_with_http_info(client_application_id, userrole_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_users_of_client_application_user_role_with_http_info(client_application_id, userrole_id, **kwargs)  # noqa: E501
            return data

    def get_users_of_client_application_user_role_with_http_info(self, client_application_id, userrole_id, **kwargs):  # noqa: E501
        """Get all users of a user role assigned to a client application  # noqa: E501

        Returns a list of all users that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_of_client_application_user_role_with_http_info(client_application_id, userrole_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: The resource defined in the URL (required)
        :param int userrole_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str first_name: Filter accepts `*` as wildcard
        :param str last_name: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: UsersPublicResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'userrole_id', 'page', 'per_page', 'first_name', 'last_name', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users_of_client_application_user_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_users_of_client_application_user_role`")  # noqa: E501
        # verify the required parameter 'userrole_id' is set
        if ('userrole_id' not in params or
                params['userrole_id'] is None):
            raise ValueError("Missing the required parameter `userrole_id` when calling `get_users_of_client_application_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'userrole_id' in params:
            path_params['userrole_id'] = params['userrole_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'first_name' in params:
            query_params.append(('first_name', params['first_name']))  # noqa: E501
        if 'last_name' in params:
            query_params.append(('last_name', params['last_name']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/roles/{userrole_id}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UsersPublicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhook_by_id(self, client_application_id, id, **kwargs):  # noqa: E501
        """Get a single webhook  # noqa: E501

        Get a specific webhook identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_by_id(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application where webhook to fetch (required)
        :param int id: Id of the webhook to fetch (required)
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhook_by_id_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhook_by_id_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
            return data

    def get_webhook_by_id_with_http_info(self, client_application_id, id, **kwargs):  # noqa: E501
        """Get a single webhook  # noqa: E501

        Get a specific webhook identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_by_id_with_http_info(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application where webhook to fetch (required)
        :param int id: Id of the webhook to fetch (required)
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_webhook_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_webhook_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhook_events(self, client_application_id, id, **kwargs):  # noqa: E501
        """Get events of a webhook  # noqa: E501

        Get webhook events. Events are the messages that are send to the webhok URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_events(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application where webhook is registered (required)
        :param int id: Id of the webhook (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str status: Filter by status - no wildcard support
        :param str event_type: Filter by event type - no wildcard support
        :param date occurred_at: Expected date format is YYYY-MM-DD
        :param str occurred_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str occurred_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: WebhookEventResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhook_events_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhook_events_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
            return data

    def get_webhook_events_with_http_info(self, client_application_id, id, **kwargs):  # noqa: E501
        """Get events of a webhook  # noqa: E501

        Get webhook events. Events are the messages that are send to the webhok URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_events_with_http_info(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application where webhook is registered (required)
        :param int id: Id of the webhook (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str status: Filter by status - no wildcard support
        :param str event_type: Filter by event type - no wildcard support
        :param date occurred_at: Expected date format is YYYY-MM-DD
        :param str occurred_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str occurred_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: WebhookEventResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'id', 'page', 'per_page', 'status', 'event_type', 'occurred_at', 'occurred_at_from', 'occurred_at_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_webhook_events`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_webhook_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'event_type' in params:
            query_params.append(('event_type', params['event_type']))  # noqa: E501
        if 'occurred_at' in params:
            query_params.append(('occurred_at', params['occurred_at']))  # noqa: E501
        if 'occurred_at_from' in params:
            query_params.append(('occurred_at_from', params['occurred_at_from']))  # noqa: E501
        if 'occurred_at_to' in params:
            query_params.append(('occurred_at_to', params['occurred_at_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks/{id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookEventResponses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhooks_of_client_application(self, client_application_id, **kwargs):  # noqa: E501
        """Get webhooks of Client Application  # noqa: E501

        Returns a list of webhooks of an client application. If the query has no matches, the response is an empty list. Only webhooks on which the user has the can_read permission are loaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhooks_of_client_application(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application to update (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: WebhookResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhooks_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhooks_of_client_application_with_http_info(client_application_id, **kwargs)  # noqa: E501
            return data

    def get_webhooks_of_client_application_with_http_info(self, client_application_id, **kwargs):  # noqa: E501
        """Get webhooks of Client Application  # noqa: E501

        Returns a list of webhooks of an client application. If the query has no matches, the response is an empty list. Only webhooks on which the user has the can_read permission are loaded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhooks_of_client_application_with_http_info(client_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application to update (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: WebhookResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'page', 'per_page', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhooks_of_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `get_webhooks_of_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookResponses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_client_applications_of_edge_device_application(self, body, edge_device_application_id, **kwargs):  # noqa: E501
        """Remove client applications from an edge device application  # noqa: E501

        Remove one or more client applications from an edge device application. This action requires the edge device admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_client_applications_of_edge_device_application(body, edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be removed. (required)
        :param int edge_device_application_id: Id of the edge device application from which the client applications will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_client_applications_of_edge_device_application_with_http_info(body, edge_device_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_client_applications_of_edge_device_application_with_http_info(body, edge_device_application_id, **kwargs)  # noqa: E501
            return data

    def remove_client_applications_of_edge_device_application_with_http_info(self, body, edge_device_application_id, **kwargs):  # noqa: E501
        """Remove client applications from an edge device application  # noqa: E501

        Remove one or more client applications from an edge device application. This action requires the edge device admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_client_applications_of_edge_device_application_with_http_info(body, edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be removed. (required)
        :param int edge_device_application_id: Id of the edge device application from which the client applications will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'edge_device_application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_client_applications_of_edge_device_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_client_applications_of_edge_device_application`")  # noqa: E501
        # verify the required parameter 'edge_device_application_id' is set
        if ('edge_device_application_id' not in params or
                params['edge_device_application_id'] is None):
            raise ValueError("Missing the required parameter `edge_device_application_id` when calling `remove_client_applications_of_edge_device_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_device_application_id' in params:
            path_params['edge_device_application_id'] = params['edge_device_application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/edge_device/applications/{edge_device_application_id}/client_applications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_client_applications_of_edge_device_application(self, body, edge_device_application_id, **kwargs):  # noqa: E501
        """Replace the client applications of an edge device application  # noqa: E501

        Replaces all client applications belonging to an edge device application. You can send a list of resources that will replace all previous values. This action requires the edge device admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_client_applications_of_edge_device_application(body, edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be replaced (required)
        :param int edge_device_application_id: Id of the edge device application of which the client applications will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_client_applications_of_edge_device_application_with_http_info(body, edge_device_application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_client_applications_of_edge_device_application_with_http_info(body, edge_device_application_id, **kwargs)  # noqa: E501
            return data

    def replace_client_applications_of_edge_device_application_with_http_info(self, body, edge_device_application_id, **kwargs):  # noqa: E501
        """Replace the client applications of an edge device application  # noqa: E501

        Replaces all client applications belonging to an edge device application. You can send a list of resources that will replace all previous values. This action requires the edge device admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_client_applications_of_edge_device_application_with_http_info(body, edge_device_application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationIDs body: Resources that shall be replaced (required)
        :param int edge_device_application_id: Id of the edge device application of which the client applications will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'edge_device_application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_client_applications_of_edge_device_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_client_applications_of_edge_device_application`")  # noqa: E501
        # verify the required parameter 'edge_device_application_id' is set
        if ('edge_device_application_id' not in params or
                params['edge_device_application_id'] is None):
            raise ValueError("Missing the required parameter `edge_device_application_id` when calling `replace_client_applications_of_edge_device_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_device_application_id' in params:
            path_params['edge_device_application_id'] = params['edge_device_application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/edge_device/applications/{edge_device_application_id}/client_applications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resend_webhook_events(self, body, client_application_id, id, **kwargs):  # noqa: E501
        """resend Webhook Events  # noqa: E501

        Trigger the resend of webhook events  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_webhook_events(body, client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebhookEventIDs body: ids of the events that should be resend. Events that are currently in state pending are ignored are required. (required)
        :param int client_application_id: Id of the client_application where webhook is registered (required)
        :param int id: Id of the webhook (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resend_webhook_events_with_http_info(body, client_application_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resend_webhook_events_with_http_info(body, client_application_id, id, **kwargs)  # noqa: E501
            return data

    def resend_webhook_events_with_http_info(self, body, client_application_id, id, **kwargs):  # noqa: E501
        """resend Webhook Events  # noqa: E501

        Trigger the resend of webhook events  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_webhook_events_with_http_info(body, client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebhookEventIDs body: ids of the events that should be resend. Events that are currently in state pending are ignored are required. (required)
        :param int client_application_id: Id of the client_application where webhook is registered (required)
        :param int id: Id of the webhook (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'client_application_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_webhook_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `resend_webhook_events`")  # noqa: E501
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `resend_webhook_events`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resend_webhook_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks/{id}/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_secret_webhook(self, client_application_id, id, **kwargs):  # noqa: E501
        """Reset the secret property of the webhook  # noqa: E501

        Reset the secret property of the webhook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_secret_webhook(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application to update (required)
        :param int id: Id of the webhook to update (required)
        :return: WebhookSecretResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_secret_webhook_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_secret_webhook_with_http_info(client_application_id, id, **kwargs)  # noqa: E501
            return data

    def reset_secret_webhook_with_http_info(self, client_application_id, id, **kwargs):  # noqa: E501
        """Reset the secret property of the webhook  # noqa: E501

        Reset the secret property of the webhook  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_secret_webhook_with_http_info(client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int client_application_id: Id of the client_application to update (required)
        :param int id: Id of the webhook to update (required)
        :return: WebhookSecretResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_application_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_secret_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `reset_secret_webhook`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `reset_secret_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks/{id}/reset_secret', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookSecretResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_application(self, body, id, **kwargs):  # noqa: E501
        """Update an client_application  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_application(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the client_application to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_application_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_application_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_client_application_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an client_application  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_application_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientApplicationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the client_application to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_client_application`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_client_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_webhook(self, body, client_application_id, id, **kwargs):  # noqa: E501
        """Update a webhook  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webhook(body, client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebhookRequest body: Parameters that shall be updated. (required)
        :param int client_application_id: Id of the client_application to update (required)
        :param int id: Id of the webhook to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_webhook_with_http_info(body, client_application_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_webhook_with_http_info(body, client_application_id, id, **kwargs)  # noqa: E501
            return data

    def update_webhook_with_http_info(self, body, client_application_id, id, **kwargs):  # noqa: E501
        """Update a webhook  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webhook_with_http_info(body, client_application_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebhookRequest body: Parameters that shall be updated. (required)
        :param int client_application_id: Id of the client_application to update (required)
        :param int id: Id of the webhook to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'client_application_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_webhook`")  # noqa: E501
        # verify the required parameter 'client_application_id' is set
        if ('client_application_id' not in params or
                params['client_application_id'] is None):
            raise ValueError("Missing the required parameter `client_application_id` when calling `update_webhook`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_application_id' in params:
            path_params['client_application_id'] = params['client_application_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/client_applications/{client_application_id}/webhooks/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
