# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class AssetApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_add_ons_to_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Add add_ons to an asset  # noqa: E501

        Add one or more add_ons to an asset. This action requires `can_permit` permission on the asset and on the add_on.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_add_ons_to_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddOnIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the add_ons will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_add_ons_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_add_ons_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def add_add_ons_to_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Add add_ons to an asset  # noqa: E501

        Add one or more add_ons to an asset. This action requires `can_permit` permission on the asset and on the add_on.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_add_ons_to_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddOnIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the add_ons will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_add_ons_to_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_add_ons_to_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_add_ons_to_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/add_ons', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_asset_picture_link(self, body, id, **kwargs):  # noqa: E501
        """Add a link as asset picture  # noqa: E501

        Add an external resource as asset picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_asset_picture_link(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be created (required)
        :param int id: Id of the asset (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_asset_picture_link_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_asset_picture_link_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def add_asset_picture_link_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Add a link as asset picture  # noqa: E501

        Add an external resource as asset picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_asset_picture_link_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be created (required)
        :param int id: Id of the asset (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_asset_picture_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_asset_picture_link`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_asset_picture_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}/pictures/links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_deliveries_to_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Add deliveries to an asset  # noqa: E501

        Add one or more deliveries to an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_deliveries_to_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the deliveries will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_deliveries_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_deliveries_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def add_deliveries_to_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Add deliveries to an asset  # noqa: E501

        Add one or more deliveries to an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_deliveries_to_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the deliveries will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_deliveries_to_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_deliveries_to_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_deliveries_to_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/deliveries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_documents_to_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Add documents to an asset  # noqa: E501

        Add one or more documents to an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Add documents to an asset  # noqa: E501

        Add one or more documents to an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_documents_to_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_instrumentations_to_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Add instrumentations to an asset  # noqa: E501

        Add one or more instrumentations to an asset. This action requires `can_permit` permission on the asset and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentations_to_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the instrumentations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_instrumentations_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_instrumentations_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def add_instrumentations_to_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Add instrumentations to an asset  # noqa: E501

        Add one or more instrumentations to an asset. This action requires `can_permit` permission on the asset and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentations_to_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the instrumentations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_instrumentations_to_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_instrumentations_to_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_instrumentations_to_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/instrumentations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_nodes_to_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Add nodes to an asset  # noqa: E501

        Add one or more nodes to an asset. This action requires `can_permit` permission on the asset and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_nodes_to_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the nodes will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_nodes_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_nodes_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def add_nodes_to_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Add nodes to an asset  # noqa: E501

        Add one or more nodes to an asset. This action requires `can_permit` permission on the asset and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_nodes_to_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the nodes will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_nodes_to_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_nodes_to_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_nodes_to_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_softwares_to_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Add software to an asset  # noqa: E501

        Add one or more software to an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_softwares_to_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the software will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_softwares_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_softwares_to_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def add_softwares_to_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Add software to an asset  # noqa: E501

        Add one or more software to an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_softwares_to_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareIDs body: Resources that shall be added. (required)
        :param int asset_id: Id of the asset to which the software will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_softwares_to_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_softwares_to_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_softwares_to_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/softwares', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_asset(self, body, **kwargs):  # noqa: E501
        """Create a new asset  # noqa: E501

        Create a new asset. An asset is an instance of a product and therefore needs to refer to one when creating it. The serialnumber of the given asset needs to be unique within the products manufacturer scope. The asset will not be created when this constraint is violated. The user gains `can_read`, `can_update`, `can_delete`, `can_permit` per default on the newly created asset. To assign a parent asset the user needs `can_permit` permission on the parent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetRequest body: Asset object that needs to be created. serial_number, product are required (required)
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_asset_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_asset_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_asset_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new asset  # noqa: E501

        Create a new asset. An asset is an instance of a product and therefore needs to refer to one when creating it. The serialnumber of the given asset needs to be unique within the products manufacturer scope. The asset will not be created when this constraint is violated. The user gains `can_read`, `can_update`, `can_delete`, `can_permit` per default on the newly created asset. To assign a parent asset the user needs `can_permit` permission on the parent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetRequest body: Asset object that needs to be created. serial_number, product are required (required)
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_asset_container(self, body, id, **kwargs):  # noqa: E501
        """Create an export for a standard container  # noqa: E501

        Creates a data export for asset container, currenty only the VDI 2770 standard is supported  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_container(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContainerExportRequest body: Container that should be created. (required)
        :param int id: Id of the asset (required)
        :return: DataExportsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_asset_container_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_asset_container_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def create_asset_container_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Create an export for a standard container  # noqa: E501

        Creates a data export for asset container, currenty only the VDI 2770 standard is supported  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_container_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContainerExportRequest body: Container that should be created. (required)
        :param int id: Id of the asset (required)
        :return: DataExportsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_asset_container`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_asset_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}/containers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataExportsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_asset_value_objects(self, body, asset_id, **kwargs):  # noqa: E501
        """Create asset value objects  # noqa: E501

        Store value objects measured by an asset. For performance reasons, this endpoint behaves somewhat differently than normal endpoints:  * The data passed to this endpoint is processed asynchronously. * This endpoint always returns an empty response with status 204 No Content. * The data will be validated during processing. Invalid data will be dropped silently. * The request size is limited to 500kb, requests larger then 500kb will get an \"413 Payload Too Large\" error.  Data validations and manipultation:    * Keys can only consist of the charaters [a-z A-Z 0-9 . - _ ].   * Keys will be converted to lower case strings.   * Keys must be between 1 and 128 characters long.   * The timestamp is not mandatory and will be set to the time the value was transmitted to the server (This only works if the value objects get transfered one at a time, if you send multiple value objects without timestamp at once, all value objects will get the same timestamp and there for only the last one will be stored)  Difference to path /assets/{asset_id}/values is that the values given here are json objects and not numeric values, the json objects can have any structure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_value_objects(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetValueObjectsRequest body: Values to store to an asset. (required)
        :param int asset_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_asset_value_objects_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_asset_value_objects_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def create_asset_value_objects_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Create asset value objects  # noqa: E501

        Store value objects measured by an asset. For performance reasons, this endpoint behaves somewhat differently than normal endpoints:  * The data passed to this endpoint is processed asynchronously. * This endpoint always returns an empty response with status 204 No Content. * The data will be validated during processing. Invalid data will be dropped silently. * The request size is limited to 500kb, requests larger then 500kb will get an \"413 Payload Too Large\" error.  Data validations and manipultation:    * Keys can only consist of the charaters [a-z A-Z 0-9 . - _ ].   * Keys will be converted to lower case strings.   * Keys must be between 1 and 128 characters long.   * The timestamp is not mandatory and will be set to the time the value was transmitted to the server (This only works if the value objects get transfered one at a time, if you send multiple value objects without timestamp at once, all value objects will get the same timestamp and there for only the last one will be stored)  Difference to path /assets/{asset_id}/values is that the values given here are json objects and not numeric values, the json objects can have any structure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_value_objects_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetValueObjectsRequest body: Values to store to an asset. (required)
        :param int asset_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset_value_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_asset_value_objects`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `create_asset_value_objects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/value_objects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_asset_values(self, body, asset_id, **kwargs):  # noqa: E501
        """Create asset values  # noqa: E501

        Store values measured by an asset. For performance reasons, this endpoint behaves somewhat differently than normal endpoints:  * The data passed to this endpoint is processed asynchronously. * This endpoint always returns an empty response with status 204 No Content. * The data will be validated during processing. Invalid data will be dropped silently. * The request size is limited to 500kb, requests larger then 500kb will get an \"413 Payload Too Large\" error.  Data validations and manipultation:    * Keys and groups can only consist of the charaters [a-z A-Z 0-9 . - _ ].   * Keys and groups will be converted to lower case strings.   * Keys and groups must be between 1 and 128 characters long.   * Units can be passed as id or code. See the units endpoint for all available units.   * The timestamp is not mandatory and will be set to the time the value was transmitted to the server (This only works if the values get transfered one at a time, if you send multiple values without timestamp at once, all values will get the same timestamp and there for only the last one will be stored)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_values(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetValuesRequest body: Values to store to an asset. (required)
        :param int asset_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_asset_values_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_asset_values_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def create_asset_values_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Create asset values  # noqa: E501

        Store values measured by an asset. For performance reasons, this endpoint behaves somewhat differently than normal endpoints:  * The data passed to this endpoint is processed asynchronously. * This endpoint always returns an empty response with status 204 No Content. * The data will be validated during processing. Invalid data will be dropped silently. * The request size is limited to 500kb, requests larger then 500kb will get an \"413 Payload Too Large\" error.  Data validations and manipultation:    * Keys and groups can only consist of the charaters [a-z A-Z 0-9 . - _ ].   * Keys and groups will be converted to lower case strings.   * Keys and groups must be between 1 and 128 characters long.   * Units can be passed as id or code. See the units endpoint for all available units.   * The timestamp is not mandatory and will be set to the time the value was transmitted to the server (This only works if the values get transfered one at a time, if you send multiple values without timestamp at once, all values will get the same timestamp and there for only the last one will be stored)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_values_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetValuesRequest body: Values to store to an asset. (required)
        :param int asset_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_asset_values`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `create_asset_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/values', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_for_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Create a new event for an asset  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoAssets body: Object to be created. (required)
        :param int asset_id: Id of the asset (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_for_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_for_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def create_event_for_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Create a new event for an asset  # noqa: E501

        Events must have a name, and can have a start_datetime (if not provided, the date of creation will be used as default value), end_datetime, event_type, event_status, description and responsible  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_for_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventRequestNoAssets body: Object to be created. (required)
        :param int asset_id: Id of the asset (required)
        :return: EventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_for_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_event_for_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `create_event_for_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_asset(self, id, **kwargs):  # noqa: E501
        """Delete an asset  # noqa: E501

        Delete a specific resource identified by the id in the URL. Required Permissions: ```can_delete```.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the asset to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_asset_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_asset_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_asset_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an asset  # noqa: E501

        Delete a specific resource identified by the id in the URL. Required Permissions: ```can_delete```.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the asset to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_asset_picture(self, asset_id, id, **kwargs):  # noqa: E501
        """Delete an asset picture  # noqa: E501

        Delete an asset picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_picture(asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_asset_picture_with_http_info(asset_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_asset_picture_with_http_info(asset_id, id, **kwargs)  # noqa: E501
            return data

    def delete_asset_picture_with_http_info(self, asset_id, id, **kwargs):  # noqa: E501
        """Delete an asset picture  # noqa: E501

        Delete an asset picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_picture_with_http_info(asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `delete_asset_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_asset_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/pictures/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_specifications_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Delete specifications of an asset  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. Multiple specification keys can be sent in the same request. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_specifications_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int asset_id: Id of the specified asset (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_specifications_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_specifications_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def delete_specifications_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Delete specifications of an asset  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. Multiple specification keys can be sent in the same request. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_specifications_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int asset_id: Id of the specified asset (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_specifications_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_specifications_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `delete_specifications_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/specifications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_asset_picture(self, asset_id, id, **kwargs):  # noqa: E501
        """Download an asset picture  # noqa: E501

        Download an asset picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_asset_picture(asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_asset_picture_with_http_info(asset_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_asset_picture_with_http_info(asset_id, id, **kwargs)  # noqa: E501
            return data

    def download_asset_picture_with_http_info(self, asset_id, id, **kwargs):  # noqa: E501
        """Download an asset picture  # noqa: E501

        Download an asset picture.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_asset_picture_with_http_info(asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_asset_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `download_asset_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_asset_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/pictures/{id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_add_ons_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all add_ons of one asset  # noqa: E501

        Returns a list of all add_ons that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_add_ons_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str product_code: Filter accepts `*` as wildcard
        :param str material_number: Filter accepts `*` as wildcard
        :param str add_on_type: Filter accepts addon or connectivity
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: AddOnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_add_ons_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_add_ons_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_add_ons_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all add_ons of one asset  # noqa: E501

        Returns a list of all add_ons that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_add_ons_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str product_code: Filter accepts `*` as wildcard
        :param str material_number: Filter accepts `*` as wildcard
        :param str add_on_type: Filter accepts addon or connectivity
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: AddOnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'name', 'product_code', 'material_number', 'add_on_type', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_add_ons_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_add_ons_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'product_code' in params:
            query_params.append(('product_code', params['product_code']))  # noqa: E501
        if 'material_number' in params:
            query_params.append(('material_number', params['material_number']))  # noqa: E501
        if 'add_on_type' in params:
            query_params.append(('add_on_type', params['add_on_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/add_ons', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddOnsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_subscriptions_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all API subscriptions of the asset  # noqa: E501

        Returns a list of all API subscriptions that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```user, user.usage, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_subscriptions_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param int user_id: One or multiple ids (comma list). Expected id format is integer
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str external_reference: Filter accepts `*` as wildcard
        :param str status: Filter by status - no wildcard support
        :param str notification_status: Filter by notification status - no wildcard support
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date start_date: Expected date format is YYYY-MM-DD
        :param date end_date: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: APISubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_subscriptions_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_subscriptions_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_api_subscriptions_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all API subscriptions of the asset  # noqa: E501

        Returns a list of all API subscriptions that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```user, user.usage, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_subscriptions_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param int user_id: One or multiple ids (comma list). Expected id format is integer
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str external_reference: Filter accepts `*` as wildcard
        :param str status: Filter by status - no wildcard support
        :param str notification_status: Filter by notification status - no wildcard support
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date start_date: Expected date format is YYYY-MM-DD
        :param date end_date: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: APISubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'user_id', 'client_application_id', 'external_reference', 'status', 'notification_status', 'specifications_key', 'specifications_value', 'start_date', 'end_date', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_subscriptions_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_api_subscriptions_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'client_application_id' in params:
            query_params.append(('client_application_id', params['client_application_id']))  # noqa: E501
        if 'external_reference' in params:
            query_params.append(('external_reference', params['external_reference']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'notification_status' in params:
            query_params.append(('notification_status', params['notification_status']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/api_subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APISubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single asset  # noqa: E501

        Get a specific asset identified by the id in the URL. Possible include values: ```status, tenant, parent, pictures, values, values.unit, values_in_preferred_units, values_in_preferred_units.unit, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, product.tenant, product.manufacturer.tenant, status.tenant, instrumentations, systems, systems.recipe,  systems.specifications, systems.batches_in_execution, specifications, specifications[key1,key2], product.specifications, product.specifications[key1,key2], instrumentations.specifications, instrumentations.specifications[key1,key2] add_ons```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the asset to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_asset_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single asset  # noqa: E501

        Get a specific asset identified by the id in the URL. Possible include values: ```status, tenant, parent, pictures, values, values.unit, values_in_preferred_units, values_in_preferred_units.unit, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, product.tenant, product.manufacturer.tenant, status.tenant, instrumentations, systems, systems.recipe,  systems.specifications, systems.batches_in_execution, specifications, specifications[key1,key2], product.specifications, product.specifications[key1,key2], instrumentations.specifications, instrumentations.specifications[key1,key2] add_ons```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the asset to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: AssetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_asset_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_company_options(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible companies of the specified assets  # noqa: E501

        Returns a list of all possible companies for the specified asset. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```tenant, parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_company_options(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: Companies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_company_options_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_company_options_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_company_options_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible companies of the specified assets  # noqa: E501

        Returns a list of all possible companies for the specified asset. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```tenant, parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_company_options_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: Companies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_company_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_company_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/company-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Companies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_history(self, asset_id, **kwargs):  # noqa: E501
        """Get the history of an asset  # noqa: E501

        Returns a collection of historical values of the asset identified by the id in the URL. Specifications are not included.   With the filter parameters from and to, it is possible to receive the history of a defined time period   Define the from with a ```+``` in front of the date the previous values is part of the collection (+2018-06-21T14:45:23).   Define the to with a ```+``` at the end of the date the next values is part of the collection (2018-06-21T14:45:23+).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_history(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str attribute: limit history to changes of a specific attribute e.g status or serial_number
        :param date _from: Start date filter for history values. Starting with ```+``` will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Ending with ```+``` will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `datetime`, add `-` as a prefix for descending order.
        :return: AssetHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_history_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_history_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_history_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get the history of an asset  # noqa: E501

        Returns a collection of historical values of the asset identified by the id in the URL. Specifications are not included.   With the filter parameters from and to, it is possible to receive the history of a defined time period   Define the from with a ```+``` in front of the date the previous values is part of the collection (+2018-06-21T14:45:23).   Define the to with a ```+``` at the end of the date the next values is part of the collection (2018-06-21T14:45:23+).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_history_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str attribute: limit history to changes of a specific attribute e.g status or serial_number
        :param date _from: Start date filter for history values. Starting with ```+``` will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Ending with ```+``` will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `datetime`, add `-` as a prefix for descending order.
        :return: AssetHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'attribute', '_from', 'to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'attribute' in params:
            query_params.append(('attribute', params['attribute']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_id_status(self, asset_id, **kwargs):  # noqa: E501
        """Get the status of the specific asset  # noqa: E501

        Returns the status of the asset. Needed if only permission on asset but not on tenant. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_id_status(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: AssetStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_id_status_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_id_status_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_id_status_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get the status of the specific asset  # noqa: E501

        Returns the status of the asset. Needed if only permission on asset but not on tenant. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_id_status_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: AssetStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'include', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_id_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_id_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_picture(self, asset_id, id, **kwargs):  # noqa: E501
        """Get an asset picture  # noqa: E501

        Get a single picture of an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_picture(asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_picture_with_http_info(asset_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_picture_with_http_info(asset_id, id, **kwargs)  # noqa: E501
            return data

    def get_asset_picture_with_http_info(self, asset_id, id, **kwargs):  # noqa: E501
        """Get an asset picture  # noqa: E501

        Get a single picture of an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_picture_with_http_info(asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_asset_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/pictures/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_pictures(self, id, **kwargs):  # noqa: E501
        """Get asset pictures  # noqa: E501

        Get all pictures of an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_pictures(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the asset (required)
        :param int width: filter by width
        :param int width_from: filter by width_from
        :param int width_to: filter by width_to
        :param int height: filter by height
        :param int height_from: filter by height_from
        :param int height_to: filter by height_to
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_pictures_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_pictures_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_asset_pictures_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get asset pictures  # noqa: E501

        Get all pictures of an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_pictures_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the asset (required)
        :param int width: filter by width
        :param int width_from: filter by width_from
        :param int width_to: filter by width_to
        :param int height: filter by height
        :param int height_from: filter by height_from
        :param int height_to: filter by height_to
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'width', 'width_from', 'width_to', 'height', 'height_from', 'height_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_pictures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_asset_pictures`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))  # noqa: E501
        if 'width_from' in params:
            query_params.append(('width_from', params['width_from']))  # noqa: E501
        if 'width_to' in params:
            query_params.append(('width_to', params['width_to']))  # noqa: E501
        if 'height' in params:
            query_params.append(('height', params['height']))  # noqa: E501
        if 'height_from' in params:
            query_params.append(('height_from', params['height_from']))  # noqa: E501
        if 'height_to' in params:
            query_params.append(('height_to', params['height_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}/pictures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PicturesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_product_options(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible products of the specified assets  # noqa: E501

        Returns a list of all possible products for the specified asset. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, parent, manufacturer, pictures, categories, categories.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_product_options(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str product_code: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: Products
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_product_options_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_product_options_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_product_options_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible products of the specified assets  # noqa: E501

        Returns a list of all possible products for the specified asset. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, parent, manufacturer, pictures, categories, categories.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_product_options_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str product_code: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: Products
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'product_code', 'name', 'manufacturer_id', 'status_id', 'category_id', 'parent_id', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_product_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_product_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'product_code' in params:
            query_params.append(('product_code', params['product_code']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/product-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Products',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_statuses_options(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible statuses of the specified assets  # noqa: E501

        Returns a list of all possible asset statuses for the specified asset. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_statuses_options(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str code: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: AssetStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_statuses_options_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_statuses_options_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_statuses_options_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible statuses of the specified assets  # noqa: E501

        Returns a list of all possible asset statuses for the specified asset. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_statuses_options_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str code: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: AssetStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'tenant_id', 'code', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_statuses_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_statuses_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/status-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetStatuses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_tenant_options(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible tenants of the specified assets  # noqa: E501

        Returns a list of all possible tenants for the specified asset. That is all public tenants and the assets tenant. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_tenant_options(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: Tenants
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_tenant_options_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_tenant_options_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_tenant_options_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all possible tenants of the specified assets  # noqa: E501

        Returns a list of all possible tenants for the specified asset. That is all public tenants and the assets tenant. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_tenant_options_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: Tenants
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'name', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_tenant_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_tenant_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/tenant-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tenants',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_value_objects_for_key(self, asset_id, key, **kwargs):  # noqa: E501
        """Get asset value objects for a specific key.  # noqa: E501

        Returns a collection of the history value objects of the value objects for the specified key. For a selected result of the value objects the filter parameters selector and interval are mandatory. With the filter parameters from, to or datetime, it is possible to receive the history of a defined time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_value_objects_for_key(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str key: key for the asset values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date _datetime: exact date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str selector: Supported selector methods are `first, last`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the selector. The value is mandatory if selector is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValueObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_value_objects_for_key_with_http_info(asset_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_value_objects_for_key_with_http_info(asset_id, key, **kwargs)  # noqa: E501
            return data

    def get_asset_value_objects_for_key_with_http_info(self, asset_id, key, **kwargs):  # noqa: E501
        """Get asset value objects for a specific key.  # noqa: E501

        Returns a collection of the history value objects of the value objects for the specified key. For a selected result of the value objects the filter parameters selector and interval are mandatory. With the filter parameters from, to or datetime, it is possible to receive the history of a defined time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_value_objects_for_key_with_http_info(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str key: key for the asset values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date _datetime: exact date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str selector: Supported selector methods are `first, last`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the selector. The value is mandatory if selector is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValueObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'key', 'page', 'per_page', 'include', '_from', 'to', '_datetime', 'selector', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_value_objects_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_value_objects_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_asset_value_objects_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if '_datetime' in params:
            query_params.append(('datetime', params['_datetime']))  # noqa: E501
        if 'selector' in params:
            query_params.append(('selector', params['selector']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/value_objects/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValueObjectsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_values(self, asset_id, **kwargs):  # noqa: E501
        """Get latest values for the asset.  # noqa: E501

        Returns a collection of the latest value for every key of the asset. Possible include values: ```unit, unit.base_unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_values_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_values_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_values_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get latest values for the asset.  # noqa: E501

        Returns a collection of the latest value for every key of the asset. Possible include values: ```unit, unit.base_unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'use_preferred_units', 'key', 'key_unit_id', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'key_unit_id' in params:
            query_params.append(('key_unit_id', params['key_unit_id']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_values_for_key(self, asset_id, key, **kwargs):  # noqa: E501
        """Get asset values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values_for_key(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str key: key for the asset values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_values_for_key_with_http_info(asset_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_values_for_key_with_http_info(asset_id, key, **kwargs)  # noqa: E501
            return data

    def get_asset_values_for_key_with_http_info(self, asset_id, key, **kwargs):  # noqa: E501
        """Get asset values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values_for_key_with_http_info(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str key: key for the asset values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'key', 'page', 'per_page', 'include', 'use_preferred_units', '_from', 'to', 'unit_id', 'aggregation', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_values_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_values_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_asset_values_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'unit_id' in params:
            query_params.append(('unit_id', params['unit_id']))  # noqa: E501
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/values/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets(self, **kwargs):  # noqa: E501
        """Get a range of assets  # noqa: E501

        Returns a list of assets in your accessible scope. You can apply the query parameters listed below to get a filtered list. Possible include values: ```status, tenant, parent, pictures, values, values.unit, values_in_preferred_units, values_in_preferred_units.unit, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, product.tenant, product.manufacturer.tenant, status.tenant, instrumentations, systems, systems.recipe,  systems.specifications, systems.batches_in_execution, specifications, specifications[key1,key2], product.specifications, product.specifications[key1,key2], instrumentations.status, instrumentations.type, instrumentations.worst_asset_status,  instrumentations.specifications, instrumentations.specifications[key1,key2] add_ons```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_status_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str last_seen_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str last_seen_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all assets with no nodes assigned or \"!null\" for any assigned node.  By adding `+` after the id, the filter considers the given node and all its sub components (nodes, instrumentations and systems), but this is not usable in combination with a comma list.
        :param str instrumentation_id: One or multiple ids (comma list). Filter accepts \"null\" for all objects with no instrumentations assigned or \"!null\" for any assigned instrumentation
        :param str system_id: One or multiple ids (comma list). Filter accepts \"null\" for all objects with no systems assigned or \"!null\" for any assigned system
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_assets_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of assets  # noqa: E501

        Returns a list of assets in your accessible scope. You can apply the query parameters listed below to get a filtered list. Possible include values: ```status, tenant, parent, pictures, values, values.unit, values_in_preferred_units, values_in_preferred_units.unit, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, product.tenant, product.manufacturer.tenant, status.tenant, instrumentations, systems, systems.recipe,  systems.specifications, systems.batches_in_execution, specifications, specifications[key1,key2], product.specifications, product.specifications[key1,key2], instrumentations.status, instrumentations.type, instrumentations.worst_asset_status,  instrumentations.specifications, instrumentations.specifications[key1,key2] add_ons```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_status_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str last_seen_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str last_seen_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all assets with no nodes assigned or \"!null\" for any assigned node.  By adding `+` after the id, the filter considers the given node and all its sub components (nodes, instrumentations and systems), but this is not usable in combination with a comma list.
        :param str instrumentation_id: One or multiple ids (comma list). Filter accepts \"null\" for all objects with no instrumentations assigned or \"!null\" for any assigned instrumentation
        :param str system_id: One or multiple ids (comma list). Filter accepts \"null\" for all objects with no systems assigned or \"!null\" for any assigned system
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'serial_number', 'product_id', 'product_status_id', 'product_category_id', 'parent_id', 'manufacturer_id', 'status_id', 'status_code', 'tenant_id', 'last_seen_at_from', 'last_seen_at_to', 'production_date', 'production_date_from', 'production_date_to', 'specifications_key', 'specifications_value', 'node_id', 'instrumentation_id', 'system_id', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'ownership_claimed', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'product_id' in params:
            query_params.append(('product_id', params['product_id']))  # noqa: E501
        if 'product_status_id' in params:
            query_params.append(('product_status_id', params['product_status_id']))  # noqa: E501
        if 'product_category_id' in params:
            query_params.append(('product_category_id', params['product_category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'status_code' in params:
            query_params.append(('status_code', params['status_code']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'last_seen_at_from' in params:
            query_params.append(('last_seen_at_from', params['last_seen_at_from']))  # noqa: E501
        if 'last_seen_at_to' in params:
            query_params.append(('last_seen_at_to', params['last_seen_at_to']))  # noqa: E501
        if 'production_date' in params:
            query_params.append(('production_date', params['production_date']))  # noqa: E501
        if 'production_date_from' in params:
            query_params.append(('production_date_from', params['production_date_from']))  # noqa: E501
        if 'production_date_to' in params:
            query_params.append(('production_date_to', params['production_date_to']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501
        if 'instrumentation_id' in params:
            query_params.append(('instrumentation_id', params['instrumentation_id']))  # noqa: E501
        if 'system_id' in params:
            query_params.append(('system_id', params['system_id']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'ownership_claimed' in params:
            query_params.append(('ownership_claimed', params['ownership_claimed']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_deliveries_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all deliveries of one asset  # noqa: E501

        Returns a list of all deliveries that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deliveries_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param date date_of_shipment: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_from: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: DeliveriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_deliveries_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_deliveries_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_deliveries_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all deliveries of one asset  # noqa: E501

        Returns a list of all deliveries that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deliveries_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param date date_of_shipment: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_from: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: DeliveriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'number', 'name', 'status_id', 'date_of_shipment', 'date_of_shipment_from', 'date_of_shipment_to', 'sender_id', 'receiver_id', 'customer_number', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deliveries_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_deliveries_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'date_of_shipment' in params:
            query_params.append(('date_of_shipment', params['date_of_shipment']))  # noqa: E501
        if 'date_of_shipment_from' in params:
            query_params.append(('date_of_shipment_from', params['date_of_shipment_from']))  # noqa: E501
        if 'date_of_shipment_to' in params:
            query_params.append(('date_of_shipment_to', params['date_of_shipment_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'customer_number' in params:
            query_params.append(('customer_number', params['customer_number']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/deliveries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeliveriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all documents of an asset  # noqa: E501

        Returns a list of all documents that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, attachments, categories.standards, eventdocuments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all documents of an asset  # noqa: E501

        Returns a list of all documents that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, attachments, categories.standards, eventdocuments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_documents_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all events of one asset  # noqa: E501

        Returns a list of all events belonging to an asset in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_events_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_events_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all events of one asset  # noqa: E501

        Returns a list of all events belonging to an asset in your accessible scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``assets, instrumentations, status, type``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str start_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str start_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date end_datetime_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str end_datetime_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `start_datetime`, `end_datetime`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: EventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'type_id', 'status_id', 'start_datetime', 'start_datetime_from', 'start_datetime_to', 'end_datetime', 'end_datetime_from', 'end_datetime_to', 'tenant_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_events_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'start_datetime' in params:
            query_params.append(('start_datetime', params['start_datetime']))  # noqa: E501
        if 'start_datetime_from' in params:
            query_params.append(('start_datetime_from', params['start_datetime_from']))  # noqa: E501
        if 'start_datetime_to' in params:
            query_params.append(('start_datetime_to', params['start_datetime_to']))  # noqa: E501
        if 'end_datetime' in params:
            query_params.append(('end_datetime', params['end_datetime']))  # noqa: E501
        if 'end_datetime_from' in params:
            query_params.append(('end_datetime_from', params['end_datetime_from']))  # noqa: E501
        if 'end_datetime_to' in params:
            query_params.append(('end_datetime_to', params['end_datetime_to']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentations_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all instrumentations of one asset  # noqa: E501

        Returns a list of all instrumentations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentations_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentations_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentations_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all instrumentations of one asset  # noqa: E501

        Returns a list of all instrumentations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, worst_asset_status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all objects with no nodes assigned or \"!null\" for any assigned node
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'tag', 'status_id', 'type_id', 'parent_id', 'tenant_id', 'specifications_key', 'specifications_value', 'criticality', 'accessibility', 'node_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentations_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_instrumentations_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'criticality' in params:
            query_params.append(('criticality', params['criticality']))  # noqa: E501
        if 'accessibility' in params:
            query_params.append(('accessibility', params['accessibility']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/instrumentations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentations_of_asset_history(self, asset_id, **kwargs):  # noqa: E501
        """Get all instrumentations an asset was assigned to  # noqa: E501

        Returns a list of all instrumentations history available in your scope which have been assigned to the specified asset. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_asset_history(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str instrumentation_id: One or multiple ids (comma list). Expected id format is integer
        :param str event: Filter accepts `create` or `destroy`
        :param date event_datetime_from: Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date event_datetime_to: Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `event` or `event_datetime`, add `-` as a prefix for descending order.
        :return: AssetInstrumentationsHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentations_of_asset_history_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentations_of_asset_history_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentations_of_asset_history_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all instrumentations an asset was assigned to  # noqa: E501

        Returns a list of all instrumentations history available in your scope which have been assigned to the specified asset. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_asset_history_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str instrumentation_id: One or multiple ids (comma list). Expected id format is integer
        :param str event: Filter accepts `create` or `destroy`
        :param date event_datetime_from: Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date event_datetime_to: Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `event` or `event_datetime`, add `-` as a prefix for descending order.
        :return: AssetInstrumentationsHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'instrumentation_id', 'event', 'event_datetime_from', 'event_datetime_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentations_of_asset_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_instrumentations_of_asset_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'instrumentation_id' in params:
            query_params.append(('instrumentation_id', params['instrumentation_id']))  # noqa: E501
        if 'event' in params:
            query_params.append(('event', params['event']))  # noqa: E501
        if 'event_datetime_from' in params:
            query_params.append(('event_datetime_from', params['event_datetime_from']))  # noqa: E501
        if 'event_datetime_to' in params:
            query_params.append(('event_datetime_to', params['event_datetime_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/instrumentations/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetInstrumentationsHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nodes_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all nodes of one asset  # noqa: E501

        Returns a list of all nodes that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param bool hidden: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: NodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nodes_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nodes_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_nodes_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all nodes of one asset  # noqa: E501

        Returns a list of all nodes that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nodes_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param bool hidden: Filter accepts true or false
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: NodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'type_id', 'parent_id', 'tenant_id', 'hidden', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nodes_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_nodes_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'hidden' in params:
            query_params.append(('hidden', params['hidden']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_softwares_of_software(self, asset_id, **kwargs):  # noqa: E501
        """Get a range of software of one asset  # noqa: E501

        Returns a list of software. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```software_attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_softwares_of_software(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str software_type_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `version_number`, `name`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: SoftwaresResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_softwares_of_software_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_softwares_of_software_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_softwares_of_software_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get a range of software of one asset  # noqa: E501

        Returns a list of software. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```software_attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_softwares_of_software_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str software_type_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `version_number`, `name`, `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: SoftwaresResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'software_type_id', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_softwares_of_software" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_softwares_of_software`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'software_type_id' in params:
            query_params.append(('software_type_id', params['software_type_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/softwares', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SoftwaresResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specification_history_of_asset(self, asset_id, key, **kwargs):  # noqa: E501
        """Get the history of one specification attribute of an asset.  # noqa: E501

        This might be useful for history data. The response contains a collection of historic values and when they`ve been updated. Since this can be a lot of data the service uses pagination. The history can be filtered by using a date range of source_timestamp and/or updated_at. Please consider that source_timestamp is not required and update on the attribute without giving a source_timestamp wont be included in the resulting response  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_history_of_asset(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param str key: the exact key (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param datetime source_timestamp_from: source_timestamp filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime source_timestamp_to: source_timestamp filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_from: updated_at filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_to: updated_at filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `source_timestamp` or `updated_at`, add `-` as a prefix for descending order.
        :return: SpecificationHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specification_history_of_asset_with_http_info(asset_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specification_history_of_asset_with_http_info(asset_id, key, **kwargs)  # noqa: E501
            return data

    def get_specification_history_of_asset_with_http_info(self, asset_id, key, **kwargs):  # noqa: E501
        """Get the history of one specification attribute of an asset.  # noqa: E501

        This might be useful for history data. The response contains a collection of historic values and when they`ve been updated. Since this can be a lot of data the service uses pagination. The history can be filtered by using a date range of source_timestamp and/or updated_at. Please consider that source_timestamp is not required and update on the attribute without giving a source_timestamp wont be included in the resulting response  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_history_of_asset_with_http_info(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param str key: the exact key (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param datetime source_timestamp_from: source_timestamp filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime source_timestamp_to: source_timestamp filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_from: updated_at filter from. Starting with + will include the previous value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param datetime updated_at_to: updated_at filter to. Ending with + will include the next value as well. Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `source_timestamp` or `updated_at`, add `-` as a prefix for descending order.
        :return: SpecificationHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'key', 'page', 'per_page', 'source_timestamp_from', 'source_timestamp_to', 'updated_at_from', 'updated_at_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specification_history_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_specification_history_of_asset`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_specification_history_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'source_timestamp_from' in params:
            query_params.append(('source_timestamp_from', params['source_timestamp_from']))  # noqa: E501
        if 'source_timestamp_to' in params:
            query_params.append(('source_timestamp_to', params['source_timestamp_to']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/specifications/{key}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specification_keys_of_assets(self, **kwargs):  # noqa: E501
        """Get existing asset specification keys  # noqa: E501

        Returns the existing specification keys in all readable assets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_keys_of_assets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specification_keys_of_assets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_specification_keys_of_assets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_specification_keys_of_assets_with_http_info(self, **kwargs):  # noqa: E501
        """Get existing asset specification keys  # noqa: E501

        Returns the existing specification keys in all readable assets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specification_keys_of_assets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'ui_visible']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specification_keys_of_assets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'ui_visible' in params:
            query_params.append(('ui_visible', params['ui_visible']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/asset/specification_keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationKeys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specifications_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get specifications of an asset  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationsUIVisibleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specifications_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specifications_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_specifications_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get specifications of an asset  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: Id of the specified asset (required)
        :param str key: Filter accepts '*' as wildcard
        :param bool ui_visible:
        :return: SpecificationsUIVisibleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'key', 'ui_visible']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specifications_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_specifications_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'ui_visible' in params:
            query_params.append(('ui_visible', params['ui_visible']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/specifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationsUIVisibleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscriptions_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all subscriptions of asset  # noqa: E501

        Returns a list of all subscriptions that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```user, user.usage, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscriptions_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param int user_id: One or multiple ids (comma list). Expected id format is integer
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str external_reference: Filter accepts `*` as wildcard
        :param str status: Filter by status - no wildcard support
        :param str notification_status: Filter by notification status - no wildcard support
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date start_date: Expected date format is YYYY-MM-DD
        :param date end_date: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscriptions_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscriptions_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_subscriptions_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all subscriptions of asset  # noqa: E501

        Returns a list of all subscriptions that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```user, user.usage, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscriptions_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param int user_id: One or multiple ids (comma list). Expected id format is integer
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str external_reference: Filter accepts `*` as wildcard
        :param str status: Filter by status - no wildcard support
        :param str notification_status: Filter by notification status - no wildcard support
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param date start_date: Expected date format is YYYY-MM-DD
        :param date end_date: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'user_id', 'client_application_id', 'external_reference', 'status', 'notification_status', 'specifications_key', 'specifications_value', 'start_date', 'end_date', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscriptions_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_subscriptions_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'client_application_id' in params:
            query_params.append(('client_application_id', params['client_application_id']))  # noqa: E501
        if 'external_reference' in params:
            query_params.append(('external_reference', params['external_reference']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'notification_status' in params:
            query_params.append(('notification_status', params['notification_status']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_systems_of_asset(self, asset_id, **kwargs):  # noqa: E501
        """Get all systems of one Asset  # noqa: E501

        Returns a list of all systems that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```pictures, specifications, specifications[key1,key2], tenant, parent, status, type, type.tenant, type.parent ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_systems_of_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SystemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_systems_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_systems_of_asset_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_systems_of_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get all systems of one Asset  # noqa: E501

        Returns a list of all systems that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```pictures, specifications, specifications[key1,key2], tenant, parent, status, type, type.tenant, type.parent ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_systems_of_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `name`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: SystemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'name', 'type_id', 'parent_id', 'tenant_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_systems_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_systems_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/systems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_add_ons_from_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove add_ons from an asset  # noqa: E501

        Remove one or more add_ons from an asset in your accessible scope. `This action` requires `can_permit` permission on the asset and on the add_on.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_add_ons_from_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddOnIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the add_ons will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_add_ons_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_add_ons_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_add_ons_from_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove add_ons from an asset  # noqa: E501

        Remove one or more add_ons from an asset in your accessible scope. `This action` requires `can_permit` permission on the asset and on the add_on.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_add_ons_from_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddOnIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the add_ons will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_add_ons_from_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_add_ons_from_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_add_ons_from_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/add_ons', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_deliveries_from_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove deliveries from an asset  # noqa: E501

        Remove one or more deliveries from an asset in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_deliveries_from_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the deliveries will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_deliveries_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_deliveries_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_deliveries_from_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove deliveries from an asset  # noqa: E501

        Remove one or more deliveries from an asset in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_deliveries_from_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the deliveries will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_deliveries_from_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_deliveries_from_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_deliveries_from_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/deliveries', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove documents from an asset  # noqa: E501

        Remove one or more documents from an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove documents from an asset  # noqa: E501

        Remove one or more documents from an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_documents_from_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_event_from_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove events from an asset  # noqa: E501

        Remove one or more events from an asset in your accessible scope. If the event has no more related assets, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_event_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_event_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_event_from_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove events from an asset  # noqa: E501

        Remove one or more events from an asset in your accessible scope. If the event has no more related assets, the event will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_event_from_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Events body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the events will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_event_from_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_event_from_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_event_from_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/events', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_instrumentations_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove instrumentations from an asset  # noqa: E501

        Remove one or more instrumentations from an asset in your accessible scope. This action requires `can_permit` permission on the asset and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the instrumentations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_instrumentations_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_instrumentations_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_instrumentations_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove instrumentations from an asset  # noqa: E501

        Remove one or more instrumentations from an asset in your accessible scope. This action requires `can_permit` permission on the asset and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the instrumentations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_instrumentations_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_instrumentations_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_instrumentations_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/instrumentations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_nodes_from_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove nodes from an asset  # noqa: E501

        Remove one or more nodes from an asset in your accessible scope. `This action` requires `can_permit` permission on the asset and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_nodes_from_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the nodes will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_nodes_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_nodes_from_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_nodes_from_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove nodes from an asset  # noqa: E501

        Remove one or more nodes from an asset in your accessible scope. `This action` requires `can_permit` permission on the asset and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_nodes_from_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the asset from which the nodes will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_nodes_from_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_nodes_from_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_nodes_from_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/nodes', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_softwares_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove software from an asset  # noqa: E501

        Remove one or more software from an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_softwares_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the product from which the software will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_softwares_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_softwares_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def remove_softwares_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Remove software from an asset  # noqa: E501

        Remove one or more software from an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_softwares_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareIDs body: Resources that shall be removed. (required)
        :param int asset_id: Id of the product from which the software will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_softwares_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_softwares_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `remove_softwares_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/softwares', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_specifications_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of an asset in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ]. All uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int asset_id: Id of the specified asset (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_specifications_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_specifications_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def rename_specifications_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of an asset in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ]. All uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int asset_id: Id of the specified asset (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_specifications_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_specifications_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `rename_specifications_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/specifications/rename', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_add_ons_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the add_ons of an asset  # noqa: E501

        Replaces all add_ons belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the asset and on the add_on.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_add_ons_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddOnIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the add_ons will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_add_ons_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_add_ons_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def replace_add_ons_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the add_ons of an asset  # noqa: E501

        Replaces all add_ons belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the asset and on the add_on.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_add_ons_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddOnIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the add_ons will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_add_ons_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_add_ons_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_add_ons_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/add_ons', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_deliveries_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the deliveries of an asset  # noqa: E501

        Replaces all deliveries belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_deliveries_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the deliveries will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_deliveries_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_deliveries_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def replace_deliveries_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the deliveries of an asset  # noqa: E501

        Replaces all deliveries belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_deliveries_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the deliveries will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_deliveries_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_deliveries_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_deliveries_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/deliveries', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the documents of an asset  # noqa: E501

        Replaces all documents belonging to an asset. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the documents of an asset  # noqa: E501

        Replaces all documents belonging to an asset. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_documents_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_instrumentations_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the instrumentations of an asset  # noqa: E501

        Replaces all instrumentations belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the asset and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_instrumentations_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the instrumentations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_instrumentations_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_instrumentations_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def replace_instrumentations_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the instrumentations of an asset  # noqa: E501

        Replaces all instrumentations belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the asset and on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_instrumentations_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the instrumentations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_instrumentations_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_instrumentations_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_instrumentations_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/instrumentations', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_nodes_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the nodes of an asset  # noqa: E501

        Replaces all nodes belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the asset and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_nodes_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the nodes will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_nodes_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_nodes_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def replace_nodes_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the nodes of an asset  # noqa: E501

        Replaces all nodes belonging to an asset in your accessible scope. You can send a list of resources that will replace all previous values. This action requires `can_permit` permission on the asset and on the node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_nodes_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the nodes will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_nodes_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_nodes_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_nodes_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/nodes', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_softwares_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the software of an asset  # noqa: E501

        Replaces all software belonging to an asset. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_softwares_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the software will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_softwares_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_softwares_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def replace_softwares_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Replace the software of an asset  # noqa: E501

        Replaces all software belonging to an asset. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_softwares_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SoftwareIDs body: Resources that shall be replaced (required)
        :param int asset_id: Id of the asset of which the software will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_softwares_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_softwares_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `replace_softwares_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/softwares', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_asset(self, body, id, **kwargs):  # noqa: E501
        """Update an asset  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  To assign a parent asset the user needs `can_permit` permission on the parent and on the current asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetRequest body: Parameters that shall be updated. To remove an associative object use "object_name": null (required)
        :param int id: Id of the asset to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_asset_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_asset_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_asset_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an asset  # noqa: E501

        Update accessible parameters of the requested resource in your accessible scope.  To assign a parent asset the user needs `can_permit` permission on the parent and on the current asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetRequest body: Parameters that shall be updated. To remove an associative object use "object_name": null (required)
        :param int id: Id of the asset to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_asset`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_asset_picture(self, image, asset_id, id, **kwargs):  # noqa: E501
        """Update an asset picture  # noqa: E501

        Upload a new asset picture. Check the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_picture(image, asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_asset_picture_with_http_info(image, asset_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_asset_picture_with_http_info(image, asset_id, id, **kwargs)  # noqa: E501
            return data

    def update_asset_picture_with_http_info(self, image, asset_id, id, **kwargs):  # noqa: E501
        """Update an asset picture  # noqa: E501

        Upload a new asset picture. Check the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_picture_with_http_info(image, asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image', 'asset_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image' is set
        if ('image' not in params or
                params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `update_asset_picture`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `update_asset_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_asset_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/pictures/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_asset_picture_link(self, body, asset_id, id, **kwargs):  # noqa: E501
        """Update an asset picture link  # noqa: E501

        Update an asset picture link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_picture_link(body, asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be updated (required)
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_asset_picture_link_with_http_info(body, asset_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_asset_picture_link_with_http_info(body, asset_id, id, **kwargs)  # noqa: E501
            return data

    def update_asset_picture_link_with_http_info(self, body, asset_id, id, **kwargs):  # noqa: E501
        """Update an asset picture link  # noqa: E501

        Update an asset picture link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_picture_link_with_http_info(body, asset_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PictureLinkRequest body: Picture link object to be updated (required)
        :param int asset_id: Id of the asset (required)
        :param int id: Id of the asset picture (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_picture_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_asset_picture_link`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `update_asset_picture_link`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_asset_picture_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/pictures/links/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_specifications_of_asset(self, body, asset_id, **kwargs):  # noqa: E501
        """Update specifications of an asset  # noqa: E501

        Update the specification object of an asset in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  It is possible to save complex objects in the value as vector. In this case the unit must be 'vector' and the value a valid object in the following format: ```       [           {             \"key\": {              \"value\": \"string\",              \"unit\": \"string\"            }           },           {             \"second_key\": {               \"value\": \"string\"             }           }        ]   ```  - key can only consist of [a-z A-Z 0-9 . - _ ]. - value is mandatory, max length 6000 chars - unit is optional, max length 50 chars - its impossible to filter for vector values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_asset(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationUIVisibleRequest) body: The specifications objects to patch. (required)
        :param int asset_id: Id of the specified asset (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_specifications_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_specifications_of_asset_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def update_specifications_of_asset_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Update specifications of an asset  # noqa: E501

        Update the specification object of an asset in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  It is possible to save complex objects in the value as vector. In this case the unit must be 'vector' and the value a valid object in the following format: ```       [           {             \"key\": {              \"value\": \"string\",              \"unit\": \"string\"            }           },           {             \"second_key\": {               \"value\": \"string\"             }           }        ]   ```  - key can only consist of [a-z A-Z 0-9 . - _ ]. - value is mandatory, max length 6000 chars - unit is optional, max length 50 chars - its impossible to filter for vector values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_asset_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationUIVisibleRequest) body: The specifications objects to patch. (required)
        :param int asset_id: Id of the specified asset (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_specifications_of_asset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_specifications_of_asset`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `update_specifications_of_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/specifications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_asset_picture(self, image, id, **kwargs):  # noqa: E501
        """Upload an asset picture  # noqa: E501

        Upload a new asset picture. Checks the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_asset_picture(image, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int id: Id of the asset (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_asset_picture_with_http_info(image, id, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_asset_picture_with_http_info(image, id, **kwargs)  # noqa: E501
            return data

    def upload_asset_picture_with_http_info(self, image, id, **kwargs):  # noqa: E501
        """Upload an asset picture  # noqa: E501

        Upload a new asset picture. Checks the file-storage quota. Allowed content-types are - image/gif - image/jpg - image/jpeg - image/png  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_asset_picture_with_http_info(image, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image: (required)
        :param int id: Id of the asset (required)
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_asset_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image' is set
        if ('image' not in params or
                params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `upload_asset_picture`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `upload_asset_picture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{id}/pictures', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
