# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class APISubscriptionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_assets_to_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Add assets to an api subscription  # noqa: E501

        Add one or more assets to an API subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int id: Id of the api subscription to fetch (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_assets_to_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_assets_to_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def add_assets_to_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Add assets to an api subscription  # noqa: E501

        Add one or more assets to an API subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_assets_to_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be added. (required)
        :param int id: Id of the api subscription to fetch (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_assets_to_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_assets_to_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_assets_to_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_edge_devices_to_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Add edge devices to an api subscription  # noqa: E501

        Add one or more edge devices to an api subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_edge_devices_to_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDevicesIds body: Resources that shall be added. (required)
        :param int id: Id of the api subscription to which the edge devices will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_edge_devices_to_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_edge_devices_to_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def add_edge_devices_to_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Add edge devices to an api subscription  # noqa: E501

        Add one or more edge devices to an api subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_edge_devices_to_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDevicesIds body: Resources that shall be added. (required)
        :param int id: Id of the api subscription to which the edge devices will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_edge_devices_to_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_edge_devices_to_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_edge_devices_to_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/edge_devices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_api_subscription(self, body, **kwargs):  # noqa: E501
        """Create a new api subscription  # noqa: E501

        Creates a new api subscription. Only available for technical_users of the ID application and admins. Setting a successor or predecessor is not possible.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_api_subscription(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APISubscriptionRequest body: api subscription body (required)
        :return: APISubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_api_subscription_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_api_subscription_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_api_subscription_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new api subscription  # noqa: E501

        Creates a new api subscription. Only available for technical_users of the ID application and admins. Setting a successor or predecessor is not possible.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_api_subscription_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APISubscriptionRequest body: api subscription body (required)
        :return: APISubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APISubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_api_subscription(self, id, **kwargs):  # noqa: E501
        """Delete an api subscription  # noqa: E501

        Delete a specific api subscription identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_subscription(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the api subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_api_subscription_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an api subscription  # noqa: E501

        Delete a specific api subscription identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_subscription_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the api subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_subscription_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single api subscription  # noqa: E501

        Get a specific api subscription identified by the id in the URL.  Possible include values: ```user, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_subscription_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the api subscription to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: APISubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_subscription_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_subscription_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_api_subscription_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single api subscription  # noqa: E501

        Get a specific api subscription identified by the id in the URL.  Possible include values: ```user, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_subscription_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the api subscription to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: APISubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_subscription_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_api_subscription_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APISubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_subscriptions(self, **kwargs):  # noqa: E501
        """Get a range of api subscriptions  # noqa: E501

        Returns a list of api subscriptions.  Possible include values: ```user, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_subscriptions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param int user_id: One or multiple ids (comma list). Expected id format is integer
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str external_reference: Filter accepts `*` as wildcard
        :param str status: one or multiple statuses (comma list). Allowed values are `open`, `payment_required`, `confirmed`, `scheduled_update`, `non_renewing` and `cancelled`
        :param str subscription_type: Filter by subscription type - no wildcard support
        :param str notification_status: Filter by notification status - no wildcard support
        :param date start_date: Expected date format is YYYY-MM-DD
        :param date end_date: Expected date format is YYYY-MM-DD
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: APISubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_subscriptions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_api_subscriptions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_api_subscriptions_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of api subscriptions  # noqa: E501

        Returns a list of api subscriptions.  Possible include values: ```user, specifications, specifications[key1,key2]```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_subscriptions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param int user_id: One or multiple ids (comma list). Expected id format is integer
        :param int client_application_id: One or multiple ids (comma list). Expected id format is integer
        :param str external_reference: Filter accepts `*` as wildcard
        :param str status: one or multiple statuses (comma list). Allowed values are `open`, `payment_required`, `confirmed`, `scheduled_update`, `non_renewing` and `cancelled`
        :param str subscription_type: Filter by subscription type - no wildcard support
        :param str notification_status: Filter by notification status - no wildcard support
        :param date start_date: Expected date format is YYYY-MM-DD
        :param date end_date: Expected date format is YYYY-MM-DD
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: APISubscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'user_id', 'client_application_id', 'external_reference', 'status', 'subscription_type', 'notification_status', 'start_date', 'end_date', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_subscriptions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'client_application_id' in params:
            query_params.append(('client_application_id', params['client_application_id']))  # noqa: E501
        if 'external_reference' in params:
            query_params.append(('external_reference', params['external_reference']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'subscription_type' in params:
            query_params.append(('subscription_type', params['subscription_type']))  # noqa: E501
        if 'notification_status' in params:
            query_params.append(('notification_status', params['notification_status']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APISubscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_assets_of_api_subscription(self, id, **kwargs):  # noqa: E501
        """Get all assets of an api subscription  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.specifications, product.specifications[key1,key2], product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_api_subscription(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the api subscription to fetch (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all assets with no nodes assigned or \"!null\" for any assigned node.  By adding `+` after the id, the filter considers the given node and all its sub components (nodes, instrumentations and systems), but this is not usable in combination with a comma list.
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_assets_of_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_assets_of_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_assets_of_api_subscription_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get all assets of an api subscription  # noqa: E501

        Returns a list of all assets that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status, tenant, parent, pictures, product, product.manufacturer, product.pictures, product.status, product.categories, product.categories.parent, specifications, specifications[key1,key2], product.tenant,                             product.specifications, product.specifications[key1,key2], product.manufacturer.tenant, status.tenant, instrumentations ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_of_api_subscription_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the api subscription to fetch (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str product_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_code: Filter accepts `*` as wildcard
        :param date production_date: Expected date format is YYYY-MM-DD
        :param date production_date_from: Expected date format is YYYY-MM-DD
        :param date production_date_to: Expected date format is YYYY-MM-DD
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str node_id: One or multiple ids (comma list). Filter acccepts \"null\" for all assets with no nodes assigned or \"!null\" for any assigned node.  By adding `+` after the id, the filter considers the given node and all its sub components (nodes, instrumentations and systems), but this is not usable in combination with a comma list.
        :param date created_at: Expected date format is YYYY-MM-DD
        :param str created_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str created_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param date updated_at: Expected date format is YYYY-MM-DD
        :param str updated_at_from: Expected date format is YYYY-MM-DDThh:mm:ss
        :param str updated_at_to: Expected date format is YYYY-MM-DDThh:mm:ss
        :param bool ownership_claimed: Filter accepts true or false
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: AssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'page', 'per_page', 'include', 'serial_number', 'product_id', 'product_category_id', 'parent_id', 'manufacturer_id', 'status_id', 'status_code', 'production_date', 'production_date_from', 'production_date_to', 'specifications_key', 'specifications_value', 'node_id', 'created_at', 'created_at_from', 'created_at_to', 'updated_at', 'updated_at_from', 'updated_at_to', 'ownership_claimed', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_of_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_assets_of_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'product_id' in params:
            query_params.append(('product_id', params['product_id']))  # noqa: E501
        if 'product_category_id' in params:
            query_params.append(('product_category_id', params['product_category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'status_code' in params:
            query_params.append(('status_code', params['status_code']))  # noqa: E501
        if 'production_date' in params:
            query_params.append(('production_date', params['production_date']))  # noqa: E501
        if 'production_date_from' in params:
            query_params.append(('production_date_from', params['production_date_from']))  # noqa: E501
        if 'production_date_to' in params:
            query_params.append(('production_date_to', params['production_date_to']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'created_at_from' in params:
            query_params.append(('created_at_from', params['created_at_from']))  # noqa: E501
        if 'created_at_to' in params:
            query_params.append(('created_at_to', params['created_at_to']))  # noqa: E501
        if 'updated_at' in params:
            query_params.append(('updated_at', params['updated_at']))  # noqa: E501
        if 'updated_at_from' in params:
            query_params.append(('updated_at_from', params['updated_at_from']))  # noqa: E501
        if 'updated_at_to' in params:
            query_params.append(('updated_at_to', params['updated_at_to']))  # noqa: E501
        if 'ownership_claimed' in params:
            query_params.append(('ownership_claimed', params['ownership_claimed']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_devices_of_api_subscription(self, id, **kwargs):  # noqa: E501
        """Get all edge devices of an api subscription  # noqa: E501

        Returns a list of all edge devices that are assigned to an api subscription. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status type tenant technical_user order_user software_version usergroup specifications api_subscription api_subscription.user```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_devices_of_api_subscription(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Get a list of edge devices assigned to the api subscription identified by this id. (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str software_version_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str technical_user_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_user_id: One or multiple ids (comma list). Expected id format is integer
        :param str log_level: Filter accepts trace, debug, info, warning, error, critical, off
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, `name`, add `-` as a prefix for descending order. Default value is `id`
        :return: EdgeDeviceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_devices_of_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_devices_of_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_edge_devices_of_api_subscription_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get all edge devices of an api subscription  # noqa: E501

        Returns a list of all edge devices that are assigned to an api subscription. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```status type tenant technical_user order_user software_version usergroup specifications api_subscription api_subscription.user```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_devices_of_api_subscription_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Get a list of edge devices assigned to the api subscription identified by this id. (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str serial_number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str software_version_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str technical_user_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_user_id: One or multiple ids (comma list). Expected id format is integer
        :param str log_level: Filter accepts trace, debug, info, warning, error, critical, off
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str order_by: Order result by attribute value, accepts `id`, `serial_number`, `created_at` or `updated_at`, `last_seen_at`, `name`, add `-` as a prefix for descending order. Default value is `id`
        :return: EdgeDeviceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'page', 'per_page', 'include', 'serial_number', 'name', 'type_id', 'status_id', 'software_version_id', 'tenant_id', 'technical_user_id', 'order_user_id', 'log_level', 'specifications_key', 'specifications_value', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_devices_of_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_edge_devices_of_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'serial_number' in params:
            query_params.append(('serial_number', params['serial_number']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'software_version_id' in params:
            query_params.append(('software_version_id', params['software_version_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'technical_user_id' in params:
            query_params.append(('technical_user_id', params['technical_user_id']))  # noqa: E501
        if 'order_user_id' in params:
            query_params.append(('order_user_id', params['order_user_id']))  # noqa: E501
        if 'log_level' in params:
            query_params.append(('log_level', params['log_level']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/edge_devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EdgeDeviceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_specifications_of_api_subscription(self, id, **kwargs):  # noqa: E501
        """Get specifications of an api subscription  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_api_subscription(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the specified api subscription (required)
        :param str key: Filter accepts '*' as wildcard
        :return: SpecificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_specifications_of_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_specifications_of_api_subscription_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_specifications_of_api_subscription_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get specifications of an api subscription  # noqa: E501

        Returns the specification of an object in your accessible scope. If no specifications are defined, this is just an empty object. Specification must have the form below.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_specifications_of_api_subscription_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the specified api subscription (required)
        :param str key: Filter accepts '*' as wildcard
        :return: SpecificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_specifications_of_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_specifications_of_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/specifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpecificationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assets_from_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Remove assets from an api subscription  # noqa: E501

        Remove one or more assets from an API subscription in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int id: Id of the api subscription to fetch (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_assets_from_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_assets_from_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def remove_assets_from_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Remove assets from an api subscription  # noqa: E501

        Remove one or more assets from an API subscription in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assets_from_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be removed. (required)
        :param int id: Id of the api subscription to fetch (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assets_from_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_assets_from_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_assets_from_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/assets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_edge_devices_from_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Remove edge devices from an api subscription  # noqa: E501

        Remove one or more edge devices from an api subscription in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_edge_devices_from_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDevicesIds body: Resources that shall be removed. (required)
        :param int id: Id of the api subscription from which the edge devices will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_edge_devices_from_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_edge_devices_from_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def remove_edge_devices_from_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Remove edge devices from an api subscription  # noqa: E501

        Remove one or more edge devices from an api subscription in your accessible scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_edge_devices_from_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDevicesIds body: Resources that shall be removed. (required)
        :param int id: Id of the api subscription from which the edge devices will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_edge_devices_from_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_edge_devices_from_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_edge_devices_from_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/edge_devices', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_specifications_from_api_subscriptions(self, body, id, **kwargs):  # noqa: E501
        """Delete specifications of an api subscription  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_api_subscriptions(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int id: Id of the specified api subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_specifications_from_api_subscriptions_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_specifications_from_api_subscriptions_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def remove_specifications_from_api_subscriptions_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Delete specifications of an api subscription  # noqa: E501

        The specification keys in the body will be removed of the object in your accessible scope. If a key does not exist it will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_specifications_from_api_subscriptions_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Array of keys to delete from specifications (required)
        :param int id: Id of the specified api subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_specifications_from_api_subscriptions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_specifications_from_api_subscriptions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_specifications_from_api_subscriptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/specifications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_specifications_of_api_subscriptions(self, body, id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of a subscription in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_api_subscriptions(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int id: Id of the specified subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_specifications_of_api_subscriptions_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_specifications_of_api_subscriptions_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def rename_specifications_of_api_subscriptions_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Rename a specification key  # noqa: E501

        Rename one specification key of a subscription in your accessible scope. The key name allows [a-z A-Z 0-9 . - _ ] all uppercase letters will be converted to lower-case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_specifications_of_api_subscriptions_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecificationsRename body: The specifications object to patch. (required)
        :param int id: Id of the specified subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_specifications_of_api_subscriptions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_specifications_of_api_subscriptions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `rename_specifications_of_api_subscriptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/specifications/rename', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_assets_of_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Replace the assets of an api subscription  # noqa: E501

        Replaces all assets belonging to an API subscription in your accessible scope. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int id: Id of the api subscription to fetch (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_assets_of_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_assets_of_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def replace_assets_of_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Replace the assets of an api subscription  # noqa: E501

        Replaces all assets belonging to an API subscription in your accessible scope. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_assets_of_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetIDs body: Resources that shall be replaced (required)
        :param int id: Id of the api subscription to fetch (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_assets_of_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_assets_of_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `replace_assets_of_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/assets', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_edge_devices_of_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Replace the edge devices of an api subscription  # noqa: E501

        Replaces all edge devices belonging to an api subscription in your accessible scope. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_edge_devices_of_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDevicesIds body: Resources that shall be replaced (required)
        :param int id: Id of the api subscription of which the edge devices will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_edge_devices_of_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_edge_devices_of_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def replace_edge_devices_of_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Replace the edge devices of an api subscription  # noqa: E501

        Replaces all edge devices belonging to an api subscription in your accessible scope. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_edge_devices_of_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EdgeDevicesIds body: Resources that shall be replaced (required)
        :param int id: Id of the api subscription of which the edge devices will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_edge_devices_of_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_edge_devices_of_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `replace_edge_devices_of_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/edge_devices', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_api_subscription(self, body, id, **kwargs):  # noqa: E501
        """Update an api subscription  # noqa: E501

        Update accessible parameters of the requested resource. Setting a successor or predecessor is not possible.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_api_subscription(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APISubscriptionRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the api subscription to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_api_subscription_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_api_subscription_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an api subscription  # noqa: E501

        Update accessible parameters of the requested resource. Setting a successor or predecessor is not possible.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_api_subscription_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APISubscriptionRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the api subscription to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_api_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_api_subscription`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_api_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_specifications_of_api_subscriptions(self, body, id, **kwargs):  # noqa: E501
        """Update specifications of an api subscription  # noqa: E501

        Update the specification object of an api subscription in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_api_subscriptions(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationRequest) body: The specifications objects to patch. (required)
        :param int id: Id of the specified api subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_specifications_of_api_subscriptions_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_specifications_of_api_subscriptions_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_specifications_of_api_subscriptions_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update specifications of an api subscription  # noqa: E501

        Update the specification object of an api subscription in your accessible scope. To add specifications, just add the key and set the value object with value, unit and source_timestamp. To mark an existing specification to be unknown, the value could be set to null. To delete keys, use the delete method. Multiple specification objects can be sent in the same request. Keys inside a specification are unique and can only be added once. Keys can only consist of [a-z A-Z 0-9 . - _ ]. All uppercase A-Z are converted to lower-case a-z. For a key that is send multiple times in the request body, only the last key-value is saved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specifications_of_api_subscriptions_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, SpecificationRequest) body: The specifications objects to patch. (required)
        :param int id: Id of the specified api subscription (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_specifications_of_api_subscriptions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_specifications_of_api_subscriptions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_specifications_of_api_subscriptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/api_subscriptions/{id}/specifications', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
