# netilion-api

This is a python client to acccess [Netilion](https://netilion.endress.com/) REST API.

Swagger UI can be found at [Staging API](https://api.staging-env.netilion.endress.com/doc/v1/)
or [Production API](https://api.netilion.endress.com/doc/v1/)

Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/ 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project.

## Requirements.

Python 3.4+

## Usage

```python
import netilion_api
from netilion_api.rest import ApiException

configuration = netilion_api.Configuration()
configuration.api_key['API-Key'] = 'YOUR_BASIC_API_KEY'
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# full list of APIs see in swagger https://api.staging-env.netilion.endress.com/doc/v1/
api_instance = netilion_api.AssetApi(netilion_api.ApiClient(configuration))

try:
    # full list of requests see in swagger https://api.staging-env.netilion.endress.com/doc/v1/
    api_response = api_instance.get_assets()
    print(api_response)
except ApiException as e:
    print("Exception when calling AssetApi->get_assets: %s\n" % e)

```