"use strict";
// ignore "duplicate function implementation" conflict with other response functions
// @ts-expect-error
function handler(event) {
    var response = event.response;
    var headers = response.headers;
    headers['x-frame-options'] = { value: 'deny' };
    headers['x-xss-protection'] = { value: '1; mode=block' };
    headers['x-content-type-options'] = { value: 'nosniff' };
    headers['strict-transport-security'] = { value: 'max-age=47304000; includeSubDomains' };
    headers['content-security-policy'] = {
        value: [
            "default-src 'self' 'unsafe-inline' https://*.awsstatic.com;",
            "connect-src 'self' https://*.shortbread.aws.dev;",
            "frame-src 'none';",
            "img-src 'self' https://* http://*.omtrdc.net;",
            "object-src 'none';",
            "style-src 'self' 'unsafe-inline';",
        ].join(' '),
    };
    headers['clear-site-data'] = { value: '"cache", "storage"' };
    return response;
}
//# sourceMappingURL=data:application/json;base64,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