import type { Context } from 'aws-lambda';
/**
 * Rebuilds the `stats.json` object in the configured S3 bucket.
 * Validates that the number of packages on a full rebuild should not decrease
 * significantly (due to network errors from e.g. NPM) - can be ignored
 * by passing { ignoreValidation: true }.
 *
 * @param event configuration for the rebuild job.
 * @param context the lambda context in which this execution runs.
 *
 * @returns the information about the updated S3 object.
 */
export declare function handler(event: any, context: Context): Promise<import("aws-sdk/lib/request").PromiseResult<import("aws-sdk/clients/s3").PutObjectOutput, import("aws-sdk").AWSError>>;
export interface PackageStatsOutput {
    readonly packages: {
        [key: string]: PackageStatsEntry;
    };
    readonly updated: string;
}
export interface PackageStatsEntry {
    readonly downloads: PackageStatsDownloads;
}
export interface PackageStatsDownloads {
    readonly npm: number;
}
