import { ConcreteWidget } from '@aws-cdk/aws-cloudwatch';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { DocumentationLanguage } from '../shared/language';
export interface MissingDocumentationWidgetProps {
    readonly bucket: IBucket;
    readonly language: DocumentationLanguage;
    readonly title?: string;
    readonly width?: number;
    readonly height?: number;
}
export declare class MissingDocumentationWidget extends ConcreteWidget {
    private readonly handler;
    private readonly language;
    private readonly title?;
    constructor(scope: Construct, id: string, props: MissingDocumentationWidgetProps);
    toJson(): {
        type: string;
        width: number;
        height: number;
        x: number | undefined;
        y: number | undefined;
        properties: {
            endpoint: string;
            params: {
                language: string;
            };
            title: string | undefined;
            updateOn: {
                refresh: boolean;
                resize: boolean;
                timeRange: boolean;
            };
        };
    }[];
}
