# Defect Parameter extraction through Machine Learning

Package containing python source code for machine learning extraction of defect parameters from experimental files.
Follow instructions from python files in example folder on how to use the package.
More information about the process can be found in the following paper: https://www.nature.com/articles/s41524-020-00410-7

Cite as : 
*Buratti, Y., Le Gia, Q. T., Dick, J., Zhu, Y. & Hameiri, Z. Extracting bulk defect parameters in silicon wafers using machine learning models. npj Computational Materials 6, 1–8 (2020)*

Related work:
*Buratti, Y., Dick, J., Gia, Q. L. & Hameiri, Z. A machine learning approach to defect parameters extraction: using random forests to inverse the Shockley-Read-Hall equation. in 46th IEEE Photovoltaic Specialist Conference 4 (2019)*


##  Requirements
Written in python 3.x
Install semiconductor package from https://github.com/MK8J
Other packages needed:
  * numpy
  * pandas
  * matplotlib
  * scipy
  * sklearn
  * pickle
