#!/usr/bin/env python
#
# bore documentation build configuration file, created by
# sphinx-quickstart on Fri Jun  9 13:47:02 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another
# directory, add these directories to sys.path here. If the directory is
# relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
#
import os
import sys
import time
import sphinx_bootstrap_theme

sys.path.insert(0, os.path.abspath('..'))

import bore

# -- General configuration ---------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.viewcode']
extensions.append('matplotlib.sphinxext.plot_directive')
extensions.append('sphinx_gallery.gen_gallery')
extensions.append('nbsphinx')
extensions.append('numpydoc')

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'BORE'
copyright = f"{time.strftime('%Y')}, Louis Tiao"
author = "Louis C. Tiao"

# The version info for the project you're documenting, acts as replacement
# for |version| and |release|, also used in various other places throughout
# the built documents.
#
# The short X.Y version.
version = bore.__version__
# The full version, including alpha/beta/rc tags.
release = bore.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']
exclude_patterns.append('**.ipynb_checkpoints')
# exclude_patterns.append('**.ipynb')
# exclude_patterns.append('gaussian_processes/**')


# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output -------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'bootstrap'
html_theme_path = sphinx_bootstrap_theme.get_html_theme_path()

# Theme options are theme-specific and customize the look and feel of a
# theme further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "bootstrap_version": "3",
    "bootswatch_theme": "cosmo",
    'navbar_links': [
        ("Louis Tiao", "https://tiao.io", True),
        ("Collection", "auto_examples/index")
    ],
    "navbar_sidebarrel": False,
    "source_link_position": "footer"
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []
html_static_path.append('_static')


# -- Options for HTMLHelp output ---------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'boredoc'


# -- Options for LaTeX output ------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'bore.tex',
     'bore Documentation',
     'Louis C. Tiao', 'manual'),
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'bore',
     'bore Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'bore',
     'bore Documentation',
     author,
     'bore',
     'One line description of project.',
     'Miscellaneous'),
]


def reset_mpl(gallery_conf, fname):

    import numpy as np
    import seaborn as sns

    golden_ratio = 0.5 * (1 + np.sqrt(5))

    def golden_size(width):
        return (width, width / golden_ratio)

    width = 10.0

    rc = {
        "figure.figsize": golden_size(width),
        "font.serif": ['Times New Roman'],
        "text.usetex": True,
        "animation.html": "jshtml"
    }

    sns.set(context="notebook",
            style="ticks",
            palette="colorblind",
            font="serif",
            rc=rc)


sphinx_gallery_conf = {
    "matplotlib_animations": True,
    "remove_config_comments": True,
    "reset_modules": (reset_mpl, "seaborn"),
    "reference_url": {
        "sphinx_gallery": None,
    }
}


# sphinx-bootstrap configuration
def setup(app):
    app.add_stylesheet("custom.css")


# nbsphinx configuration
# nbsphinx_input_prompt = ''
# nbsphinx_output_prompt = ''
nbsphinx_timeout = -1

# matplotlib plot directive configuration
plot_include_source = True
plot_pre_code = """
import matplotlib as mpl; mpl.use("pgf")
import numpy as np

import matplotlib.pyplot as plt
import seaborn as sns

golden_ratio = 0.5 * (1 + np.sqrt(5))
golden_size = lambda width: (width, width / golden_ratio)

width = 10

rc = {
    "figure.figsize": golden_size(width),
    "font.serif": ['Times New Roman'],
    "text.usetex": True,
}

sns.set(context="notebook",
        style="ticks",
        palette="colorblind",
        font="serif",
        rc=rc)
"""
