# MIT License
#
# Copyright (c) 2020 Christopher Henderson, chris@chenderson.org
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

class InfiniteCollectionError(ValueError):
    def __init__(self, method):
        name = method.__qualname__ if hasattr(method, '__qualname__') else method.__name__
        super(InfiniteCollectionError, self).__init__('{} was called on an infinitely repeating iterator. '
                                                      'If you use Stream.repeat, then you MUST include either a '
                                                      'Stream.take or a Stream.take_while if you wish to '
                                                      'call {}'.format(name, name))


class NotCallableError(ValueError):
    def __init__(self, method, received):
        super(NotCallableError, self).__init__('{} requires a callable. Received {}'.format(method, type(received)))
