import logging
from termcolor import colored


def color(string, color_name='yellow'):
    """Returns colored string for output to terminal"""
    return colored(string, color_name)


def set_logger(log_path):
    """Set the logger to log info in terminal and file `log_path`.

    :param log_path: file path where to log
    :type log_path: str
    """
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)

    if not logger.handlers:
        # Logging to a file
        file_handler = logging.FileHandler(log_path)
        file_handler.setFormatter(logging.Formatter('%(asctime)s:%(levelname)s: %(message)s'))
        logger.addHandler(file_handler)

        # Logging to console
        stream_handler = logging.StreamHandler()
        stream_handler.setFormatter(logging.Formatter('%(message)s'))
        logger.addHandler(stream_handler)