
import re

def readActions(format_inhalt_list):
    actions = []
    for format, inhalt in format_inhalt_list:

        action = {}

        if format == "Textnachricht":
            action["type"] = "message"
            action["text"] = inhalt

        elif format == "Audionachricht":
            action["type"] = "audio"
            regex = r"Datei: (?P<file>.*)\nAnzeigename: (?P<name>.*)\nPerformer: (?P<performer>.*)"

            match = re.search(regex, inhalt)
            if match:
                action["file"] = "assets/" + match.group('file')
                action["title"] = match.group('name')
                action["performer"] = match.group('performer')
            else:
                action["file"] = "assets/platzhalter.mp3"
                action["title"] = inhalt
                action["performer"] = "🤖"

        elif format == "Foto":
            action["type"] = "photo"
            regex = r"Datei: (?P<file>.*)\nAnzeigename: (?P<name>.*)"

            match = re.search(regex, inhalt)
            if match:
                action["file"] = "assets/" + match.group('file')
                action["caption"] = match.group('name')
            else:
                action["file"] = "assets/platzhalter.png"
                action["caption"] = inhalt

        elif format == "GPS":
            action["type"] = "venue"

            action["longitude"] = re.search(
                r"L: (?P<long>.*)", inhalt).group('long')
            action["latitude"] = re.search(r"B: (?P<lat>.*)", inhalt).group('lat')
            action["title"] = re.search(
                r"Anzeigename: (?P<name>.*)", inhalt).group('name')
            action["address"] = re.search(
                r"Adresse: (?P<address>.*)", inhalt).group('address')

        elif format == "Video":
            action["type"] = "video"
            regex = r"Datei: (?P<file>.*)\nAnzeigename: (?P<caption>.*)"

            match = re.search(regex, inhalt)
            if match:
                action["file"] = "assets/" + match.group('file')
                action["caption"] = match.group('caption')

        elif format == "Sticker":
            regex = r"ID: (?P<id>.*)$"

            match = re.search(regex, inhalt)
            action["type"] = "sticker"
            if match:
                action["id"] = match.group('id')
            else:
                print("Die angegebenen Informationen im Feld ({}) stimmen nicht mit dem angegebenen Format ({}) überein.".format(
                    inhalt, format))
        elif format == "Kontextspeicherung":
            action["type"] = "function"
            action["func"] = "save_to_context"
            action["key"] = "name"
        elif format == "Return":
            action["type"] = "return"
            action["state"] = inhalt
        elif format == "Formel":
            action["type"] = "function"
            action["func"] = re.search(
                r"function: (?P<function>.*)", inhalt).group('function')
            for line in inhalt.split("\n")[1:]:
                if len(line.split(": "))==2:
                    argument, value = line.split(": ")
                    action[argument] = value

        else:
            print("Das angegebene Format ({}) ist nicht bekannt".format(format))

        actions.append(action)

    return actions
