# DSSData


_**⚡A python micro-framework for steady-state simulation and data analysis of electrical distribution systems modeled on [OpenDSS](https://www.epri.com/#/pages/sa/opendss?lang=en).**_

Mode support: Static and Time-series.

## Why DSSData?

The propose of DSSData is to facilitate the steady-state simulation of modern electrical distribution systems, such as microgrid, smart grids, and smart cities.

With DSSData you can easily make your own super new fancy operation strategies with storage or generators, probabilistic simulation, or a simple impact studies of a distributed generator. See an example in our [Tutorial](https://felipemarkson.github.io/dssdata/tutorial/).

**_All you need is your base distribution system modeled in OpenDSS!!!_**

### Easy to simulate

We built the DSSData for you just write what you want in a simple function, plugin on a power flow mode, and run. 

You don't need anymore write a routine to run each power flow per time. 

## Documentation

See [DSSData Documentation](https://felipemarkson.github.io/dssdata).

## Installation

We strongly recommend the use of virtual environments manager.

### Using pip

```console
pip install dssdata
```

### Using poetry

```console
poetry add dssdata
```

## Help us to improve DSSData

See our [Issue](https://github.com/felipemarkson/dssdata/issues) section!


## Contributors: 

- [JonasVil](https://github.com/felipemarkson/power-flow-analysis/commits?author=JonasVil)
