import random
import string

unisex_names = [
    "Addison",
    "Adrian",
    "Aiden",
    "Ainsley",
    "Alex",
    "Amari",
    "Andy",
    "Ari",
    "Ash",
    "Aspen",
    "Aubrey",
    "August",
    "Avery",
    "Bailey",
    "Bay",
    "Blaine",
    "Blake",
    "Bobbie",
    "Brett",
    "Brook",
    "Brooklyn",
    "Caelan",
    "Cameron",
    "Campbell",
    "Carroll",
    "Carson",
    "Casey",
    "Charlie",
    "Chris",
    "Clay",
    "Corey",
    "Dana",
    "Dakota",
    "Dale",
    "Dallas",
    "Daryl",
    "Delta",
    "Devin",
    "Dorian",
    "Drew",
    "Dylan",
    "Easton",
    "Eddie",
    "Eli",
    "Elliott",
    "Emerson",
    "Emery",
    "Finley",
    "Frances",
    "Frankie",
    "Gabriel",
    "Glenn",
    "Gray",
    "Harley",
    "Harper",
    "Hayden",
    "Hudson",
    "Hunter",
    "James",
    "Jamie",
    "Jayden",
    "Jean",
    "Jesse",
    "Jordan",
    "Jules",
    "Julian",
    "Kaden",
    "Kai",
    "Karter",
    "Kelly",
    "Kelsey",
    "Kendall",
    "Kennedy",
    "Kyle",
    "Lake",
    "Landry",
    "Lincoln",
    "Logan",
    "London",
    "Lou",
    "Mackenzie",
    "Mason",
    "Max",
    "Maxwell",
    "Monroe",
    "Morgan",
    "Parker",
    "Pat",
    "Peyton",
    "Phoenix",
    "Quinn",
    "Ray",
    "Reagan",
    "Reed",
    "Reese",
    "Remy",
    "Riley",
    "River",
    "Roan",
    "Rory",
    "Rowan",
    "Rudy",
    "Ryan",
    "Sage",
    "Sam",
    "Sawyer",
    "Shawn",
    "Sean",
    "Skylar",
    "Spencer",
    "Stevie",
    "Sydney",
    "Tanner",
    "Tatum",
    "Taylor",
    "Toby",
    "Tyler",
    "Val",
    "West",
    "Winter",
]
last_names = [
    "Adams",
    "Alexander",
    "Allen",
    "Anderson",
    "Bailey",
    "Baker",
    "Barnes",
    "Bell",
    "Bennett",
    "Brooks",
    "Brown",
    "Bryant",
    "Butler",
    "Campbell",
    "Carter",
    "Clark",
    "Coleman",
    "Collins",
    "Cook",
    "Cooper",
    "Cox",
    "Davis",
    "Diaz",
    "Edwards",
    "Evans",
    "Flores",
    "Foster",
    "Garcia",
    "Gonzales",
    "Gonzalez",
    "Gray",
    "Green",
    "Griffin",
    "Hall",
    "Harris",
    "Hayes",
    "Henderson",
    "Hernandez",
    "Hill",
    "Howard",
    "Hughes",
    "Jackson",
    "James",
    "Jenkins",
    "Johnson",
    "Jones",
    "Kelly",
    "King",
    "Lee",
    "Lewis",
    "Long",
    "Lopez",
    "Martin",
    "Martinez",
    "Miller",
    "Mitchell",
    "Moore",
    "Morgan",
    "Morris",
    "Murphy",
    "Nelson",
    "Parker",
    "Patterson",
    "Perez",
    "Perry",
    "Peterson",
    "Phillips",
    "Powell",
    "Price",
    "Ramirez",
    "Reed",
    "Richardson",
    "Rivera",
    "Roberts",
    "Robinson",
    "Rodriguez",
    "Rogers",
    "Ross",
    "Russell",
    "Sanchez",
    "Sanders",
    "Scott",
    "Simmons",
    "Smith",
    "Stewart",
    "Taylor",
    "Thomas",
    "Thompson",
    "Torres",
    "Turner",
    "Walker",
    "Ward",
    "Washington",
    "Watson",
    "White",
    "Williams",
    "Wilson",
    "Wood",
    "Wright",
    "Young",
]

metals = {
    "Brass",
    "Copper",
    "Gallium",
    "Iron",
    "Lead",
    "Nickel",
    "Pewter",
    "Steel",
    "Tin",
    "Zinc",
}


def random_name(existing_names=None):
    existing_names = existing_names or []
    existing_first_names, existing_last_names = [], []
    for name in existing_names:
        bits = name.split(" ")
        existing_first_names.append(bits[0])
        existing_last_names.append(bits[-1])

    first_name = None
    while first_name is None or first_name in existing_first_names:
        first_name = random.choice(unisex_names)
    parts = [first_name]
    if not random.randint(0, 5):
        parts.append(f"{random.choice(string.ascii_lowercase.upper())}.")
    last_name = None
    while last_name is None or last_name in existing_last_names:
        if random.randint(0, 10):
            last_name = random.choice(last_names)
        else:
            last_name = "-".join(random.sample(last_names, 2))
    parts.append(last_name)
    return " ".join(parts)


def metal_name(existing_names=None):
    existing_names = set(existing_names) if existing_names else set()
    available = metals - existing_names
    extra = 1
    while not available:
        extra += 1
        available += set(f"{n} {extra}" for n in metals) - existing_names
    return random.choice(list(available))


if __name__ == "__main__":
    print(random_name())
