# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubiops.configuration import Configuration


class FileDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'continuation_token': 'str',
        'files': 'list[FileItem]',
        'prefixes': 'list[str]'
    }

    attribute_map = {
        'continuation_token': 'continuation_token',
        'files': 'files',
        'prefixes': 'prefixes'
    }

    def __init__(self, continuation_token=None, files=None, prefixes=None, local_vars_configuration=None, **kwargs):  # noqa: E501
        """FileDetail - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._continuation_token = None
        self._files = None
        self._prefixes = None
        self.discriminator = None

        self.continuation_token = continuation_token
        self.files = files
        self.prefixes = prefixes

    @property
    def continuation_token(self):
        """Gets the continuation_token of this FileDetail.  # noqa: E501


        :return: The continuation_token of this FileDetail.  # noqa: E501
        :rtype: str
        """
        return self._continuation_token

    @continuation_token.setter
    def continuation_token(self, continuation_token):
        """Sets the continuation_token of this FileDetail.


        :param continuation_token: The continuation_token of this FileDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                continuation_token is not None and not isinstance(continuation_token, str)):
            raise ValueError("Parameter `continuation_token` must be a string")  # noqa: E501

        if (self.local_vars_configuration.client_side_validation and
                continuation_token is not None and len(continuation_token) < 1):
            raise ValueError("Invalid value for `continuation_token`, length must be greater than or equal to `1`")  # noqa: E501

        self._continuation_token = continuation_token

    @property
    def files(self):
        """Gets the files of this FileDetail.  # noqa: E501


        :return: The files of this FileDetail.  # noqa: E501
        :rtype: list[FileItem]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this FileDetail.


        :param files: The files of this FileDetail.  # noqa: E501
        :type: list[FileItem]
        """
        if self.local_vars_configuration.client_side_validation and files is None:  # noqa: E501
            raise ValueError("Invalid value for `files`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                files is not None and not isinstance(files, list)):
            raise ValueError("Parameter `files` must be a list")  # noqa: E501
        if self.local_vars_configuration.client_side_validation and files is not None:
            from ubiops.models.file_item import FileItem

            files = [
                FileItem(**item) if isinstance(item, dict) else item  # noqa: E501
                for item in files
            ]

        self._files = files

    @property
    def prefixes(self):
        """Gets the prefixes of this FileDetail.  # noqa: E501


        :return: The prefixes of this FileDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._prefixes

    @prefixes.setter
    def prefixes(self, prefixes):
        """Sets the prefixes of this FileDetail.


        :param prefixes: The prefixes of this FileDetail.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and prefixes is None:  # noqa: E501
            raise ValueError("Invalid value for `prefixes`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                prefixes is not None and not isinstance(prefixes, list)):
            raise ValueError("Parameter `prefixes` must be a list")  # noqa: E501

        self._prefixes = prefixes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileDetail):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileDetail):
            return True

        return self.to_dict() != other.to_dict()
