# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class Roles(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def permissions_list_with_http_info(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PermissionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PermissionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Assign role to user/object  # noqa: E501

         ### Description  Assign a role to a user or an object in the scope of a project. This role can be assigned on either project level or on object level, which can be a deployment, pipeline or bucket.  ### Required Parameters  - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role to be assigned to the user   - `assignee`: UUID of the user or the name of the object for which the role will be assigned   - `assignee_type`: Type of the assignee. It can be user or deployment. - `resource`: Name of the object for which the role will be assigned   - `resource_type`: Type of the object for which the role will be assigned. It can be project, deployment, pipeline or bucket.  **resource and resource_type must be provided together. If neither of them is provided, the role is set on project level.**  #### Request Examples Setting the role deployment-admin on project level for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-admin\" } ```  Setting the role deployment-viewer on deployment-1 for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-viewer\",   \"resource\": \"deployment-1\",   \"resource_type\": \"deployment\" } ```  Setting the role files-reader on bucket-1 for deployment-1 ``` {   \"assignee\": \"deployment-1\",   \"assignee_type\": \"deployment\",   \"role\": \"file-reader\",   \"resource\": \"bucket-1\",   \"resource_type\": \"bucket\" } ```  ### Response Structure  Details of the created role assignment - `id`: Unique identifier for the role assignment (UUID) - `assignee`: UUID of the user or the name of the object - `assignee_type`: Type of the assignee - `role`: Name of the role assigned to the user - `resource`: Name of the object for which the role is assigned - `resource_type`: Type of the object for which the role is assigned  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-admin\",   \"resource\": \"project-1\",   \"resource_type\": \"project\" } ```  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"assignee\": \"deployment-1\",   \"assignee_type\": \"deployment\",   \"role\": \"file-reader\",   \"resource\": \"bucket-1\",   \"resource_type\": \"bucket\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleAssignmentCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleAssignmentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `role_assignments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `role_assignments_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.role_assignment_create import RoleAssignmentCreate

                local_var_params['data'] = RoleAssignmentCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleAssignmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_delete_with_http_info(self, project_name, id, **kwargs):  # noqa: E501
        """Delete role of user  # noqa: E501

         ### Description  Delete a role of a user.  It is possible for a user to delete their own role if they have permissions to do so.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_delete_with_http_info(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `role_assignments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `role_assignments_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `role_assignments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_get_with_http_info(self, project_name, id, **kwargs):  # noqa: E501
        """Get role assignment  # noqa: E501

         ### Description  Get the details of a role assignment of a user/deployment.  ### Response Structure Details of the role assignment - `id`: Unique identifier for the role assignment (UUID) - `assignee`: UUID of the user or the name of the object - `assignee_type`: Type of the assignee - `role`: Name of the role assigned to the user/object - `resource`: Name of the object for which the role is assigned - `resource_type`: Type of the object for which the role is assigned  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"assignee_type\": \"user\",   \"role\": \"deployment-admin\",   \"resource\": \"project-1\",   \"resource_type\": \"project\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_get_with_http_info(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleAssignmentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `role_assignments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `role_assignments_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'id' in local_var_params
            and local_var_params['id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['id'], str):  # noqa: E501
                raise ApiValueError("Parameter `id` must be a string when calling `role_assignments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleAssignmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_per_object_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List roles on object/user  # noqa: E501

         ### Description  List the roles assigned to a user or on an object in the scope of a project.   ### Optional Parameters These parameters should be given as query parameters - `resource`: Name of the object on which the assigned roles will be listed - `resource_type`: Type of the object on which the assigned roles will be listed - `assignee`: UUID of the user or the name of the object for which the assigned roles will be listed - `assignee_type`: Type of the assignee for which the assigned roles will be listed  ### Response Structure - `id`: Unique identifier for the role assignment (UUID) - `assignee`: UUID of the user or the name of the object - `assignee_type`: Type of the assignee - `role`: Name of the role assigned to the user/object - `resource`: Name of the object for which the role is assigned - `resource_type`: Type of the object for which the role is assigned  #### Response Examples Roles assigned to user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"assignee_type\": \"user\",     \"role\": \"deployment-admin\",     \"resource\": \"project-1\",     \"resource_type\": \"project\"   },   {     \"id\": \"13cf9dd7-7356-4797-b453-e0cb6b416162\",     \"assignee\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"assignee_type\": \"user\",     \"role\": \"pipeline-admin\",     \"resource\": \"pipeline-1\",     \"resource_type\": \"pipeline\"   } ] ```  Roles assigned on deployment with name deployment-1 ``` [   {     \"id\": \"a24aabc2-c7df-4f7b-b177-f80827aea1bb\",     \"assignee\": \"258771bb-1bc4-4f2f-a3f4-9309cc64d1dd\",     \"assignee_type\": \"user\",     \"role\": \"deployment-admin\",     \"resource\": \"deployment-1\",     \"resource_type\": \"deployment\"   },   {     \"id\": \"dfd4e714-9c2d-446e-ae96-4db18f91d3de\",     \"assignee\": \"0ca8a61d-962e-48e3-b558-61e8ca2dae88\",     \"assignee_type\": \"user\",     \"role\": \"deployment-viewer\",     \"resource\": \"deployment-1\",     \"resource_type\": \"deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_per_object_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str resource:
        :param str resource_type:
        :param str assignee:
        :param str assignee_type:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RoleAssignmentList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'resource', 'resource_type', 'assignee', 'assignee_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_per_object_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_per_object_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `role_assignments_per_object_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'resource' in local_var_params
            and local_var_params['resource'] is not None):  # noqa: E501
            if not isinstance(local_var_params['resource'], str):  # noqa: E501
                raise ApiValueError("Parameter `resource` must be a string when calling `role_assignments_per_object_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'resource_type' in local_var_params
            and local_var_params['resource_type'] is not None):  # noqa: E501
            if not isinstance(local_var_params['resource_type'], str):  # noqa: E501
                raise ApiValueError("Parameter `resource_type` must be a string when calling `role_assignments_per_object_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'assignee' in local_var_params
            and local_var_params['assignee'] is not None):  # noqa: E501
            if not isinstance(local_var_params['assignee'], str):  # noqa: E501
                raise ApiValueError("Parameter `assignee` must be a string when calling `role_assignments_per_object_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'assignee_type' in local_var_params
            and local_var_params['assignee_type'] is not None):  # noqa: E501
            if not isinstance(local_var_params['assignee_type'], str):  # noqa: E501
                raise ApiValueError("Parameter `assignee_type` must be a string when calling `role_assignments_per_object_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'resource' in local_var_params and local_var_params['resource'] is not None:  # noqa: E501
            query_params.append(('resource', local_var_params['resource']))  # noqa: E501
        if 'resource_type' in local_var_params and local_var_params['resource_type'] is not None:  # noqa: E501
            query_params.append(('resource_type', local_var_params['resource_type']))  # noqa: E501
        if 'assignee' in local_var_params and local_var_params['assignee'] is not None:  # noqa: E501
            query_params.append(('assignee', local_var_params['assignee']))  # noqa: E501
        if 'assignee_type' in local_var_params and local_var_params['assignee_type'] is not None:  # noqa: E501
            query_params.append(('assignee_type', local_var_params['assignee_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RoleAssignmentList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create a custom role scoped in a project  # noqa: E501

         ### Description  Create a custom role in the scope of a project. This role is not accessible from other projects.  The user making the request must have appropriate permissions.  ### Required Parameters  - `name`: Name of the role which will be created. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A list of permissions which the role will contain. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"custom-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```  ### Response Structure  Details of the created role - `id`: Unique identifier for the created role (UUID)   - `name`: Name of the created role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleDetailList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `roles_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `roles_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.role_create import RoleCreate

                local_var_params['data'] = RoleCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDetailList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_delete_with_http_info(self, project_name, role_name, **kwargs):  # noqa: E501
        """Delete a role from a project  # noqa: E501

         ### Description  Delete a role from a project. The user making the request must have appropriate permissions. **Default roles cannot be deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_delete_with_http_info(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'role_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_delete`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if self.api_client.client_side_validation and ('role_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_name` when calling `roles_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `roles_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'role_name' in local_var_params
            and local_var_params['role_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['role_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `role_name` must be a string when calling `roles_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'role_name' in local_var_params:
            path_params['role_name'] = local_var_params['role_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles/{role_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_get_with_http_info(self, project_name, role_name, **kwargs):  # noqa: E501
        """Get details of a role  # noqa: E501

         ### Description  Get the details of a role. The user making the request must have appropriate permissions.  ### Response Structure Details of the role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_get_with_http_info(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleDetailList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'role_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_get`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if self.api_client.client_side_validation and ('role_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_name` when calling `roles_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `roles_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'role_name' in local_var_params
            and local_var_params['role_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['role_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `role_name` must be a string when calling `roles_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'role_name' in local_var_params:
            path_params['role_name'] = local_var_params['role_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles/{role_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDetailList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List the available roles in a project  # noqa: E501

         ### Description  List the roles available in the scope of a project. Information on which permissions each role contains, can be obtained with a call to get details of a single role.  ### Response Structure - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not    #### Response Examples ``` [   {     \"id\": \"34e53855-9b50-47bc-b516-6cb971b1949c\",     \"name\": \"project-admin\",     \"default\": true   },   {     \"id\": \"00132911-b5dd-4017-b399-85f3ffd2a7c3\",     \"name\": \"project-editor\",     \"default\": true   },   {     \"id\": \"bf0d5823-8062-40f6-bbd2-21bc732f3c3b\",     \"name\": \"project-viewer\",     \"default\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RoleList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `roles_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RoleList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_update_with_http_info(self, project_name, role_name, data, **kwargs):  # noqa: E501
        """Update a role in a project  # noqa: E501

         ### Description  Update a role in a project. The user making the request must have appropriate permissions. **Default roles cannot be updated.**  ### Optional Parameters  - `name`: New name for the role. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A new list of permissions which the role will contain. The previous permissions will be replaced with the given ones. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"new-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```  ### Response Structure  Details of the updated role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the updated role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"new-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_update_with_http_info(project_name, role_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param RoleUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleDetailList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'role_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_update`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if self.api_client.client_side_validation and ('role_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_name` when calling `roles_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `roles_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `roles_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'role_name' in local_var_params
            and local_var_params['role_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['role_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `role_name` must be a string when calling `roles_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.role_update import RoleUpdate

                local_var_params['data'] = RoleUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'role_name' in local_var_params:
            path_params['role_name'] = local_var_params['role_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles/{role_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDetailList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
