# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class Files(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def buckets_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create bucket  # noqa: E501

         ### Description  Create a bucket in a project  ### Required Parameters  - `name`: Name of the bucket. It is unique within a project.  ### Optional Parameters - `provider`: Provider of the bucket. It can be 'ubiops', 'google_cloud_storage', 'amazon_s3' or 'azure_blob_storage'. The default is **ubiops**. - `credentials`: A dictionary for credentials to connect to the bucket. It is only required for providers other than *ubiops*. Each provider requires a different set of fields:   - For Amazon S3, provide the fields `access_key` and `secret_key`.   - For Azure Blob Storage, provide the field `connection_string` in the format: *DefaultEndpointsProtocol=https;AccountName=<account-name>;AccountKey=<account-key>;EndpointSuffix=core.windows.net*.   - For Google Cloud Storage, provide the field `json_key_file`. - `configuration`: A dictionary for additional configuration details for the bucket. It is only required for providers other than *ubiops*. Each provider requires a different set of fields:   - For Amazon S3, provide the fields `bucket` and `prefix`. One of the fields `region` or `endpoint_url` needs to be provided. The fields `verify` and `use_ssl` are optional.   - For Azure Blob Storage, provide the fields `container` and `prefix`.   - For Google Cloud Storage, provide the fields `bucket` and `prefix`.   UbiOps always makes sure that the prefix ends with a '/'. - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket. It must be a multiple of 604800 (1 week). Pass `null` to keep them forever.  #### Request Examples ``` {   \"name\": \"bucket-1\",   \"provider\": \"ubiops\",   \"credentials\": {},   \"configuration\": {},   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\" } ```  ### Response Structure  Details of the created bucket - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is created - `provider`: Provider of the bucket - `credentials`: Credentials to connect to the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"bucket-1\",   \"project\": \"project-1\",   \"provider\": \"ubiops\",   \"credentials\": {},   \"configuration\": {},   \"creation_date\": \"2022-05-12T16:23:15.456812Z\",   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\",   \"ttl\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param BucketCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BucketList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method buckets_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `buckets_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `buckets_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `buckets_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.bucket_create import BucketCreate

                local_var_params['data'] = BucketCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BucketList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def buckets_delete_with_http_info(self, project_name, bucket_name, **kwargs):  # noqa: E501
        """Delete a bucket  # noqa: E501

         ### Description  Delete a bucket. If the bucket provider is UbiOps, the files in the bucket will be deleted together with the bucket. For other providers, the files in the bucket are not removed but just the connection from UbiOps to the bucket.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_delete_with_http_info(project_name, bucket_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method buckets_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `buckets_delete`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `buckets_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `buckets_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `buckets_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def buckets_get_with_http_info(self, project_name, bucket_name, **kwargs):  # noqa: E501
        """Get details of a bucket  # noqa: E501

         ### Description  Retrieve details of a bucket in a project  ### Response Structure  Details of a bucket - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is defined - `provider`: Provider of the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket - `size`: Size of the bucket according to the last measurement date - `size_measurement_date`: Last measurement date of the size of the bucket  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"bucket-1\",   \"project\": \"project-1\",   \"provider\": \"ubiops\",   \"configuration\": {},   \"creation_date\": \"2022-05-12T16:23:15.456812Z\",   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\",   \"ttl\": null,   \"size\": 2048,   \"size_measurement_date\": \"2022-05-24T02:23:15.456812Z\", } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_get_with_http_info(project_name, bucket_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BucketDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method buckets_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `buckets_get`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `buckets_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `buckets_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `buckets_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BucketDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def buckets_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List buckets  # noqa: E501

         ### Description List buckets in a project  ### Optional Parameters - `labels`: Filter on labels of the buckets. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). Buckets that have at least one of the labels in the filter are returned. This parameter should be given as query parameter.  ### Response Structure  A list of details of the buckets in the project - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is defined - `provider`: Provider of the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"bucket-1\",     \"project\": \"project-1\",     \"provider\": \"ubiops\",     \"creation_date\": \"2022-05-12T16:23:15.456812Z\",     \"configuration\": {},     \"labels\": {       \"type\": \"bucket\"     },     \"description\": \"My bucket description\",     \"ttl\": null   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"bucket-2\",     \"project\": \"project-1\",     \"provider\": \"ubiops\",     \"creation_date\": \"2022-05-12T16:23:15.456812Z\",     \"configuration\": {},     \"labels\": {},     \"description\": \"My bucket 2 description\",     \"ttl\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BucketList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method buckets_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `buckets_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `buckets_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `buckets_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BucketList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def buckets_update_with_http_info(self, project_name, bucket_name, data, **kwargs):  # noqa: E501
        """Update a bucket  # noqa: E501

         ### Description  Update a bucket  ### Optional Parameters - `credentials`: Credentials to connect to the bucket - `configuration`: Additional configuration details for the bucket  - `description`: New description for the bucket - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `ttl`: Time to live for the files in the bucket. It must be a multiple of 604800 (1 week).  #### Request Examples ``` {   \"description\": \"New description for the bucket\" } ```  ### Response Structure  Details of the updated bucket - `id`: Unique identifier for the bucket (UUID) - `name`: Name of the bucket - `project`: Project name in which the bucket is defined - `provider`: Provider of the bucket - `configuration`: Additional configuration details for the bucket - `creation_date`: The date when the bucket was created - `description`: Description of the bucket - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `ttl`: Time to live for the files in the bucket - `size`: Size of the bucket according to the last measurement date - `size_measurement_date`: Last measurement date of the size of the bucket  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-bucket-name\",   \"project\": \"project-1\",   \"provider\": \"ubiops\",   \"configuration\": {},   \"creation_date\": \"2022-05-12T16:23:15.456812Z\",   \"labels\": {     \"type\": \"bucket\"   },   \"description\": \"My bucket description\",   \"ttl\": null,   \"size\": 2048,   \"size_measurement_date\": \"2022-05-24T02:23:15.456812Z\", } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buckets_update_with_http_info(project_name, bucket_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param BucketUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BucketDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method buckets_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `buckets_update`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `buckets_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `buckets_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `buckets_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `buckets_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.bucket_update import BucketUpdate

                local_var_params['data'] = BucketUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BucketDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_delete_with_http_info(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Delete a file  # noqa: E501

         ### Description Delete a file from a bucket   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_delete_with_http_info(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `files_delete`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `files_delete`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `files_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `files_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `files_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'file' in local_var_params
            and local_var_params['file'] is not None):  # noqa: E501
            if not isinstance(local_var_params['file'], str):  # noqa: E501
                raise ApiValueError("Parameter `file` must be a string when calling `files_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501
        if 'file' in local_var_params:
            path_params['file'] = local_var_params['file']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}/files/{file}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_download_with_http_info(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Download a file  # noqa: E501

         ### Description Generate a signed url to download a file. Request body should be an empty dictionary.  ### Response Structure  - `url`: A url which can be used to download the file from bucket. Make a GET request to this url to download the file. - `provider`: Provider of the bucket where the file will be uploaded  #### Response Examples ``` {   \"url\": \"https://storage.apis.com/my-bucket/my-file.jpg...\",   \"provider\": \"ubiops\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_download_with_http_info(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileUploadResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `files_download`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `files_download`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `files_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `files_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `files_download`")  # noqa: E501
        if (self.api_client.client_side_validation and 'file' in local_var_params
            and local_var_params['file'] is not None):  # noqa: E501
            if not isinstance(local_var_params['file'], str):  # noqa: E501
                raise ApiValueError("Parameter `file` must be a string when calling `files_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501
        if 'file' in local_var_params:
            path_params['file'] = local_var_params['file']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}/files/{file}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_get_with_http_info(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Get a file  # noqa: E501

         ### Description Get the details of a file in the bucket  ### Response Structure  - `file`: Name of the file - `size`: Size of the file - `time_created`: The time that the file was created  #### Response Examples ``` {   \"file\": \"my-file-1\",   \"size\": 123,   \"time_created\": \"2022-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_get_with_http_info(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileItem, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `files_get`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `files_get`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `files_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `files_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `files_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'file' in local_var_params
            and local_var_params['file'] is not None):  # noqa: E501
            if not isinstance(local_var_params['file'], str):  # noqa: E501
                raise ApiValueError("Parameter `file` must be a string when calling `files_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501
        if 'file' in local_var_params:
            path_params['file'] = local_var_params['file']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}/files/{file}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileItem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_list_with_http_info(self, project_name, bucket_name, **kwargs):  # noqa: E501
        """List files  # noqa: E501

         ### Description List files in a bucket  ### Optional Parameters The following parameters should be given as query parameters: - `prefix`: Prefix to filter files - `delimiter`: Delimiter used with prefix to emulate hierarchy to filter files - `limit`: The maximum number of files returned, default is 100 - `continuation_token`: A token that indicates the start point of the returned the files  ### Response Structure  A dictionary containing the details of files and prefixes in the bucket - `continuation_token`: Next token to get the next set of files - `files`: A list of dictionaries containing the details of the files. It contains the file name ('file'), size of the file ('size') and the creation time of the file ('time_created'). - `prefixes`: A list of directories  #### Response Examples ``` {   \"continuation_token\": \"1234\",   \"files\": [     {       \"file\": \"my-file-1\",       \"size\": 123,       \"time_created\": \"2022-05-12T16:23:15.456812Z\"     },     {       \"file\": \"my-file-2\",       \"size\": 456,       \"time_created\": \"2022-06-05T10:56:12.186046Z\"     }   ],   \"prefixes\": [     \"my-dir-1\",     \"my-dir-2\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_list_with_http_info(project_name, bucket_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str prefix:
        :param str delimiter:
        :param str continuation_token:
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name', 'prefix', 'delimiter', 'continuation_token', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `files_list`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `files_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `files_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `files_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'prefix' in local_var_params
            and local_var_params['prefix'] is not None):  # noqa: E501
            if not isinstance(local_var_params['prefix'], str):  # noqa: E501
                raise ApiValueError("Parameter `prefix` must be a string when calling `files_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'delimiter' in local_var_params
            and local_var_params['delimiter'] is not None):  # noqa: E501
            if not isinstance(local_var_params['delimiter'], str):  # noqa: E501
                raise ApiValueError("Parameter `delimiter` must be a string when calling `files_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'continuation_token' in local_var_params
            and local_var_params['continuation_token'] is not None):  # noqa: E501
            if not isinstance(local_var_params['continuation_token'], str):  # noqa: E501
                raise ApiValueError("Parameter `continuation_token` must be a string when calling `files_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `files_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501

        query_params = []
        if 'prefix' in local_var_params and local_var_params['prefix'] is not None:  # noqa: E501
            query_params.append(('prefix', local_var_params['prefix']))  # noqa: E501
        if 'delimiter' in local_var_params and local_var_params['delimiter'] is not None:  # noqa: E501
            query_params.append(('delimiter', local_var_params['delimiter']))  # noqa: E501
        if 'continuation_token' in local_var_params and local_var_params['continuation_token'] is not None:  # noqa: E501
            query_params.append(('continuation_token', local_var_params['continuation_token']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_upload_with_http_info(self, project_name, bucket_name, file, **kwargs):  # noqa: E501
        """Upload a file  # noqa: E501

         ### Description Generate a signed url to upload a file. Request body should be an empty dictionary.  Note: When using the url generated by this endpoint for Azure Blob Storage, the following headers must be added to the upload request to Azure Blob Storage: - `x-ms-version`: '2020-04-08' - `x-ms-blob-type`: 'BlockBlob'  ### Response Structure  - `url`: A url which can be used to upload the file to bucket. Make a PUT request to this url with the file content to upload the file. - `provider`: Provider of the bucket where the file will be uploaded  #### Response Examples ``` {   \"url\": \"https://storage.apis.com/my-bucket/my-file.jpg...\",   \"provider\": \"ubiops\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_upload_with_http_info(project_name, bucket_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str bucket_name: (required)
        :param str file: (required)
        :param object data:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileUploadResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'bucket_name', 'file', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `files_upload`")  # noqa: E501
        # verify the required parameter 'bucket_name' is set
        if self.api_client.client_side_validation and ('bucket_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['bucket_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bucket_name` when calling `files_upload`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `files_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `files_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'bucket_name' in local_var_params
            and local_var_params['bucket_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['bucket_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `bucket_name` must be a string when calling `files_upload`")  # noqa: E501
        if (self.api_client.client_side_validation and 'file' in local_var_params
            and local_var_params['file'] is not None):  # noqa: E501
            if not isinstance(local_var_params['file'], str):  # noqa: E501
                raise ApiValueError("Parameter `file` must be a string when calling `files_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'bucket_name' in local_var_params:
            path_params['bucket_name'] = local_var_params['bucket_name']  # noqa: E501
        if 'file' in local_var_params:
            path_params['file'] = local_var_params['file']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/buckets/{bucket_name}/files/{file}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
