# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class DeploymentRequests(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_deployment_requests_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a batch deployment request  # noqa: E501

         ### Description Request multiple predictions from the default version of a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods.  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_version_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a batch deployment version request  # noqa: E501

         ### Description Request multiple predictions from a deployment version. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state).  If one of the requests is faulty, all requests are denied. The maximum number of requests per batch call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the batch deployment request in seconds. The maximum allowed value is 172800 (48 hours) and the default value is 14400 (4 hours). - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  #### Request Examples  Multiple structured batch deployment requests ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  Multiple plain batch deployment requests ``` [   \"plain-data-goes-here\", \"plain-example-data\" ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[object] data: (required)
        :param int timeout:
        :param str notification_group:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data', 'timeout', 'notification_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `batch_deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group' in local_var_params
            and local_var_params['notification_group'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group` must be a string when calling `batch_deployment_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'notification_group' in local_var_params and local_var_params['notification_group'] is not None:  # noqa: E501
            query_params.append(('notification_group', local_var_params['notification_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_batch_delete_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Delete multiple deployment requests  # noqa: E501

         ### Description Delete multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_delete_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_batch_get_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for the default version of a deployment. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_batch_get_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create a direct deployment request  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for the default version of a deployment. When using the 'requests' function of a deployment a list should be provided as input, see the example below.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a file field ``` {   \"input-field-1\": 5.0,   \"file-input-field\": \"ubiops-file://my-bucket/file-1.jpg\" } ```  A plain deployment request ``` \"example-plain-data\" ```  Multiple structured deployment requests using the 'requests' function of a deployment ``` [     {         \"input-field-1\": 5.0     },     {         \"input-field-1\": 10.0     } ] ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param object data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_delete_with_http_info(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Delete a deployment request  # noqa: E501

         ### Description Delete a deployment request for the default version of a deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_get_with_http_info(self, project_name, deployment_name, request_id, **kwargs):  # noqa: E501
        """Get a deployment request  # noqa: E501

         ### Description Get a request of the default version of a deployment. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed - `request_data`: A dictionary containing the data that was sent when the request was created - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful. - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value. - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed - `origin`: A dictionary containing the information on where the request originated from. It contains:    - the deployment (and version) names if the request is directly made to the deployment    - the pipeline (and version) names if the request is part of a pipeline request    - the request schedule name if the request is created via a request schedule  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"origin\": {     \"deployment\": \"deployment-1\",     \"deployment_version\": \"v1\"   } } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_get_with_http_info(project_name, deployment_name, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `deployment_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment requests  # noqa: E501

         ### Description List all requests for the default version of a deployment  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields: - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `status`: Status of the request - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished. - `time_created`: Server time that the request was made (current time) - `time_started`: Server time that the processing of the request was started - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'status', 'success', 'limit', 'offset', 'sort', 'pipeline', 'request_schedule', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline' in local_var_params
            and local_var_params['pipeline'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline'], bool):  # noqa: E501
                raise ApiValueError("Parameter `pipeline` must be a boolean when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_schedule' in local_var_params
            and local_var_params['request_schedule'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_schedule'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_schedule` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `deployment_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `deployment_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'pipeline' in local_var_params and local_var_params['pipeline'] is not None:  # noqa: E501
            query_params.append(('pipeline', local_var_params['pipeline']))  # noqa: E501
        if 'request_schedule' in local_var_params and local_var_params['request_schedule'] is not None:  # noqa: E501
            query_params.append(('request_schedule', local_var_params['request_schedule']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_update_with_http_info(self, project_name, deployment_name, request_id, data, **kwargs):  # noqa: E501
        """Update a deployment request  # noqa: E501

         ### Description Update a deployment request for the default version of a deployment. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_update_with_http_info(project_name, deployment_name, request_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestUpdateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_update`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_requests_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_request_update import DeploymentRequestUpdate

                local_var_params['data'] = DeploymentRequestUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/requests/{request_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_batch_delete_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple deployment version requests  # noqa: E501

         ### Description Delete multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_batch_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_version_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_batch_get_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple deployment version requests  # noqa: E501

         ### Description Retrieve multiple deployment requests for a deployment version. If one of the given deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   - `retries`: Number of times that the request has been retried  #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null,     \"retries\": 0   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null,     \"retries\": 1   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_batch_get_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[str] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestBatchDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_batch_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if not isinstance(local_var_params['data'], list):  # noqa: E501
                raise ApiValueError("Parameter `data` must be a list when calling `deployment_version_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestBatchDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create a direct deployment version request  # noqa: E501

         ### Description  Request a prediction from a deployment version. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). When using the 'requests' function of a deployment a list should be provided as input, see the example below.  ### Required Parameters The input for the request. In case of a structured deployment, this is a dictionary which contains the input fields of the deployment as keys. In case of a plain deployment, give a string or list of strings.  ### Optional Parameters These parameters should be given as query parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 (1 hour) and the default value is 300 (5 minutes).  #### Request Examples A structured deployment request ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  A structured deployment request with a file field ``` {   \"input-field-1\": 5.0,   \"file-input-field\": \"ubiops-file://my-bucket/file-1.jpg\" } ```  A plain deployment request ``` \"example-plain-data\" ```  Multiple structured deployment requests using the 'requests' function of a deployment version ``` [     {         \"input-field-1\": 5.0     },     {         \"input-field-1\": 10.0     } ] ```  ### Response Structure  Details of the created deployment request - `id`: Unique identifier for the deployment request - `deployment`: Name of the deployment the request was made to - `version`: Name of the version the request was made to - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"id\": \"85ae32a7-fe3a-4a55-be27-9db88ae68501\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"id\": \"ffce45da-1562-419a-89a0-0a0837e55392\",   \"deployment\": \"deployment-1\",   \"version\": \"v2\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'timeout' in local_var_params
            and local_var_params['timeout'] is not None):  # noqa: E501
            if not isinstance(local_var_params['timeout'], int):  # noqa: E501
                raise ApiValueError("Parameter `timeout` must be an integer when calling `deployment_version_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        if isinstance(body_params, str):
            header_params['Content-Type'] = self.api_client.select_header_content_type(['text/plain'])  # noqa: E501
        else:
            header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_delete_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete a deployment version request  # noqa: E501

         ### Description Delete a deployment request for a deployment version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_delete_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_version_requests_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_get_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get a deployment version request  # noqa: E501

         ### Description Get a request for a deployment version. With this method, the result of a request may be retrieved.  ### Optional Parameters The following parameters should be given as query parameters:  - `metadata_only`: A boolean value that indicates whether the response should include the request data and result. The default value is False.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'.  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  - `notification_group`: Name of a notification group to send notifications (e.g., emails) when the request is completed  - `retries`: Number of times that the request has been retried  #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"deployment\": \"deployment-1\",   \"version\": \"v1\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_started\": \"2020-03-28T20:00:41.276+00:00\",   \"time_completed\": \"2020-03-28T20:00:42.241+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\",   \"notification_group\": \"notification-group-1\",   \"retries\": 0 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_get_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param bool metadata_only:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_version_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'metadata_only' in local_var_params
            and local_var_params['metadata_only'] is not None):  # noqa: E501
            if not isinstance(local_var_params['metadata_only'], bool):  # noqa: E501
                raise ApiValueError("Parameter `metadata_only` must be a boolean when calling `deployment_version_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'metadata_only' in local_var_params and local_var_params['metadata_only'] is not None:  # noqa: E501
            query_params.append(('metadata_only', local_var_params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List deployment version requests  # noqa: E501

         ### Description List all requests for a deployment version  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed', 'completed', 'cancelled' or 'cancelled_pending'. - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting according to the creation date of the request, can be 'asc' or 'desc'. The default sorting is done in descending order. - `pipeline`: A boolean value that indicates whether the deployment request was part of a pipeline request - `request_schedule`: The name of a request schedule that created requests - `start_date`: Start date of the interval for which the requests are retrieved, looking at the creation date of the request - `end_date`: End date of the interval for which the requests are retrieved, looking at the creation date of the request - `search_id`: A string to search inside request ids. It will filter all request ids that contain this string  If no start or end date is provided, the most recent requests are returned.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `deployment`: Name of the deployment the request was made to  - `version`: Name of the version the request was made to  - `status`: Status of the request  - `success`: A boolean value that indicates whether the deployment request was successful. NULL if the request is not yet finished.  - `time_created`: Server time that the request was made (current time)  - `time_started`: Server time that the processing of the request was started  - `time_completed`: Server time that the processing of the request was completed  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"deployment\": \"deployment-1\",     \"version\": \"v1\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_started\": \"2020-03-28T20:00:41.276+00:00\",     \"time_completed\": \"2020-03-28T20:00:42.241+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param bool pipeline:
        :param str request_schedule:
        :param str start_date:
        :param str end_date:
        :param str search_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'status', 'success', 'limit', 'offset', 'sort', 'pipeline', 'request_schedule', 'start_date', 'end_date', 'search_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'status' in local_var_params
            and local_var_params['status'] is not None):  # noqa: E501
            if not isinstance(local_var_params['status'], str):  # noqa: E501
                raise ApiValueError("Parameter `status` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'success' in local_var_params
            and local_var_params['success'] is not None):  # noqa: E501
            if not isinstance(local_var_params['success'], bool):  # noqa: E501
                raise ApiValueError("Parameter `success` must be a boolean when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'sort' in local_var_params
            and local_var_params['sort'] is not None):  # noqa: E501
            if not isinstance(local_var_params['sort'], str):  # noqa: E501
                raise ApiValueError("Parameter `sort` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline' in local_var_params
            and local_var_params['pipeline'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline'], bool):  # noqa: E501
                raise ApiValueError("Parameter `pipeline` must be a boolean when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_schedule' in local_var_params
            and local_var_params['request_schedule'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_schedule'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_schedule` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'start_date' in local_var_params
            and local_var_params['start_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['start_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `start_date` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'end_date' in local_var_params
            and local_var_params['end_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['end_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `end_date` must be a string when calling `deployment_version_requests_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'search_id' in local_var_params
            and local_var_params['search_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['search_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `search_id` must be a string when calling `deployment_version_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'pipeline' in local_var_params and local_var_params['pipeline'] is not None:  # noqa: E501
            query_params.append(('pipeline', local_var_params['pipeline']))  # noqa: E501
        if 'request_schedule' in local_var_params and local_var_params['request_schedule'] is not None:  # noqa: E501
            query_params.append(('request_schedule', local_var_params['request_schedule']))  # noqa: E501
        if 'start_date' in local_var_params and local_var_params['start_date'] is not None:  # noqa: E501
            query_params.append(('start_date', local_var_params['start_date']))  # noqa: E501
        if 'end_date' in local_var_params and local_var_params['end_date'] is not None:  # noqa: E501
            query_params.append(('end_date', local_var_params['end_date']))  # noqa: E501
        if 'search_id' in local_var_params and local_var_params['search_id'] is not None:  # noqa: E501
            query_params.append(('search_id', local_var_params['search_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_version_requests_update_with_http_info(self, project_name, deployment_name, request_id, version, data, **kwargs):  # noqa: E501
        """Update a deployment version request  # noqa: E501

         ### Description Update a deployment request for a deployment version. It is possible to **cancel** a request by giving `cancelled` in the status field.  ### Required Parameters  - `status`: Status that the request will be updated to. It can only be `cancelled`.  #### Request Examples  ``` { \"status\": \"cancelled\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_version_requests_update_with_http_info(project_name, deployment_name, request_id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param DeploymentRequestUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestUpdateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_version_requests_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_version_requests_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'deployment_name' in local_var_params
            and local_var_params['deployment_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['deployment_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `deployment_name` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'request_id' in local_var_params
            and local_var_params['request_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['request_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `request_id` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `deployment_version_requests_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.deployment_request_update import DeploymentRequestUpdate

                local_var_params['data'] = DeploymentRequestUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/requests/{request_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
