# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class Blobs(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def blobs_create_with_http_info(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The uploaded blob file can be retrieved by passing the blob_id. The returned blob_id may be passed in a deployment or pipeline request as input.  ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create_with_http_info(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_create`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_ttl' in local_var_params
            and local_var_params['blob_ttl'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_ttl'], int):  # noqa: E501
                raise ApiValueError("Parameter `blob_ttl` must be an integer when calling `blobs_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_delete_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_delete`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_get_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_get`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `last_updated`: Time the blob was last updated  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",     \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 86400   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BlobList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'range', 'creation_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'range' in local_var_params
            and local_var_params['range'] is not None):  # noqa: E501
            if not isinstance(local_var_params['range'], int):  # noqa: E501
                raise ApiValueError("Parameter `range` must be an integer when calling `blobs_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'creation_date' in local_var_params
            and local_var_params['creation_date'] is not None):  # noqa: E501
            if not isinstance(local_var_params['creation_date'], str):  # noqa: E501
                raise ApiValueError("Parameter `creation_date` must be a string when calling `blobs_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'range' in local_var_params and local_var_params['range'] is not None:  # noqa: E501
            query_params.append(('range', local_var_params['range']))  # noqa: E501
        if 'creation_date' in local_var_params and local_var_params['creation_date'] is not None:  # noqa: E501
            query_params.append(('creation_date', local_var_params['creation_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlobList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_update_with_http_info(self, project_name, blob_id, file, **kwargs):  # noqa: E501
        """Update a blob  # noqa: E501

         ### Description  Overwrite a blob with given blob id. The uploaded blob file can be retrieved by passing the blob_id.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 86400 seconds (1 day).  ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `last_updated`: Time the blob was last updated - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {{   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"last_updated\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 86400 }} ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_update_with_http_info(project_name, blob_id, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_update`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_update`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_id' in local_var_params
            and local_var_params['blob_id'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_id'], str):  # noqa: E501
                raise ApiValueError("Parameter `blob_id` must be a string when calling `blobs_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'blob_ttl' in local_var_params
            and local_var_params['blob_ttl'] is not None):  # noqa: E501
            if not isinstance(local_var_params['blob_ttl'], int):  # noqa: E501
                raise ApiValueError("Parameter `blob_ttl` must be an integer when calling `blobs_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
