# Change Log

## Unreleased

### Features
- Added a `canRead` method to the core module (#512)

### Improvements
- Better release bioformats resources (#502)
- Better handling of tiff files with JPEG compression and RGB colorspace (#503)
- The openjpeg tile source can decode with parallelism (#511)
- Geospatial tile sources are preferred for geospatial files (#512)
- Support decoding JP2k compressed tiles in the tiff tile source (#514)
>>>>>>> For the tiff tile source, allow decoding jp2k tiles.

### Bug Fixes
- Harden updates of the item view after making a large image (#508)
- Tiles in an unexpected color mode weren't consistently adjusted (#510)

## Version 1.3.2

### Improvements
- Reduce caching associated images when the parent item changes (#491)
- Test with Python 3.9 (#493)
- Add a hideAnnotation function in the client (#490)
- Expose more resample options for region and histogram endpoints (#496)
- Improve OME tiff preferred level calculation for OME tiffs with subifds (#496)

### Changes
- Include the annotationType to the annotation conversion method in the client (#490)

### Notes
- This will be the last version to support Python 2.7 and 3.5.

## Version 1.3.1

### Improvements
- Include ETag support in some Girder rest requests to reduce data transfer (#488)

### Changes
- Don't let bioformats handle pngs (#487)

## Version 1.3.0

### Features
- Added bioformats tile source (#463)
- Handle OME Tiff files with sub-ifd images (#469)

### Improvements
- Expose more internal metadata (#479)
- Improve how Philips XML internal metadata is reported (#475)
- Show aperio version in internal metadata (#474)
- Add css classes to metadata on the item page (#472)
- The Girder web client exports the ItemViewWidget (#483)
- Read more associated images in openslide formats (#486)

### Bug Fixes
- Add a reference to updated time to avoid overcaching associated images (#477)
- Fix a typo in the settings page (#473)

## Version 1.2.0

### Features
- Added endpoints to remove old annotations (#432)
- Show auxiliary images and metadata on Girder item pages (#457)

### Improvements
- Migrate some database values on start to allow better annotation count reporting (#431)
- Speed up Girder item list annotation counts (#454)
- Read more OME Tiff files (#450)
- Handle subimages of different component depths (#449)
- When scaling, adjust reported mm_x/y (#441)

### Changes
- Standardize metadata for tile sources with multiple frames (#433)
- Unify code to check if a tile exists (#462)
- Switch to ElementTree, as cElementTree is deprecate (#461)
- Refactor how frame information is added to metadata (#460)
- Upgrade GeoJS to the latest version (#451)

### Bug Fixes
- Fix a threading issue with multiple styled tiles (#444)
- Guard against reading tiff tiles outside of the image (#458)
- Guard against a missing annotation value (#456(
- Fix handling Girder filenames with multiple periods in a row (#459)
- Work around a file descriptor issue in cheroot (#465)

## Version 1.1.0

### Features
- Added nd2 tile source (#419)

### Bug Fixes
- Fixed an issue where, if users or groups were deleted outside of normal methods, checking an annotation's access would delete its elements (#428)
- Fix an issue where retiling some tile sources could fail (#427)

### Improvements
- Testing fully with Python 3.8 (#429)

## Version 1.0.4

### Bug Fixes
- Fixed an issue where retiling some tile sources could fail (#427)

## Version 1.0.3

### Features
- Added gdal tile source (#418)
- Added a GET large_image/sources endpoint to list versions of all installed sources (#421)

### Bug Fixes
- Fixed an issue where changing the annotation history setting when Girder's settings' cache was enable wouldn't take effect until after a restart (#422)
- Fixed an issue when used as a Girder plugin and served with a proxy with a prefix path (#423)

### Improvements
- Better handling of imported file formats with adjacent files (#424)

## Version 1.0.2

### Features
- Add style options for all tile sources to remap channels and colors (#397)
- Better support for high bit-depth images (#397)

### Improvements
- Make it easier to load the annotation-enable web viewers (#402)
- Improved support for z-loops in OMETiff files (#397)
- Support using Glymur 0.9.1 (#411)

### Bug Fixes
- Fixed an issue where a Girder image conversion task could raise an error about a missing file (#409)

## Version 1.0.1

### Features
- Get annotations elements by centroid (#371)
- Added an annotation badge to the image list (#372)
- Added openjpeg tile source (#380)
- Handle different tiff orientations in the tiff tile source (#390)

### Improvements
- Increased the annotation page limit (#367)
- Increased the annotations response time limit (#389)
- Improved handling of tiff files with multiple tiled images (#373)
- Don't reset backbone models on saving existing annotations (#399)

### Changes
- Use girder/large_image_wheels (#384)
- Changed the mapnik tile source style defaults (#395)

### Bug Fixes
- Fixed the pyproj minimum version (#366)
- Guard against GDAL open errors (#375)
- Better handle annotations with zero elements (#398)
- Sorting tile layers could use a dictionary comparison (#396)

## Version 1.0.0

This is a substantial refactor from preliminary versions.  Now that setuptools_scm is used for versioning, all merges to master are automatically published to pypi as development versions.

Tile sources are now fully modular and are installed via pip.  File extensions and mime type are now used as part of the order that tile sources are checked, giving more control over which tile source is used by default.

The Girder plugin has been divided into the parts requiring annotations and the parts that are only necessary for large images.

Python 3.4 support was dropped.
