# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['denverapi',
 'denverapi.autopyb',
 'denverapi.autopyb.commands',
 'denverapi.clineutils',
 'denverapi.tools']

package_data = \
{'': ['*']}

install_requires = \
['ansiwrap>=0.8.4',
 'colorama>=0.4.4',
 'packaging>=20.9',
 'pip>=21',
 'playsound>=1.2.2',
 'requests>=2.25.1',
 'setuptools>=50']

extras_require = \
{'encryption': ['pycryptodomex>=3.10.1'], 'gui-tools': ['pygame>=2.0.1']}

entry_points = \
{'console_scripts': ['bdtpserver = denverapi.tools.bdtpserver:main',
                     'cryptify = denverapi.tools.cryptify:main [encryption]',
                     'denverdb = denverapi.database:cli',
                     'rmr = denverapi.clineutils.rmr:main',
                     'rmrdir = denverapi.clineutils.rmrdir:main']}

setup_kwargs = {
    'name': 'denver-api',
    'version': '3.0.1a0',
    'description': 'Denver API for python full-stack development',
    'long_description': "# denver\nDenver API for Python\n\nThis API is specifically designed for python developers who want to use\nadvanced utilities but without coding much. The API requires you to\nhave minimum Python 3.6.\n\n## Features\n\nThere are a lot of modules and libraries in denverapi and [here](https://xcodz-dot.github.io/denver) is a good list of them.\nIt will be worth checking it ;)\n\n## Installation\nThe package can be installed by\n```commandline\npip install denver-api\n```\nand upgraded by\n```commandline\npip install --upgrade denver-api\n```\n\n## Documentation\nDocumentation for denver can be found out at [this page](https://xcodz-dot.github.io/denver).\nAlso Documentation can be generated by the following command\n\n```commandline\npip install pdoc3\n```\nor if you already have then you can upgrade it by following command\n\n```commandline\npip install --upgrade pdoc3\n```\n\nAfter installation cd to root of this repository and run this command\n `pdoc denverapi -o docs --html --config show_source_code=False --template-dir pdoc`.\nThis will generate documentation and save it under the folder `docs`.\n\n## Community\nThis is a community driven project and accepts pull requests\nof any kind (read [CONTRIBUTING.md](https://github.com/xcodz-dot/denver/blob/master/.github/CONTRIBUTING.md)), \nThanks to all the contributors. Contributions are appreciated.\nIt will be really helpful if you raise a issue on finding bugs, documentation issues and typos.\n\nPlease do not use forums such as StackOverflow for asking questions related to this repository because\nthis repository is not popular enough to be heard on forums. Please use this repositories Q/A in GitHub Discussions.\n\n## Fixed Bugs\n### 3.0.0\nUntracked :(\n\n### 2.5.2, 2.5.3, 2.5.4\n* `denverapi.function_logger` fixed wrapped function not returning anything.\n* `denverapi.autopyb` fixes\n### 2.5.1\n* `denverapi.autopyb` minimum version fix\n### 2.4.1\n* `denverapi.bdtpfserv.post` function is now fixes to work without pausing and making troubles\n* `denverapi.tools.bdtpserver` tool fixed for the post argument\n* `denverapi.tools.cpic_editor` tool fixes which produced file system errors on linux\n### 2.1.0\n* `denverapi.pysetup.find_package_data` function is now fixed, so it can include files at root level of a module\n\n## What's New\n### 3.0.0\n* removed `pyelib` because I realised how useless it it.\n* added documentation for major part of codebase\n* added `denverapi.tools.cryptify` to encrypt files and decrypt files\n* added `encryption` to encrypt and decrypt data\n* removed `cpic` due to complexity and incompatibility with existing modules.\n* removed the documentation (that was a lot of work, now use the python documentation generated by pdoc3) \n* better cli for `denverapi.autopyb`\n* added support for Python 3.6\n* added new command line utilities.\n* added `entrypoints` to all tools as scripts.\n* added ability to `denverapi.autopyb.commands.pip` to be able to detect dependencies and do not run pip for no reason\n* added ability to `denverapi.tools.cpic_editor` to save cpic images to file.\n### 2.5.0\n* autopyb is added as a new auto building manager\n### 2.4.1\n* Thread control\n* Split up the pygame into a separate section (denverapi is sometimes required without pygame)\n### 2.2.0\n* new indev tools\n* renamed to a new project\n### 2.1.0\n* `denver.tools` package is now added as a standard interface to many modules (Many tools are still work in progress)\n",
    'author': 'xcodz-dot',
    'author_email': '71920621+xcodz-dot@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xcodz-dot/denver-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
