#coding=utf-8

ALPHABET = {
	'1' : ('   ##    ',
		   '  # #    ',
		   '    #    ',
		   '    #    ',
		   '  #####  '),

	'2' : ('   ####  ',
		   '  #    # ',
		   '      #  ',
		   '    #    ',
		   '  ###### '),

	'3' : ('   ####  ',
		   '  #    # ',
		   '     ##  ',
		   '  #    # ',
		   '   ####  '),

	'4' : ('     ##  ',
		   '   #  #  ',
		   '  #   #  ',
		   ' ####### ',
		   '      #  '),

	'5' : ('  #####  ',
		   '  #      ',
		   '  #####  ',
		   '       # ',
		   '   ####  '),

	'6' : ('   ####  ',
		   '  #      ',
		   '  #####  ',
		   '  #    # ',
		   '   ####  '),

	'7' : ('   ##### ',
		   '  #    # ',
		   '      #  ',
		   '     #   ',
		   '    #    '),

	'8' : ('   ####  ',
		   '  #    # ',
		   '   ####  ',
		   '  #    # ',
		   '   ####  '),

	'9' : ('   ####  ',
		   '  #    # ',
		   '   ##### ',
		   '       # ',
		   '   ####  '),

	'0' : ('   ####  ',
		   '  #    # ',
		   '  #    # ',
		   '  #    # ',
		   '   ####  '),

	'a' : ('    #    ',
		   '   # #   ',
		   '  #####  ',
		   ' #     # ',
		   '#       #'),

	'b' : ('######## ',
		   '#       #',
		   '######## ',
		   '#       #',
		   '######## '),

	'c' : (' ####### ',
		   '#        ',
		   '#        ',
		   '#        ',
		   ' ####### '),

	'd' : ('######## ',
		   '#       #',
		   '#       #',
		   '#       #',
		   '######## '),

	'e' : (' ####### ',
		   ' #       ',
		   ' ####### ',
		   ' #       ',
		   ' ####### '),

	'f' : (' ####### ',
		   ' #       ',
		   ' ####### ',
		   ' #       ',
		   ' #       '),

	'g' : (' ####### ',
		   '#        ',
		   '#     ###',
		   '#       #',
		   ' ####### '),

	'h' : (' #     # ',
		   ' #     # ',
		   ' ####### ',
		   ' #     # ',
		   ' #     # '),

	'i' : (' ####### ',
		   '    #    ',
		   '    #    ',
		   '    #    ',
		   ' ####### '),

	'j' : (' ####### ',
		   '    #    ',
		   '    #    ',
		   '#   #    ',
		   ' ###     '),

	'k' : (' #    #  ',
		   ' #  #    ',
		   ' # # #   ',
		   ' #    #  ',
		   ' #     # '),

	'l' : (' #       ',
		   ' #       ',
		   ' #       ',
		   ' #       ',
		   ' ####### '),

	'm' : (' #     # ',
		   ' # # # # ',
		   '#   #   #',
		   '#       #',
		   '#       #'),

	'n' : (' ##    # ',
		   ' # #   # ',
		   ' #  #  # ',
		   ' #   # # ',
		   ' #    ## '),

	'o' : ('  #####  ',
		   '#       #',
		   '#       #',
		   '#       #',
		   '  #####  '),

	'p' : ('  #####  ',
		   ' #     # ',
		   ' ######  ',
		   ' #       ',
		   ' #       '),

	'q' : ('  #####  ',
		   '#       #',
		   '#     # #',
		   '#      # ',
		   '  ##### #'),

	'r' : (' #####   ',
		   ' #    #  ',
		   ' # # #   ',
		   ' #    #  ',
		   ' #     # '),

	's' : ('  ###### ',
		   ' #       ',
		   '  #####  ',
		   '       # ',
		   ' ######  '),

	't' : (' ####### ',
		   '    #    ',
		   '    #    ',
		   '    #    ',
		   '    #    '),

	'u' : ('#       #',
		   '#       #',
		   '#       #',
		   ' #      #',
		   '  ##### #'),

	'v' : ('#       #',
		   '#       #',
		   ' #     # ',
		   '  #   #  ',
		   '   ###   '),

	'w' : ('#       #',
		   '#       #',
		   '#   #   #',
		   ' # # # # ',
		   ' #     # '),

	'x' : (' #     # ',
		   '  #   #  ',
		   '    #    ',
		   '  #   #  ',
		   ' #     # '),

	'y' : (' #     # ',
		   '  #   #  ',
		   '    #    ',
		   '    #    ',
		   '  ##     '),

	'z' : (' ####### ',
		   '      #  ',
		   '    #    ',
		   '  #      ',
		   ' ####### '),

	' ' : ('         ',
		   '         ',
		   '         ',
		   '         ',
		   '         '),

	'!' : ('    #    ',
		   '    #    ',
		   '    #    ',
		   '         ',
		   '    #    '),

	'.' : ('         ',
		   '         ',
		   '         ',
		   '         ',
		   '  #      '),

	',' : ('         ',
		   '         ',
		   '         ',
		   '  #      ',
		   ' #       '),

	':' : ('         ',
		   ' #       ',
		   '         ',
		   ' #       ',
		   '         '),

	';' : ('         ',
		   ' #       ',
		   '         ',
		   '  #      ',
		   ' #       '),

	'?' : ('   ##    ',
		   '      #  ',
		   '    #    ',
		   '         ',
		   '    #    '),

	'/' : ('      #  ',
		   '     #   ',
		   '    #    ',
		   '   #     ',
		   '  #      '),

	'\\' : ('  #      ',
		   '   #     ',
		   '    #    ',
		   '     #   ',
		   '      #  '),

	'@' : ('   #  #  ',
		   ' #  ##   ',
		   '#  # #   ',
		   ' #     # ',
		   '   ####  '),

	'<' : ('       # ',
		   '    #    ',
		   ' #       ',
		   '    #    ',
		   '       # '),

	'>' : (' #       ',
		   '    #    ',
		   '       # ',
		   '    #    ',
		   ' #       '),

	'|' : ('    #    ',
		   '    #    ',
		   '    #    ',
		   '    #    ',
		   '    #    '),

	'\'' : ('    #    ',
		   '   #     ',
		   '         ',
		   '         ',
		   '         '),

	'"' : ('   # #   ',
		   '  # #    ',
		   '         ',
		   '         ',
		   '         '),

	'£' : ('   ###   ',
		   '  #      ',
		   ' ####    ',
		   '  #      ',
		   ' ######  '),

	'$' : ('   ####  ',
		   ' #  #    ',
		   '   ###   ',
		   '    #  # ',
		   '  ####   '),

	'#' : ('  #   #  ',
		   ' ####### ',
		   '  #   #  ',
		   ' ####### ',
		   '  #   #  '),

	'^' : ('    #    ',
		   '  #   #  ',
		   '#       #',
		   '         ',
		   '         '),

	'&' : ('  ###    ',
		   ' #   #   ',
		   '  ###  # ',
		   ' #   ##  ',
		   '  ###  ##'),

	'*' : ('  # # #  ',
		   ' ## # ## ',
		   '  # # #  ',
		   '         ',
		   '         '),

	'(' : ('     #   ',
		   '    #    ',
		   '    #    ',
		   '    #    ',
		   '     #   '),

	')' : ('   #     ',
		   '    #    ',
		   '    #    ',
		   '    #    ',
		   '   #     '),

	'[' : ('   ###   ',
		   '   #     ',
		   '   #     ',
		   '   #     ',
		   '   ###   '),

	']' : ('   ###   ',
		   '     #   ',
		   '     #   ',
		   '     #   ',
		   '   ###   '),

	'{' : ('     #   ',
		   '    #    ',
		   '     #   ',
		   '    #    ',
		   '     #   '),

	'}' : ('    #    ',
		   '     #   ',
		   '    #    ',
		   '     #   ',
		   '    #    '),

	'-' : ('         ',
		   '         ',
		   '  #####  ',
		   '         ',
		   '         '),

	'_' : ('         ',
		   '         ',
		   '         ',
		   '         ',
		   '#########'),

	'=' : ('         ',
		   '  #####  ',
		   '         ',
		   '  #####  ',
		   '         '),

	'+' : ('         ',
		   '    #    ',
		   '  #####  ',
		   '    #    ',
		   '         '),

	'~' : ('         ',
		   '   #     ',
		   ' #  #  # ',
		   '      #  ',
		   '         '),

	'`' : ('   #     ',
		   '     #   ',
		   '         ',
		   '         ',
		   '         '),

	'%' : (' #     # ',
		   '# #  #   ',
		   ' #  #  # ',
		   '   #  # #',
		   ' #     # '),

	'¬' : ('         ',
		   '         ',
		   ' ####### ',
		   '       # ',
		   '         ')
}

def word(word):
	word = word.lower()
	out = ''

	for line in range(5):
		linestr = ''
		for letter in word:
			linestr += ALPHABET[letter][line] + '  '
		out += linestr + '\n'

	return out

if __name__ == '__main__':
	print(word('Letters!'))