/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import protostream.com.squareup.protoparser.AutoValue_ProtoParser_OptionKindAndValue;
import protostream.com.squareup.protoparser.DataType;
import protostream.com.squareup.protoparser.EnumConstantElement;
import protostream.com.squareup.protoparser.EnumElement;
import protostream.com.squareup.protoparser.ExtendElement;
import protostream.com.squareup.protoparser.ExtensionsElement;
import protostream.com.squareup.protoparser.FieldElement;
import protostream.com.squareup.protoparser.MessageElement;
import protostream.com.squareup.protoparser.OneOfElement;
import protostream.com.squareup.protoparser.OptionElement;
import protostream.com.squareup.protoparser.ProtoFile;
import protostream.com.squareup.protoparser.RpcElement;
import protostream.com.squareup.protoparser.ServiceElement;
import protostream.com.squareup.protoparser.TypeElement;

public final class ProtoParser {
    private final String filePath;
    private final char[] data;
    private final ProtoFile.Builder fileBuilder;
    private int pos;
    private int line;
    private int lineStart;
    private String packageName;
    private String prefix = "";

    public static ProtoFile parseUtf8(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            ProtoFile protoFile = ProtoParser.parseUtf8(file.getPath(), is);
            return protoFile;
        }
    }

    public static ProtoFile parseUtf8(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ProtoFile protoFile = ProtoParser.parse(path.toString(), reader);
            return protoFile;
        }
    }

    public static ProtoFile parseUtf8(String name, InputStream is) throws IOException {
        return ProtoParser.parse(name, new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static ProtoFile parse(String name, Reader reader) throws IOException {
        int count;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[1024];
        while ((count = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, count);
        }
        return new ProtoParser(name, writer.toCharArray()).readProtoFile();
    }

    public static ProtoFile parse(String name, String data) {
        return new ProtoParser(name, data.toCharArray()).readProtoFile();
    }

    ProtoParser(String filePath, char[] data) {
        this.filePath = filePath;
        this.data = data;
        this.fileBuilder = ProtoFile.builder(filePath);
    }

    ProtoFile readProtoFile() {
        while (true) {
            String documentation = this.readDocumentation();
            if (this.pos == this.data.length) {
                return this.fileBuilder.build();
            }
            Object declaration = this.readDeclaration(documentation, Context.FILE);
            if (declaration instanceof TypeElement) {
                this.fileBuilder.addType((TypeElement)declaration);
                continue;
            }
            if (declaration instanceof ServiceElement) {
                this.fileBuilder.addService((ServiceElement)declaration);
                continue;
            }
            if (declaration instanceof OptionElement) {
                this.fileBuilder.addOption((OptionElement)declaration);
                continue;
            }
            if (!(declaration instanceof ExtendElement)) continue;
            this.fileBuilder.addExtendDeclaration((ExtendElement)declaration);
        }
    }

    private Object readDeclaration(String documentation, Context context) {
        if (this.peekChar() == ';') {
            ++this.pos;
            return null;
        }
        String label = this.readWord();
        if (label.equals("package")) {
            if (!context.permitsPackage()) {
                throw this.unexpected("'package' in " + (Object)((Object)context));
            }
            if (this.packageName != null) {
                throw this.unexpected("too many package names");
            }
            this.packageName = this.readName();
            this.fileBuilder.packageName(this.packageName);
            this.prefix = this.packageName + ".";
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("import")) {
            if (!context.permitsImport()) {
                throw this.unexpected("'import' in " + (Object)((Object)context));
            }
            String importString = this.readString();
            if ("public".equals(importString)) {
                this.fileBuilder.addPublicDependency(this.readString());
            } else {
                this.fileBuilder.addDependency(importString);
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("syntax")) {
            String syntax;
            if (!context.permitsSyntax()) {
                throw this.unexpected("'syntax' in " + (Object)((Object)context));
            }
            if (this.readChar() != '=') {
                throw this.unexpected("expected '='");
            }
            switch (syntax = this.readQuotedString()) {
                case "proto2": {
                    this.fileBuilder.syntax(ProtoFile.Syntax.PROTO_2);
                    break;
                }
                case "proto3": {
                    this.fileBuilder.syntax(ProtoFile.Syntax.PROTO_3);
                    break;
                }
                default: {
                    throw this.unexpected("'syntax' must be 'proto2' or 'proto3'. Found: " + syntax);
                }
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("option")) {
            OptionElement result = this.readOption('=');
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return result;
        }
        if (label.equals("message")) {
            return this.readMessage(documentation);
        }
        if (label.equals("enum")) {
            return this.readEnumElement(documentation);
        }
        if (label.equals("service")) {
            return this.readService(documentation);
        }
        if (label.equals("extend")) {
            return this.readExtend(documentation);
        }
        if (label.equals("rpc")) {
            if (!context.permitsRpc()) {
                throw this.unexpected("'rpc' in " + (Object)((Object)context));
            }
            return this.readRpc(documentation);
        }
        if (label.equals("required") || label.equals("optional") || label.equals("repeated")) {
            if (!context.permitsField()) {
                throw this.unexpected("fields must be nested");
            }
            FieldElement.Label labelEnum = FieldElement.Label.valueOf(label.toUpperCase(Locale.US));
            return this.readField(documentation, labelEnum);
        }
        if (label.equals("oneof")) {
            if (!context.permitsOneOf()) {
                throw this.unexpected("'oneof' must be nested in message");
            }
            return this.readOneOf(documentation);
        }
        if (label.equals("extensions")) {
            if (!context.permitsExtensions()) {
                throw this.unexpected("'extensions' must be nested");
            }
            return this.readExtensions(documentation);
        }
        if (context == Context.ENUM) {
            EnumConstantElement.Builder builder;
            block41: {
                if (this.readChar() != '=') {
                    throw this.unexpected("expected '='");
                }
                builder = EnumConstantElement.builder().name(label).tag(this.readInt());
                if (this.peekChar() == '[') {
                    char c;
                    this.readChar();
                    do {
                        builder.addOption(this.readOption('='));
                        c = this.readChar();
                        if (c == ']') break block41;
                    } while (c == ',');
                    throw this.unexpected("Expected ',' or ']");
                }
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            documentation = this.tryAppendTrailingDocumentation(documentation);
            return builder.documentation(documentation).build();
        }
        throw this.unexpected("unexpected label: " + label);
    }

    private MessageElement readMessage(String documentation) {
        String name = this.readName();
        MessageElement.Builder builder = MessageElement.builder().name(name).qualifiedName(this.prefix + name).documentation(documentation);
        String previousPrefix = this.prefix;
        this.prefix = this.prefix + name + ".";
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.MESSAGE);
            if (declared instanceof FieldElement) {
                builder.addField((FieldElement)declared);
                continue;
            }
            if (declared instanceof OneOfElement) {
                builder.addOneOf((OneOfElement)declared);
                continue;
            }
            if (declared instanceof TypeElement) {
                builder.addType((TypeElement)declared);
                continue;
            }
            if (declared instanceof ExtensionsElement) {
                builder.addExtensions((ExtensionsElement)declared);
                continue;
            }
            if (declared instanceof OptionElement) {
                builder.addOption((OptionElement)declared);
                continue;
            }
            if (!(declared instanceof ExtendElement)) continue;
            this.fileBuilder.addExtendDeclaration((ExtendElement)declared);
        }
        this.prefix = previousPrefix;
        return builder.build();
    }

    private ExtendElement readExtend(String documentation) {
        String name;
        String qualifiedName = name = this.readName();
        if (!name.contains(".") && this.packageName != null) {
            qualifiedName = this.packageName + "." + name;
        }
        ExtendElement.Builder builder = ExtendElement.builder().name(name).qualifiedName(qualifiedName).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.EXTEND);
            if (!(declared instanceof FieldElement)) continue;
            builder.addField((FieldElement)declared);
        }
        return builder.build();
    }

    private ServiceElement readService(String documentation) {
        String name = this.readName();
        ServiceElement.Builder builder = ServiceElement.builder().name(name).qualifiedName(this.prefix + name).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String rpcDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(rpcDocumentation, Context.SERVICE);
            if (declared instanceof RpcElement) {
                builder.addRpc((RpcElement)declared);
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            builder.addOption((OptionElement)declared);
        }
        return builder.build();
    }

    private EnumElement readEnumElement(String documentation) {
        String name = this.readName();
        EnumElement.Builder builder = EnumElement.builder().name(name).qualifiedName(this.prefix + name).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String valueDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(valueDocumentation, Context.ENUM);
            if (declared instanceof EnumConstantElement) {
                builder.addConstant((EnumConstantElement)declared);
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            builder.addOption((OptionElement)declared);
        }
        return builder.build();
    }

    private FieldElement readField(String documentation, FieldElement.Label label) {
        DataType type = this.readDataType();
        String name = this.readName();
        if (this.readChar() != '=') {
            throw this.unexpected("expected '='");
        }
        int tag = this.readInt();
        FieldElement.Builder builder = FieldElement.builder().label(label).type(type).name(name).tag(tag);
        if (this.peekChar() == '[') {
            ++this.pos;
            while (true) {
                builder.addOption(this.readOption('='));
                char c = this.peekChar();
                if (c == ']') {
                    ++this.pos;
                    break;
                }
                if (c != ',') continue;
                ++this.pos;
            }
        }
        if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
        documentation = this.tryAppendTrailingDocumentation(documentation);
        return builder.documentation(documentation).build();
    }

    private OneOfElement readOneOf(String documentation) {
        OneOfElement.Builder builder = OneOfElement.builder().name(this.readName()).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            builder.addField(this.readField(nestedDocumentation, FieldElement.Label.ONE_OF));
        }
        return builder.build();
    }

    private ExtensionsElement readExtensions(String documentation) {
        int start;
        int end = start = this.readInt();
        if (this.peekChar() != ';') {
            if (!"to".equals(this.readWord())) {
                throw this.unexpected("expected ';' or 'to'");
            }
            String s2 = this.readWord();
            end = s2.equals("max") ? 0x1FFFFFFF : Integer.parseInt(s2);
        }
        if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
        return ExtensionsElement.create(start, end, documentation);
    }

    private OptionElement readOption(char keyValueSeparator) {
        boolean isExtension = this.peekChar() == '[';
        boolean isParenthesized = this.peekChar() == '(';
        String name = this.readName();
        if (isExtension) {
            name = "[" + name + "]";
        }
        String subName = null;
        char c = this.readChar();
        if (c == '.') {
            subName = this.readName();
            c = this.readChar();
        }
        if (c != keyValueSeparator) {
            throw this.unexpected("expected '" + keyValueSeparator + "' in option");
        }
        OptionKindAndValue kindAndValue = this.readKindAndValue();
        OptionElement.Kind kind = kindAndValue.kind();
        Object value = kindAndValue.value();
        if (subName != null) {
            value = OptionElement.create(subName, kind, value);
            kind = OptionElement.Kind.OPTION;
        }
        return OptionElement.create(name, kind, value, isParenthesized);
    }

    private OptionKindAndValue readKindAndValue() {
        String word;
        char peeked = this.peekChar();
        switch (peeked) {
            case '{': {
                return OptionKindAndValue.of(OptionElement.Kind.MAP, this.readMap('{', '}', ':'));
            }
            case '[': {
                return OptionKindAndValue.of(OptionElement.Kind.LIST, this.readList());
            }
            case '\"': {
                return OptionKindAndValue.of(OptionElement.Kind.STRING, this.readString());
            }
        }
        if (Character.isDigit(peeked) || peeked == '-') {
            return OptionKindAndValue.of(OptionElement.Kind.NUMBER, this.readWord());
        }
        switch (word = this.readWord()) {
            case "true": {
                return OptionKindAndValue.of(OptionElement.Kind.BOOLEAN, "true");
            }
            case "false": {
                return OptionKindAndValue.of(OptionElement.Kind.BOOLEAN, "false");
            }
        }
        return OptionKindAndValue.of(OptionElement.Kind.ENUM, word);
    }

    private Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.readChar() != openBrace) {
            throw new AssertionError();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (true) {
            if (this.peekChar() == closeBrace) {
                ++this.pos;
                return result;
            }
            OptionElement option = this.readOption(keyValueSeparator);
            String name = option.name();
            Object value = option.value();
            if (value instanceof OptionElement) {
                LinkedHashMap<String, Object> nested = (LinkedHashMap<String, Object>)result.get(name);
                if (nested == null) {
                    nested = new LinkedHashMap<String, Object>();
                    result.put(name, nested);
                }
                OptionElement valueOption = (OptionElement)value;
                nested.put(valueOption.name(), valueOption.value());
            } else {
                Object previous = result.get(name);
                if (previous == null) {
                    result.put(name, value);
                } else if (previous instanceof List) {
                    this.addToList((List)previous, value);
                } else {
                    ArrayList<Object> newList = new ArrayList<Object>();
                    newList.add(previous);
                    this.addToList(newList, value);
                    result.put(name, newList);
                }
            }
            if (this.peekChar() != ',') continue;
            ++this.pos;
        }
    }

    private void addToList(List<Object> list, Object value) {
        if (value instanceof List) {
            list.addAll((List)value);
        } else {
            list.add(value);
        }
    }

    private List<Object> readList() {
        if (this.readChar() != '[') {
            throw new AssertionError();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (true) {
            if (this.peekChar() == ']') {
                ++this.pos;
                return result;
            }
            result.add(this.readKindAndValue().value());
            char c = this.peekChar();
            if (c == ',') {
                ++this.pos;
                continue;
            }
            if (c != ']') break;
        }
        throw this.unexpected("expected ',' or ']'");
    }

    private RpcElement readRpc(String documentation) {
        RpcElement.Builder builder;
        block11: {
            builder = RpcElement.builder().name(this.readName()).documentation(documentation);
            if (this.readChar() != '(') {
                throw this.unexpected("expected '('");
            }
            DataType requestType = this.readDataType();
            if (!(requestType instanceof DataType.NamedType)) {
                throw this.unexpected("expected message but was " + requestType);
            }
            builder.requestType((DataType.NamedType)requestType);
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
            if (!this.readWord().equals("returns")) {
                throw this.unexpected("expected 'returns'");
            }
            if (this.readChar() != '(') {
                throw this.unexpected("expected '('");
            }
            DataType responseType = this.readDataType();
            if (!(responseType instanceof DataType.NamedType)) {
                throw this.unexpected("expected message but was " + responseType);
            }
            builder.responseType((DataType.NamedType)responseType);
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
            if (this.peekChar() == '{') {
                ++this.pos;
                while (true) {
                    String rpcDocumentation = this.readDocumentation();
                    if (this.peekChar() == '}') {
                        ++this.pos;
                        break block11;
                    }
                    Object declared = this.readDeclaration(rpcDocumentation, Context.RPC);
                    if (!(declared instanceof OptionElement)) continue;
                    builder.addOption((OptionElement)declared);
                }
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
        }
        return builder.build();
    }

    private char readChar() {
        char result = this.peekChar();
        ++this.pos;
        return result;
    }

    private char peekChar() {
        this.skipWhitespace(true);
        if (this.pos == this.data.length) {
            throw this.unexpected("unexpected end of file");
        }
        return this.data[this.pos];
    }

    private String readString() {
        this.skipWhitespace(true);
        return this.peekChar() == '\"' ? this.readQuotedString() : this.readWord();
    }

    private String readQuotedString() {
        if (this.readChar() != '\"') {
            throw new AssertionError();
        }
        StringBuilder result = new StringBuilder();
        while (this.pos < this.data.length) {
            int c;
            if ((c = this.data[this.pos++]) == 34) {
                return result.toString();
            }
            if (c == 92) {
                if (this.pos == this.data.length) {
                    throw this.unexpected("unexpected end of file");
                }
                c = this.data[this.pos++];
                switch (c) {
                    case 97: {
                        c = 7;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 118: {
                        c = 11;
                        break;
                    }
                    case 88: 
                    case 120: {
                        c = this.readNumericEscape(16, 2);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        --this.pos;
                        c = this.readNumericEscape(8, 3);
                        break;
                    }
                }
            }
            result.append((char)c);
            if (c != 10) continue;
            this.newline();
        }
        throw this.unexpected("unterminated string");
    }

    private char readNumericEscape(int radix, int len) {
        int digit;
        int value = -1;
        int endPos = Math.min(this.pos + len, this.data.length);
        while (this.pos < endPos && (digit = this.hexDigit(this.data[this.pos])) != -1 && digit < radix) {
            value = value < 0 ? digit : value * radix + digit;
            ++this.pos;
        }
        if (value < 0) {
            throw this.unexpected("expected a digit after \\x or \\X");
        }
        return (char)value;
    }

    private int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private String readName() {
        String optionName;
        char c = this.peekChar();
        if (c == '(') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
        } else if (c == '[') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ']') {
                throw this.unexpected("expected ']'");
            }
        } else {
            optionName = this.readWord();
        }
        return optionName;
    }

    private DataType readDataType() {
        String name;
        switch (name = this.readWord()) {
            case "map": {
                if (this.readChar() != '<') {
                    throw this.unexpected("expected '<'");
                }
                DataType keyType = this.readDataType();
                if (this.readChar() != ',') {
                    throw this.unexpected("expected ','");
                }
                DataType valueType = this.readDataType();
                if (this.readChar() != '>') {
                    throw this.unexpected("expected '>'");
                }
                return DataType.MapType.create(keyType, valueType);
            }
            case "any": {
                return DataType.ScalarType.ANY;
            }
            case "bool": {
                return DataType.ScalarType.BOOL;
            }
            case "bytes": {
                return DataType.ScalarType.BYTES;
            }
            case "double": {
                return DataType.ScalarType.DOUBLE;
            }
            case "float": {
                return DataType.ScalarType.FLOAT;
            }
            case "fixed32": {
                return DataType.ScalarType.FIXED32;
            }
            case "fixed64": {
                return DataType.ScalarType.FIXED64;
            }
            case "int32": {
                return DataType.ScalarType.INT32;
            }
            case "int64": {
                return DataType.ScalarType.INT64;
            }
            case "sfixed32": {
                return DataType.ScalarType.SFIXED32;
            }
            case "sfixed64": {
                return DataType.ScalarType.SFIXED64;
            }
            case "sint32": {
                return DataType.ScalarType.SINT32;
            }
            case "sint64": {
                return DataType.ScalarType.SINT64;
            }
            case "string": {
                return DataType.ScalarType.STRING;
            }
            case "uint32": {
                return DataType.ScalarType.UINT32;
            }
            case "uint64": {
                return DataType.ScalarType.UINT64;
            }
        }
        return DataType.NamedType.create(name);
    }

    private String readWord() {
        char c;
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length && ((c = this.data[this.pos]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.')) {
            ++this.pos;
        }
        if (start == this.pos) {
            throw this.unexpected("expected a word");
        }
        return new String(this.data, start, this.pos - start);
    }

    private int readInt() {
        String tag = this.readWord();
        try {
            int radix = 10;
            if (tag.startsWith("0x") || tag.startsWith("0X")) {
                tag = tag.substring("0x".length());
                radix = 16;
            }
            return Integer.valueOf(tag, radix);
        }
        catch (Exception e) {
            throw this.unexpected("expected an integer but was " + tag);
        }
    }

    private String readDocumentation() {
        String result = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                return result != null ? result : "";
            }
            String comment = this.readComment();
            result = result == null ? comment : result + "\n" + comment;
        }
    }

    private String readComment() {
        int commentType;
        if (this.pos == this.data.length || this.data[this.pos] != '/') {
            throw new AssertionError();
        }
        ++this.pos;
        int n = commentType = this.pos < this.data.length ? this.data[this.pos++] : -1;
        if (commentType == 42) {
            StringBuilder result = new StringBuilder();
            boolean startOfLine = true;
            while (this.pos + 1 < this.data.length) {
                char c = this.data[this.pos];
                if (c == '*' && this.data[this.pos + 1] == '/') {
                    this.pos += 2;
                    return result.toString().trim();
                }
                if (c == '\n') {
                    result.append('\n');
                    this.newline();
                    startOfLine = true;
                } else if (!startOfLine) {
                    result.append(c);
                } else if (c == '*') {
                    if (this.data[this.pos + 1] == ' ') {
                        ++this.pos;
                    }
                    startOfLine = false;
                } else if (!Character.isWhitespace(c)) {
                    result.append(c);
                    startOfLine = false;
                }
                ++this.pos;
            }
            throw this.unexpected("unterminated comment");
        }
        if (commentType == 47) {
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            int start = this.pos;
            while (this.pos < this.data.length) {
                char c;
                if ((c = this.data[this.pos++]) != '\n') continue;
                this.newline();
                break;
            }
            return new String(this.data, start, this.pos - 1 - start);
        }
        throw this.unexpected("unexpected '/'");
    }

    private String tryAppendTrailingDocumentation(String documentation) {
        int end;
        int start;
        block16: {
            char c;
            while (this.pos < this.data.length) {
                char c2 = this.data[this.pos];
                if (c2 == ' ' || c2 == '\t') {
                    ++this.pos;
                    continue;
                }
                if (c2 == '/') {
                    ++this.pos;
                    break;
                }
                return documentation;
            }
            if (this.pos == this.data.length || this.data[this.pos] != '/' && this.data[this.pos] != '*') {
                --this.pos;
                throw this.unexpected("expected '//' or '/*'");
            }
            boolean isStar = this.data[this.pos] == '*';
            ++this.pos;
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            start = this.pos;
            if (isStar) {
                while (true) {
                    if (this.pos == this.data.length || this.data[this.pos] == '\n') {
                        throw this.unexpected("trailing comment must be closed on the same line");
                    }
                    if (this.data[this.pos] == '*' && this.pos + 1 < this.data.length && this.data[this.pos + 1] == '/') {
                        end = this.pos - 1;
                        this.pos += 2;
                        break;
                    }
                    ++this.pos;
                }
                while (this.pos < this.data.length) {
                    if ((c = this.data[this.pos++]) == '\n') {
                        this.newline();
                        break;
                    }
                    if (c == ' ' || c == '\t') continue;
                    throw this.unexpected("no syntax may follow trailing comment");
                }
            } else {
                do {
                    if (this.pos != this.data.length) continue;
                    end = this.pos - 1;
                    break block16;
                } while ((c = this.data[this.pos++]) != '\n');
                this.newline();
                end = this.pos - 2;
            }
        }
        while (end > start && (this.data[end] == ' ' || this.data[end] == '\t')) {
            --end;
        }
        if (end == start) {
            return documentation;
        }
        String trailingDocumentation = new String(this.data, start, end - start + 1);
        if (documentation.isEmpty()) {
            return trailingDocumentation;
        }
        return documentation + '\n' + trailingDocumentation;
    }

    private void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                ++this.pos;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (!skipComments || c != '/') break;
            this.readComment();
        }
    }

    private void newline() {
        ++this.line;
        this.lineStart = this.pos;
    }

    private int column() {
        return this.pos - this.lineStart + 1;
    }

    private int line() {
        return this.line + 1;
    }

    private RuntimeException unexpected(String message) {
        throw new IllegalStateException(String.format("Syntax error in %s at %d:%d: %s", this.filePath, this.line(), this.column(), message));
    }

    static enum Context {
        FILE,
        MESSAGE,
        ENUM,
        RPC,
        EXTEND,
        SERVICE;


        public boolean permitsPackage() {
            return this == FILE;
        }

        public boolean permitsSyntax() {
            return this == FILE;
        }

        public boolean permitsImport() {
            return this == FILE;
        }

        public boolean permitsField() {
            return this == MESSAGE || this == EXTEND;
        }

        public boolean permitsExtensions() {
            return this != FILE;
        }

        public boolean permitsRpc() {
            return this == SERVICE;
        }

        public boolean permitsOneOf() {
            return this == MESSAGE;
        }
    }

    static abstract class OptionKindAndValue {
        OptionKindAndValue() {
        }

        static OptionKindAndValue of(OptionElement.Kind kind, Object value) {
            return new AutoValue_ProtoParser_OptionKindAndValue(kind, value);
        }

        abstract OptionElement.Kind kind();

        abstract Object value();
    }
}

