/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.ContextSupport;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionContext;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenHandler;
import org.xmlpull.v1.builder.xpath.jaxen.NamespaceContext;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.SimpleNamespaceContext;
import org.xmlpull.v1.builder.xpath.jaxen.SimpleVariableContext;
import org.xmlpull.v1.builder.xpath.jaxen.VariableContext;
import org.xmlpull.v1.builder.xpath.jaxen.XPath;
import org.xmlpull.v1.builder.xpath.jaxen.XPathFunctionContext;
import org.xmlpull.v1.builder.xpath.jaxen.XPathSyntaxException;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.XPathExpr;
import org.xmlpull.v1.builder.xpath.jaxen.function.BooleanFunction;
import org.xmlpull.v1.builder.xpath.jaxen.function.NumberFunction;
import org.xmlpull.v1.builder.xpath.jaxen.function.StringFunction;
import org.xmlpull.v1.builder.xpath.saxpath.SAXPathException;
import org.xmlpull.v1.builder.xpath.saxpath.XPathReader;
import org.xmlpull.v1.builder.xpath.saxpath.helpers.XPathReaderFactory;

public class BaseXPath
implements XPath,
Serializable {
    private XPathExpr xpath;
    private ContextSupport support;
    private Navigator navigator;

    protected BaseXPath(String xpathExpr) throws JaxenException {
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            JaxenHandler handler = new JaxenHandler();
            reader.setXPathHandler(handler);
            reader.parse(xpathExpr);
            this.xpath = handler.getXPathExpr();
        }
        catch (org.xmlpull.v1.builder.xpath.saxpath.XPathSyntaxException e) {
            throw new XPathSyntaxException(e.getXPath(), e.getPosition(), e.getMessage());
        }
        catch (SAXPathException e) {
            throw new JaxenException(e);
        }
    }

    public BaseXPath(String xpathExpr, Navigator navigator) throws JaxenException {
        this(xpathExpr);
        this.navigator = navigator;
    }

    public Object evaluate(Object node) throws JaxenException {
        Object first;
        List answer = this.selectNodes(node);
        if (answer != null && answer.size() == 1 && ((first = answer.get(0)) instanceof String || first instanceof Number || first instanceof Boolean)) {
            return first;
        }
        return answer;
    }

    public List selectNodes(Object node) throws JaxenException {
        Context context = this.getContext(node);
        return this.selectNodesForContext(context);
    }

    public Object selectSingleNode(Object node) throws JaxenException {
        List results = this.selectNodes(node);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public String valueOf(Object node) throws JaxenException {
        return this.stringValueOf(node);
    }

    public String stringValueOf(Object node) throws JaxenException {
        Context context = this.getContext(node);
        Object result = this.selectSingleNodeForContext(context);
        if (result == null) {
            return "";
        }
        return StringFunction.evaluate(result, context.getNavigator());
    }

    public boolean booleanValueOf(Object node) throws JaxenException {
        Context context = this.getContext(node);
        List result = this.selectNodesForContext(context);
        if (result == null) {
            return false;
        }
        return BooleanFunction.evaluate(result, context.getNavigator());
    }

    public Number numberValueOf(Object node) throws JaxenException {
        Context context = this.getContext(node);
        Object result = this.selectSingleNodeForContext(context);
        if (result == null) {
            return null;
        }
        return NumberFunction.evaluate(result, context.getNavigator());
    }

    public void addNamespace(String prefix, String uri) throws JaxenException {
        NamespaceContext nsContext = this.getNamespaceContext();
        if (nsContext instanceof SimpleNamespaceContext) {
            ((SimpleNamespaceContext)nsContext).addNamespace(prefix, uri);
            return;
        }
        throw new JaxenException("Operation not permitted while using a custom namespace context.");
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.getContextSupport().setNamespaceContext(namespaceContext);
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.getContextSupport().setFunctionContext(functionContext);
    }

    public void setVariableContext(VariableContext variableContext) {
        this.getContextSupport().setVariableContext(variableContext);
    }

    public NamespaceContext getNamespaceContext() {
        NamespaceContext answer = this.getContextSupport().getNamespaceContext();
        if (answer == null) {
            answer = this.createNamespaceContext();
            this.getContextSupport().setNamespaceContext(answer);
        }
        return answer;
    }

    public FunctionContext getFunctionContext() {
        FunctionContext answer = this.getContextSupport().getFunctionContext();
        if (answer == null) {
            answer = this.createFunctionContext();
            this.getContextSupport().setFunctionContext(answer);
        }
        return answer;
    }

    public VariableContext getVariableContext() {
        VariableContext answer = this.getContextSupport().getVariableContext();
        if (answer == null) {
            answer = this.createVariableContext();
            this.getContextSupport().setVariableContext(answer);
        }
        return answer;
    }

    public Expr getRootExpr() {
        return this.xpath.getRootExpr();
    }

    public String toString() {
        return this.xpath.getText();
    }

    public String debug() {
        return this.xpath.toString();
    }

    protected Context getContext(Object node) {
        if (node instanceof Context) {
            return (Context)node;
        }
        Context fullContext = new Context(this.getContextSupport());
        if (node instanceof List) {
            fullContext.setNodeSet((List)node);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(node);
            fullContext.setNodeSet(list);
        }
        return fullContext;
    }

    protected ContextSupport getContextSupport() {
        if (this.support == null) {
            this.support = new ContextSupport(this.createNamespaceContext(), this.createFunctionContext(), this.createVariableContext(), this.getNavigator());
        }
        return this.support;
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    protected NamespaceContext createNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    protected VariableContext createVariableContext() {
        return new SimpleVariableContext();
    }

    protected List selectNodesForContext(Context context) throws JaxenException {
        return this.xpath.asList(context);
    }

    protected Object selectSingleNodeForContext(Context context) throws JaxenException {
        List results = this.selectNodesForContext(context);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }
}

