/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class StatsCollector {
    private final EnumMap<Counter, AtomicInteger> counters = new EnumMap(Counter.class);
    private final EnumMap<Duration, AtomicLong> durations = new EnumMap(Duration.class);
    private volatile boolean statsEnabled;

    public StatsCollector() {
        for (Counter counter : Counter.values()) {
            this.counters.put(counter, new AtomicInteger(0));
        }
        for (Enum enum_ : Duration.values()) {
            this.durations.put((Duration)enum_, new AtomicLong(0L));
        }
    }

    private boolean shouldCollectStats(long ... values2) {
        if (!this.statsEnabled) {
            return false;
        }
        for (long value : values2) {
            if (value >= 0L) continue;
            return false;
        }
        return true;
    }

    private static double convertNanosToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    public void clearStats() {
        for (AtomicInteger counter : this.counters.values()) {
            counter.set(0);
        }
        for (AtomicLong duration : this.durations.values()) {
            duration.set(0L);
        }
    }

    public long now() {
        return this.statsEnabled ? System.nanoTime() : -1L;
    }

    public void addProposeSequenceNumberDuration(long durationValue, boolean isLastProposeMessage) {
        if (!this.shouldCollectStats(durationValue)) {
            return;
        }
        Counter counter = isLastProposeMessage ? Counter.LAST_PROPOSE_MESSAGE_RECEIVED : Counter.PROPOSE_MESSAGE_RECEIVED;
        Duration duration = isLastProposeMessage ? Duration.LAST_PROPOSE_MESSAGE : Duration.PROPOSE_MESSAGE;
        this.counters.get((Object)counter).incrementAndGet();
        this.durations.get((Object)duration).addAndGet(durationValue);
    }

    public void addFinalSequenceNumberDuration(long duration) {
        if (!this.shouldCollectStats(duration)) {
            return;
        }
        this.counters.get((Object)Counter.FINAL_MESSAGE_RECEIVED).incrementAndGet();
        this.durations.get((Object)Duration.FINAL_MESSAGE).addAndGet(duration);
    }

    public void addDataMessageDuration(long duration) {
        if (!this.shouldCollectStats(duration)) {
            return;
        }
        this.counters.get((Object)Counter.DATA_MESSAGE_RECEIVED).incrementAndGet();
        this.durations.get((Object)Duration.DATA_MESSAGE).addAndGet(duration);
    }

    public void addAnycastSentDuration(long duration, int numberOfUnicasts) {
        if (!this.shouldCollectStats(duration)) {
            return;
        }
        this.counters.get((Object)Counter.UNICAST_MESSAGE_SENT).addAndGet(numberOfUnicasts);
        this.counters.get((Object)Counter.ANYCAST_MESSAGE_SENT).incrementAndGet();
        this.durations.get((Object)Duration.ANYCAST_MESSAGE_SENT).addAndGet(duration);
    }

    public void incrementMessageDeliver() {
        if (!this.shouldCollectStats(new long[0])) {
            return;
        }
        this.counters.get((Object)Counter.ANYCAST_MESSAGE_DELIVERED).incrementAndGet();
    }

    public double getAvgDataMessageReceivedDuration() {
        int count = this.counters.get((Object)Counter.DATA_MESSAGE_RECEIVED).get();
        if (count > 0) {
            long dur = this.durations.get((Object)Duration.DATA_MESSAGE).get();
            return StatsCollector.convertNanosToMillis(dur) / (double)count;
        }
        return 0.0;
    }

    public double getAvgAnycastSentDuration() {
        int count = this.counters.get((Object)Counter.ANYCAST_MESSAGE_SENT).get();
        if (count > 0) {
            long dur = this.durations.get((Object)Duration.ANYCAST_MESSAGE_SENT).get();
            return StatsCollector.convertNanosToMillis(dur) / (double)count;
        }
        return 0.0;
    }

    public double getAvgProposeMesageReceivedDuration() {
        int count = this.counters.get((Object)Counter.PROPOSE_MESSAGE_RECEIVED).get();
        if (count > 0) {
            long dur = this.durations.get((Object)Duration.PROPOSE_MESSAGE).get();
            return StatsCollector.convertNanosToMillis(dur) / (double)count;
        }
        return 0.0;
    }

    public double getAvgLastProposeMessageReceivedDuration() {
        int count = this.counters.get((Object)Counter.LAST_PROPOSE_MESSAGE_RECEIVED).get();
        if (count > 0) {
            long dur = this.durations.get((Object)Duration.LAST_PROPOSE_MESSAGE).get();
            return StatsCollector.convertNanosToMillis(dur) / (double)count;
        }
        return 0.0;
    }

    public double getAvgFinalMessageReceivedDuration() {
        int count = this.counters.get((Object)Counter.FINAL_MESSAGE_RECEIVED).get();
        if (count > 0) {
            long dur = this.durations.get((Object)Duration.FINAL_MESSAGE).get();
            return StatsCollector.convertNanosToMillis(dur) / (double)count;
        }
        return 0.0;
    }

    public int getNumberOfAnycastMessagesSent() {
        return this.counters.get((Object)Counter.ANYCAST_MESSAGE_SENT).get();
    }

    public int getAnycastDelivered() {
        return this.counters.get((Object)Counter.ANYCAST_MESSAGE_DELIVERED).get();
    }

    public int getNumberOfProposeMessagesReceived() {
        return this.counters.get((Object)Counter.PROPOSE_MESSAGE_RECEIVED).get() + this.counters.get((Object)Counter.LAST_PROPOSE_MESSAGE_RECEIVED).get();
    }

    public int getNumberOfProposeMessagesSent() {
        return this.counters.get((Object)Counter.DATA_MESSAGE_RECEIVED).get();
    }

    public int getNumberOfFinalAnycastsSent() {
        return this.counters.get((Object)Counter.LAST_PROPOSE_MESSAGE_RECEIVED).get();
    }

    public int getNumberOfFinalMessagesDelivered() {
        return this.counters.get((Object)Counter.FINAL_MESSAGE_RECEIVED).get();
    }

    public double getAvgNumberOfUnicastSentPerAnycast() {
        int multicast = this.counters.get((Object)Counter.ANYCAST_MESSAGE_SENT).get();
        if (multicast > 0) {
            int unicast = this.counters.get((Object)Counter.UNICAST_MESSAGE_SENT).get();
            return (double)unicast * 1.0 / (double)multicast;
        }
        return 0.0;
    }

    private static enum Duration {
        PROPOSE_MESSAGE,
        LAST_PROPOSE_MESSAGE,
        FINAL_MESSAGE,
        DATA_MESSAGE,
        ANYCAST_MESSAGE_SENT;

    }

    private static enum Counter {
        PROPOSE_MESSAGE_RECEIVED,
        LAST_PROPOSE_MESSAGE_RECEIVED,
        FINAL_MESSAGE_RECEIVED,
        DATA_MESSAGE_RECEIVED,
        ANYCAST_MESSAGE_SENT,
        ANYCAST_MESSAGE_DELIVERED,
        UNICAST_MESSAGE_SENT;

    }
}

