/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Locking;
import org.jgroups.util.Buffer;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Owner;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Runner;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class CENTRAL_LOCK2
extends Locking {
    @Property(description="By default, a lock owner is address:thread-id. If false, we only use the node's address. See https://issues.jboss.org/browse/JGRP-1886 for details")
    protected boolean use_thread_id_for_lock_owner = true;
    @Property(description="Max time (im ms) to wait for lock info responses from members in a lock reconciliation phase")
    protected long lock_reconciliation_timeout = 10000L;
    protected Address coord;
    protected final ResponseCollector<Locking.LockInfoResponse> lock_info_responses = new ResponseCollector();
    protected final BlockingQueue<Locking.Request> req_queue = new LinkedBlockingQueue<Locking.Request>();
    protected final Runner req_handler = new Runner(new DefaultThreadFactory("lock-handler", true, true), "lock-handler", this::processQueue, this.req_queue::clear);

    @ManagedAttribute
    public boolean isCoord() {
        return Objects.equals(this.local_addr, this.coord);
    }

    @ManagedAttribute
    public String getCoordinator() {
        return this.coord != null ? this.coord.toString() : "n/a";
    }

    @ManagedAttribute
    public boolean isRequestHandlerRunning() {
        return this.req_handler.isRunning();
    }

    @ManagedAttribute
    public int requestQueueSize() {
        return this.req_queue.size();
    }

    @Override
    public void stop() {
        super.stop();
        this.req_handler.stop();
    }

    @Override
    public void handleView(View v) {
        Address old_coord = this.view != null ? this.view.getCoord() : null;
        super.handleView(v);
        if (v.size() > 0) {
            this.coord = v.getCoord();
            this.log.debug("%s: coord=%s, is_coord=%b", this.local_addr, this.coord, this.isCoord());
        }
        if (Objects.equals(this.local_addr, this.coord)) {
            if (v instanceof MergeView || !Objects.equals(this.local_addr, old_coord)) {
                this.runReconciliation();
                this.req_handler.start();
            }
        } else if (Objects.equals(this.local_addr, old_coord)) {
            this.log.debug("%s: not coordinator anymore; stopping the request handler", this.local_addr);
            this.req_handler.stop();
            this.server_locks.clear();
        }
    }

    @Override
    protected void requestReceived(Locking.Request req) {
        if (req == null) {
            return;
        }
        switch (req.type) {
            case GRANT_LOCK: 
            case RELEASE_LOCK: 
            case CREATE_LOCK: 
            case DELETE_LOCK: 
            case COND_SIG: 
            case COND_SIG_ALL: 
            case LOCK_AWAIT: 
            case DELETE_LOCK_AWAIT: 
            case CREATE_AWAITER: 
            case DELETE_AWAITER: {
                this.req_queue.add(req);
                break;
            }
            case LOCK_GRANTED: 
            case RELEASE_LOCK_OK: 
            case LOCK_DENIED: 
            case SIG_RET: 
            case LOCK_INFO_REQ: 
            case LOCK_INFO_RSP: 
            case LOCK_REVOKED: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s <-- %s: %s", this.local_addr, req.sender, req);
                }
                this.handleRequest(req);
                break;
            }
            default: {
                this.log.error("%s: request of type %s not known", new Object[]{this.local_addr, req.type});
            }
        }
    }

    protected void processQueue() {
        Locking.Request req = null;
        try {
            req = this.req_queue.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (req != null && this.log.isTraceEnabled()) {
                this.log.trace("%s <-- %s: %s", this.local_addr, req.sender, req);
            }
            this.handleRequest(req);
        }
        catch (Throwable t) {
            this.log.error("%s: failed handling request %s: %s", this.local_addr, req, t);
        }
    }

    @Override
    protected void handleLockInfoRequest(Address requester) {
        if (requester != null && !Objects.equals(this.coord, requester)) {
            this.log.trace("%s: changed coord from %s to %s as a result of getting a LOCK_INFO_REQ", this.local_addr, this.coord, requester);
            this.coord = requester;
        }
        Locking.LockInfoResponse response = this.createLockInfoResponse();
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s --> %s LOCK-INFO-RSP:\n%s", this.local_addr, requester, response.printDetails());
        }
        this.send(requester, new Locking.Request(Locking.Type.LOCK_INFO_RSP).infoRsp(response));
    }

    @Override
    protected void handleLockInfoResponse(Address sender, Locking.Request rsp) {
        this.lock_info_responses.add(sender, rsp.info_rsp);
    }

    @Override
    protected void handleLockRevoked(Locking.Request rsp) {
        this.notifyLockRevoked(rsp.lock_name, rsp.owner);
    }

    @ManagedOperation(description="Runs the reconciliation protocol to fetch information about owned locks and pending lock/unlock requests from each member to establish the server lock table. Only run by a coordinator.")
    public void runReconciliation() {
        if (!this.isCoord()) {
            this.log.warn("%s: reconciliation protocol is not run as I'm not the coordinator (%s is)", this.local_addr, this.getCoordinator());
            return;
        }
        Locking.Request lock_info_req = new Locking.Request(Locking.Type.LOCK_INFO_REQ);
        Address[] mbrs = this.view.getMembersRaw();
        this.log.debug("%s: running reconciliation protocol on %d members", this.local_addr, mbrs != null ? mbrs.length : 0);
        this.lock_info_responses.reset(mbrs);
        this.lock_info_responses.add(this.local_addr, this.createLockInfoResponse());
        this.log.trace("%s --> ALL: %s", this.local_addr, lock_info_req);
        this.sendLockInfoRequestTo(Util.streamableToBuffer(lock_info_req), mbrs, this.local_addr);
        if (!this.lock_info_responses.waitForAllResponses(this.lock_reconciliation_timeout)) {
            List<Address> missing = this.lock_info_responses.getMissing();
            this.log.warn("%s: failed getting lock information from all members, missing responses: %d (from %s)", this.local_addr, missing.size(), missing);
        }
        Collection<Locking.LockInfoResponse> responses = this.lock_info_responses.getResults().values();
        responses.stream().filter(rsp -> rsp != null && rsp.existing_locks != null).map(rsp -> rsp.existing_locks).flatMap(Collection::stream).forEach(t -> {
            Owner owner;
            Locking.ServerLock srv_lock;
            String lock_name = (String)t.getVal1();
            Locking.ServerLock ret = this.server_locks.putIfAbsent(lock_name, srv_lock = new Locking.ServerLock(this, lock_name, owner = (Owner)t.getVal2()));
            if (ret != null) {
                if (!Objects.equals(owner, ret.owner)) {
                    this.log.warn("%s: lock %s requested by %s is already present: %s", this.local_addr, lock_name, owner, ret);
                    this.send(owner.getAddress(), new Locking.Request(Locking.Type.LOCK_REVOKED, lock_name, ret.owner, 0L));
                }
            } else {
                this.notifyLockCreated(lock_name);
                this.log.trace("%s: added lock %s", this.local_addr, lock_name);
            }
        });
        responses.stream().filter(rsp -> rsp != null && rsp.pending_requests != null && !rsp.pending_requests.isEmpty()).map(rsp -> rsp.pending_requests).flatMap(Collection::stream).forEach(req -> {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: processing request %s", this.local_addr, req);
                }
                this.handleRequest((Locking.Request)req);
            }
            catch (Throwable t) {
                this.log.error("%s: failed handling request %s: %s", this.local_addr, req, t);
            }
        });
    }

    protected void sendLockInfoRequestTo(Buffer buf, Address[] mbrs, Address exclude) {
        Stream.of(mbrs).filter(m3 -> m3 != null && !Objects.equals(m3, exclude)).forEach(dest -> {
            Message msg = new Message((Address)dest, buf).putHeader(this.id, new Locking.LockingHeader());
            if (this.bypass_bundling) {
                msg.setFlag(Message.Flag.DONT_BUNDLE);
            }
            try {
                this.down_prot.down(msg);
            }
            catch (Throwable t) {
                this.log.error("%s: failed sending LOCK_INFO_REQ to %s: %s", this.local_addr, dest, t);
            }
        });
    }

    @Override
    protected Owner getOwner() {
        return this.use_thread_id_for_lock_owner ? super.getOwner() : new Owner(this.local_addr, -1L);
    }

    @Override
    protected void sendGrantLockRequest(String lock_name, int lock_id, Owner owner, long timeout2, boolean is_trylock) {
        Address dest = this.coord;
        if (dest == null) {
            throw new IllegalStateException("No coordinator available, cannot send GRANT-LOCK request");
        }
        this.sendRequest(dest, Locking.Type.GRANT_LOCK, lock_name, lock_id, owner, timeout2, is_trylock);
    }

    @Override
    protected void sendReleaseLockRequest(String lock_name, int lock_id, Owner owner) {
        Address dest = this.coord;
        if (dest == null) {
            throw new IllegalStateException("No coordinator available, cannot send RELEASE-LOCK request");
        }
        this.sendRequest(dest, Locking.Type.RELEASE_LOCK, lock_name, lock_id, owner, 0L, false);
    }

    @Override
    protected void sendAwaitConditionRequest(String lock_name, Owner owner) {
        this.sendRequest(this.coord, Locking.Type.LOCK_AWAIT, lock_name, owner, 0L, false);
    }

    @Override
    protected void sendSignalConditionRequest(String lock_name, boolean all) {
        this.sendRequest(this.coord, all ? Locking.Type.COND_SIG_ALL : Locking.Type.COND_SIG, lock_name, null, 0L, false);
    }

    @Override
    protected void sendDeleteAwaitConditionRequest(String lock_name, Owner owner) {
        this.sendRequest(this.coord, Locking.Type.DELETE_LOCK_AWAIT, lock_name, owner, 0L, false);
    }

    protected Locking.LockInfoResponse createLockInfoResponse() {
        Locking.LockInfoResponse rsp = new Locking.LockInfoResponse();
        List<Tuple<String, Owner>> locks = this.client_lock_table.getLockInfo();
        for (Tuple<String, Owner> t : locks) {
            rsp.add(t);
        }
        List<Locking.Request> pending_reqs = this.client_lock_table.getPendingRequests(this.local_addr);
        if (pending_reqs != null && !pending_reqs.isEmpty()) {
            rsp.pending_requests = pending_reqs;
        }
        return rsp;
    }
}

