/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos.wb;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.io.OutputStream;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.demos.wb.ApplFrame;
import org.jgroups.demos.wb.GraphPanel;
import org.jgroups.demos.wb.MessageDialog;
import org.jgroups.demos.wb.Node;
import org.jgroups.demos.wb.UserInfoDialog;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

public class Whiteboard
extends Applet
implements MembershipListener,
ActionListener,
ComponentListener,
FocusListener {
    public RpcDispatcher disp;
    JChannel channel;
    GraphPanel panel;
    private Button leave_button;
    private Label mbr_label;
    private final Font default_font = new Font("Helvetica", 0, 12);
    private String props = null;
    public static final String groupname = "WbGrp";
    private boolean application = false;
    Log log = LogFactory.getLog(this.getClass());

    public void getState(OutputStream ostream) throws Exception {
        this.panel.getState(ostream);
    }

    public void setState(InputStream istream) throws Exception {
        this.panel.setState(istream);
    }

    private static String getInfo() {
        StringBuilder ret = new StringBuilder();
        ret.append(" (" + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + ')');
        return ret.toString();
    }

    private Frame findParent() {
        for (Container retval = this.getParent(); retval != null; retval = retval.getParent()) {
            if (!(retval instanceof Frame)) continue;
            return (Frame)retval;
        }
        return null;
    }

    public Whiteboard() {
    }

    public Whiteboard(String properties) {
        this.application = true;
        this.props = properties;
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.panel = new GraphPanel(this);
        this.panel.setBackground(Color.white);
        this.add("Center", this.panel);
        Panel p = new Panel();
        this.leave_button = new Button("Exit");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.mbr_label = new Label("1 mbr(s)");
        this.mbr_label.setFont(this.default_font);
        p.add("South", this.leave_button);
        p.add("South", this.mbr_label);
        this.add("South", p);
        if (!this.application) {
            this.props = this.getParameter("properties");
        }
        if (this.props == null) {
            this.props = "udp.xml";
        }
        System.out.println("properties are " + this.props);
        try {
            this.channel = new JChannel(this.props);
            this.disp = new RpcDispatcher(this.channel, this).setMembershipListener(this);
            this.channel.connect(groupname);
            this.channel.getState(null, 0L);
        }
        catch (Exception e) {
            this.log.error("Whiteboard.init(): " + e);
        }
        this.panel.my_addr = this.channel.getAddress();
        UserInfoDialog dlg = new UserInfoDialog(this.findParent());
        String n = dlg.getUserName();
        String info = Whiteboard.getInfo();
        this.panel.start(n + info);
        this.addComponentListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void destroy() {
        if (this.disp != null) {
            try {
                MethodCall call = new MethodCall("removeNode", new Object[]{this.panel.my_addr}, new Class[]{Object.class});
                this.disp.callRemoteMethods(null, call, new RequestOptions(ResponseMode.GET_ALL, 5000L));
            }
            catch (Exception e) {
                this.log.error(e.toString());
            }
            this.channel.close();
            this.disp = null;
            if (this.panel != null) {
                this.panel.stop();
                this.panel = null;
            }
        }
    }

    @Override
    public void repaint() {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Exit".equals(command)) {
            try {
                this.setVisible(false);
                this.destroy();
                if (this.application) {
                    ((Frame)this.getParent()).dispose();
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                this.log.error(ex.toString());
            }
        } else {
            System.out.println("Unknown action");
        }
    }

    @Override
    public void viewAccepted(View v) {
        if (v != null && this.mbr_label != null) {
            this.mbr_label.setText(v.size() + " mbr(s)");
        }
        if (this.panel != null) {
            this.panel.adjustNodes(v.getMembers());
        }
    }

    @Override
    public void suspect(Address obj) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    public void moveNode(Node n) {
        this.panel.moveNode(n);
    }

    public void addNode(String lbl, Address addr, int xloc, int yloc) {
        this.panel.addNode(lbl, addr, xloc, yloc);
    }

    public void removeNode(Object addr) {
        this.panel.removeNode(addr);
    }

    public void displayMessage(String sender, String msg) {
        new MessageDialog(this.findParent(), sender, msg);
        this.panel.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public static void main(String[] args2) {
        String props = null;
        for (int i = 0; i < args2.length; ++i) {
            if (!"-props".equals(args2[i])) {
                Whiteboard.help();
                return;
            }
            props = args2[++i];
        }
        Whiteboard wb = new Whiteboard(props);
        new ApplFrame("Whiteboard Application", wb);
    }

    static void help() {
        System.out.println("Whiteboard [-help] [-props <props>]");
    }
}

