/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class TcpConnection
extends Connection {
    protected final Socket sock;
    protected final ReentrantLock send_lock = new ReentrantLock();
    protected DataOutputStream out;
    protected DataInputStream in;
    protected volatile Receiver receiver;
    protected final TcpBaseServer server;
    protected final AtomicInteger writers = new AtomicInteger(0);
    protected boolean connected;

    public TcpConnection(Address peer_addr, TcpBaseServer server) throws Exception {
        this.server = server;
        if (peer_addr == null) {
            throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
        }
        this.peer_addr = peer_addr;
        this.sock = server.socketFactory().createSocket("jgroups.tcp.sock");
        this.setSocketParameters(this.sock);
        this.last_access = this.getTimestamp();
    }

    public TcpConnection(Socket s2, TcpServer server) throws Exception {
        this.sock = s2;
        this.server = server;
        if (s2 == null) {
            throw new IllegalArgumentException("Invalid parameter s=" + s2);
        }
        this.setSocketParameters(s2);
        this.out = new DataOutputStream(this.createBufferedOutputStream(s2.getOutputStream()));
        this.in = new DataInputStream(this.createBufferedInputStream(s2.getInputStream()));
        this.connected = this.sock.isConnected();
        this.peer_addr = server.usePeerConnections() ? this.readPeerAddress(s2) : new IpAddress((InetSocketAddress)s2.getRemoteSocketAddress());
        this.last_access = this.getTimestamp();
    }

    @Override
    public Address localAddress() {
        InetSocketAddress local_addr = this.sock != null ? (InetSocketAddress)this.sock.getLocalSocketAddress() : null;
        return local_addr != null ? new IpAddress(local_addr) : null;
    }

    @Override
    public Address peerAddress() {
        return this.peer_addr;
    }

    protected long getTimestamp() {
        return this.server.timeService() != null ? this.server.timeService().timestamp() : System.nanoTime();
    }

    protected String getSockAddress() {
        StringBuilder sb = new StringBuilder();
        if (this.sock != null) {
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
        }
        return sb.toString();
    }

    protected void updateLastAccessed() {
        if (this.server.connExpireTime() > 0L) {
            this.last_access = this.getTimestamp();
        }
    }

    @Override
    public void connect(Address dest) throws Exception {
        this.connect(dest, this.server.usePeerConnections());
    }

    protected void connect(Address dest, boolean send_local_addr) throws Exception {
        InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
        try {
            if (!this.server.defer_client_binding) {
                this.sock.bind(new InetSocketAddress(this.server.client_bind_addr, this.server.client_bind_port));
            }
            Util.connect(this.sock, destAddr, this.server.sock_conn_timeout);
            if (this.sock.getLocalSocketAddress() != null && this.sock.getLocalSocketAddress().equals(destAddr)) {
                throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
            }
            this.out = new DataOutputStream(this.createBufferedOutputStream(this.sock.getOutputStream()));
            this.in = new DataInputStream(this.createBufferedInputStream(this.sock.getInputStream()));
            this.connected = this.sock.isConnected();
            if (send_local_addr) {
                this.sendLocalAddress(this.server.localAddress());
            } else if (this.sock instanceof SSLSocket) {
                ((SSLSocket)this.sock).startHandshake();
            }
        }
        catch (Exception t) {
            Util.close((Closeable)this.sock);
            this.connected = false;
            throw t;
        }
    }

    @Override
    public void start() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        this.receiver = new Receiver(this.server.factory).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        if (this.out == null) {
            return;
        }
        this.writers.incrementAndGet();
        this.send_lock.lock();
        try {
            this.doSend(data, offset, length);
            this.updateLastAccessed();
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.writers.decrementAndGet() == 0) {
                this.flush();
            }
            this.send_lock.unlock();
        }
    }

    @Override
    public void send(ByteBuffer buf) throws Exception {
        if (buf == null) {
            return;
        }
        int offset = buf.hasArray() ? buf.arrayOffset() + buf.position() : buf.position();
        int len = buf.remaining();
        if (!buf.isDirect()) {
            this.send(buf.array(), offset, len);
        } else {
            byte[] tmp = new byte[len];
            buf.get(tmp, 0, len);
            this.send(tmp, 0, len);
        }
    }

    protected void doSend(byte[] data, int offset, int length) throws Exception {
        this.out.writeInt(length);
        this.out.write(data, offset, length);
    }

    protected void flush() {
        try {
            this.out.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected BufferedOutputStream createBufferedOutputStream(OutputStream out) {
        int size = this.server instanceof TcpServer ? ((TcpServer)this.server).getBufferedOutputStreamSize() : 0;
        return size == 0 ? new BufferedOutputStream(out) : new BufferedOutputStream(out, size);
    }

    protected BufferedInputStream createBufferedInputStream(InputStream in) {
        int size = this.server instanceof TcpServer ? ((TcpServer)this.server).getBufferedInputStreamSize() : 0;
        return size == 0 ? new BufferedInputStream(in) : new BufferedInputStream(in, size);
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        try {
            if (this.server.send_buf_size > 0) {
                client_sock.setSendBufferSize(this.server.send_buf_size);
            }
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting send buffer to %d bytes: %s", this.server.local_addr, this.server.send_buf_size, ex);
        }
        try {
            if (this.server.recv_buf_size > 0) {
                client_sock.setReceiveBufferSize(this.server.recv_buf_size);
            }
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting receive buffer to %d bytes: %s", this.server.local_addr, this.server.recv_buf_size, ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.server.tcp_nodelay);
        try {
            if (this.server.linger > 0) {
                client_sock.setSoLinger(true, this.server.linger);
            } else {
                client_sock.setSoLinger(false, -1);
            }
        }
        catch (Throwable t) {
            this.server.log().warn("%s: failed setting SO_LINGER option: %s", this.server.localAddress(), t);
        }
    }

    protected void sendLocalAddress(Address local_addr) throws Exception {
        try {
            this.out.write(cookie, 0, cookie.length);
            this.out.writeShort(Version.version);
            this.out.writeShort(local_addr.serializedSize());
            local_addr.writeTo(this.out);
            this.out.flush();
            this.updateLastAccessed();
        }
        catch (Exception ex) {
            this.server.socket_factory.close(this.sock);
            this.connected = false;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address readPeerAddress(Socket client_sock) throws Exception {
        int timeout2 = client_sock.getSoTimeout();
        client_sock.setSoTimeout(this.server.peerAddressReadTimeout());
        try {
            byte[] input_cookie = new byte[cookie.length];
            this.in.readFully(input_cookie, 0, input_cookie.length);
            if (!Arrays.equals(cookie, input_cookie)) {
                throw new SocketException(String.format("%s: BaseServer.TcpConnection.readPeerAddress(): cookie sent by %s:%d does not match own cookie; terminating connection", this.server.localAddress(), client_sock.getInetAddress(), client_sock.getPort()));
            }
            short version = this.in.readShort();
            if (!Version.isBinaryCompatible(version)) {
                throw new IOException("packet from " + client_sock.getInetAddress() + ":" + client_sock.getPort() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
            }
            this.in.readShort();
            IpAddress client_peer_addr = new IpAddress();
            client_peer_addr.readFrom(this.in);
            this.updateLastAccessed();
            IpAddress ipAddress = client_peer_addr;
            return ipAddress;
        }
        finally {
            client_sock.setSoTimeout(timeout2);
        }
    }

    public String toString() {
        Socket tmp_sock = this.sock;
        if (tmp_sock == null) {
            return "<null socket>";
        }
        InetAddress local = tmp_sock.getLocalAddress();
        InetAddress remote = tmp_sock.getInetAddress();
        String local_str = local != null ? Util.shortName(local) : "<null>";
        String remote_str = remote != null ? Util.shortName(remote) : "<null>";
        return String.format("%s:%s --> %s:%s (%d secs old) [%s] [recv_buf=%d]", local_str, tmp_sock.getLocalPort(), remote_str, tmp_sock.getPort(), TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS), this.status(), this.receiver != null ? this.receiver.bufferSize() : 0);
    }

    @Override
    public String status() {
        if (this.sock == null) {
            return "n/a";
        }
        if (this.isConnected()) {
            return "connected";
        }
        if (this.isOpen()) {
            return "open";
        }
        return "closed";
    }

    @Override
    public boolean isExpired(long now) {
        return this.server.conn_expire_time > 0L && now - this.last_access >= this.server.conn_expire_time;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isConnectionPending() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.sock != null && !this.sock.isClosed();
    }

    @Override
    public void close() throws IOException {
        Util.close((Closeable)this.sock);
        this.send_lock.lock();
        try {
            if (this.receiver != null) {
                this.receiver.stop();
                this.receiver = null;
            }
            Util.close(this.out, this.in);
        }
        finally {
            this.connected = false;
            this.send_lock.unlock();
        }
    }

    protected class Receiver
    implements Runnable {
        protected final Thread recv;
        protected volatile boolean receiving = true;
        protected byte[] buffer;

        public Receiver(ThreadFactory f) {
            this.recv = f.newThread(this, "Connection.Receiver [" + TcpConnection.this.getSockAddress() + "]");
        }

        public Receiver start() {
            this.receiving = true;
            this.recv.start();
            return this;
        }

        public Receiver stop() {
            this.receiving = false;
            return this;
        }

        public boolean isRunning() {
            return this.receiving;
        }

        public boolean canRun() {
            return this.isRunning() && TcpConnection.this.isConnected();
        }

        public int bufferSize() {
            return this.buffer != null ? this.buffer.length : 0;
        }

        @Override
        public void run() {
            try {
                while (this.canRun()) {
                    int len = TcpConnection.this.in.readInt();
                    TcpConnection.this.server.receive(TcpConnection.this.peer_addr, TcpConnection.this.in, len);
                    TcpConnection.this.updateLastAccessed();
                }
            }
            catch (EOFException | SocketException len) {
            }
            catch (Exception e) {
                if (e instanceof SSLException && e.getMessage().contains("Socket closed")) {
                } else {
                    TcpConnection.this.server.log.warn("failed handling message", e);
                }
            }
            finally {
                TcpConnection.this.server.notifyConnectionClosed(TcpConnection.this);
            }
        }
    }
}

