/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class XSiteStatePushCommand
extends XSiteReplicateCommand<Void> {
    public static final byte COMMAND_ID = 33;
    private XSiteState[] chunk;
    private long timeoutMillis;

    public XSiteStatePushCommand(ByteString cacheName, XSiteState[] chunk, long timeoutMillis) {
        super((byte)33, cacheName);
        this.chunk = chunk;
        this.timeoutMillis = timeoutMillis;
    }

    public XSiteStatePushCommand(ByteString cacheName) {
        super((byte)33, cacheName);
    }

    @Override
    public CompletionStage<Void> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        assert (!preserveOrder);
        return receiver.handleStateTransferState(this);
    }

    public XSiteStatePushCommand() {
        this(null);
    }

    public XSiteState[] getChunk() {
        return this.chunk;
    }

    public long getTimeout() {
        return this.timeoutMillis;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        XSiteStateConsumer stateConsumer = componentRegistry.getXSiteStateTransferManager().running().getStateConsumer();
        stateConsumer.applyState(this.chunk);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 33;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.timeoutMillis);
        MarshallUtil.marshallArray(this.chunk, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.timeoutMillis = input.readLong();
        this.chunk = (XSiteState[])MarshallUtil.unmarshallArray(input, XSiteState[]::new);
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteStatePushCommand{cacheName=" + this.cacheName + ", timeout=" + this.timeoutMillis + " (" + this.chunk.length + " keys)" + '}';
    }
}

