/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Immutables;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.RebalanceType;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManagerImpl;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.ConditionFuture;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;

public class ClusterCacheStatus
implements AvailabilityStrategyContext {
    public static final int INITIAL_TOPOLOGY_ID = 1;
    public static final int INITIAL_REBALANCE_ID = 1;
    private static final Hash HASH_FUNCTION = MurmurHash3.getInstance();
    private static final Log log = LogFactory.getLog(ClusterCacheStatus.class);
    private final EmbeddedCacheManager cacheManager;
    private final GlobalComponentRegistry gcr;
    private final String cacheName;
    private final AvailabilityStrategy availabilityStrategy;
    private final ClusterTopologyManagerImpl clusterTopologyManager;
    private final PersistentUUIDManager persistentUUIDManager;
    private EventLogger eventLogger;
    private final boolean resolveConflictsOnMerge;
    private final RebalanceType rebalanceType;
    private Transport transport;
    private int initialTopologyId = 1;
    private volatile CacheJoinInfo joinInfo;
    private volatile List<Address> expectedMembers;
    private volatile Map<Address, Float> capacityFactors;
    private volatile List<Address> joiners;
    private Optional<ScopedPersistentState> persistentState;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    private volatile List<Address> queuedRebalanceMembers;
    private volatile boolean rebalancingEnabled = true;
    private volatile boolean rebalanceInProgress = false;
    private volatile ConflictResolution conflictResolution;
    private RebalanceConfirmationCollector rebalanceConfirmationCollector;
    private ComponentStatus status;
    private final ConditionFuture<ClusterCacheStatus> hasInitialTopologyFuture;

    public ClusterCacheStatus(EmbeddedCacheManager cacheManager, GlobalComponentRegistry gcr, String cacheName, AvailabilityStrategy availabilityStrategy, RebalanceType rebalanceType, ClusterTopologyManagerImpl clusterTopologyManager, Transport transport, PersistentUUIDManager persistentUUIDManager, EventLogManager eventLogManager, Optional<ScopedPersistentState> state, boolean resolveConflictsOnMerge) {
        this.cacheManager = cacheManager;
        this.gcr = gcr;
        this.cacheName = cacheName;
        this.availabilityStrategy = availabilityStrategy;
        this.clusterTopologyManager = clusterTopologyManager;
        this.transport = transport;
        this.persistentState = state;
        this.resolveConflictsOnMerge = resolveConflictsOnMerge;
        this.rebalanceType = rebalanceType;
        this.currentTopology = null;
        this.stableTopology = null;
        this.expectedMembers = Collections.emptyList();
        this.capacityFactors = Collections.emptyMap();
        this.joiners = Collections.emptyList();
        this.persistentUUIDManager = persistentUUIDManager;
        this.eventLogger = eventLogManager.getEventLogger().context(cacheName);
        state.ifPresent(scopedPersistentState -> {
            this.rebalancingEnabled = false;
            this.availabilityMode = AvailabilityMode.DEGRADED_MODE;
        });
        this.status = ComponentStatus.INSTANTIATED;
        this.hasInitialTopologyFuture = new ConditionFuture(clusterTopologyManager.timeoutScheduledExecutor);
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s initialized. Persisted state? %s", (Object)cacheName, (Object)this.persistentState.isPresent());
        }
    }

    @Override
    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    @Override
    public List<Address> getExpectedMembers() {
        return this.expectedMembers;
    }

    @Override
    public synchronized void queueRebalance(List<Address> newMembers) {
        if (newMembers != null && !newMembers.isEmpty() && this.totalCapacityFactors() != 0.0f) {
            log.debugf("Queueing rebalance for cache %s with members %s", (Object)this.cacheName, (Object)newMembers);
            this.queuedRebalanceMembers = newMembers;
            this.startQueuedRebalance();
        }
    }

    @Override
    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    @Override
    public CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    @Override
    public CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    @Override
    public synchronized void updateAvailabilityMode(List<Address> actualMembers, AvailabilityMode newAvailabilityMode, boolean cancelRebalance) {
        AvailabilityMode oldAvailabilityMode = this.availabilityMode;
        boolean modeChanged = this.setAvailabilityMode(newAvailabilityMode);
        if (modeChanged || !actualMembers.equals(this.currentTopology.getActualMembers())) {
            ConsistentHash newPendingCH = this.currentTopology.getPendingCH();
            CacheTopology.Phase newPhase = this.currentTopology.getPhase();
            if (cancelRebalance) {
                newPendingCH = null;
                newPhase = CacheTopology.Phase.NO_REBALANCE;
                this.rebalanceConfirmationCollector = null;
            }
            CacheTopology newTopology = new CacheTopology(this.currentTopology.getTopologyId() + 1, this.currentTopology.getRebalanceId(), this.currentTopology.getCurrentCH(), newPendingCH, newPhase, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
            this.setCurrentTopology(newTopology);
            Log.CLUSTER.updatingAvailabilityMode(this.cacheName, oldAvailabilityMode, newAvailabilityMode, newTopology);
            this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheAvailabilityModeChange(newAvailabilityMode, newTopology.getTopologyId()));
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, newAvailabilityMode);
        }
    }

    @Override
    public synchronized void updateTopologiesAfterMerge(CacheTopology currentTopology, CacheTopology stableTopology, AvailabilityMode availabilityMode) {
        Log.CLUSTER.cacheRecoveredAfterMerge(this.cacheName, currentTopology, availabilityMode);
        this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheRecoveredAfterMerge(currentTopology.getMembers(), currentTopology.getTopologyId()));
        this.currentTopology = currentTopology;
        this.stableTopology = stableTopology;
        this.availabilityMode = availabilityMode;
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, currentTopology, availabilityMode);
        if (stableTopology != null) {
            log.updatingStableTopology(this.cacheName, stableTopology);
            this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, stableTopology);
        }
    }

    @GuardedBy(value="this")
    private boolean addMember(Address joiner, CacheJoinInfo joinInfo) {
        if (this.expectedMembers.contains(joiner)) {
            return false;
        }
        if (this.joinInfo == null) {
            this.joinInfo = joinInfo;
        }
        HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
        newCapacityFactors.put(joiner, Float.valueOf(joinInfo.getCapacityFactor()));
        this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
        this.expectedMembers = this.immutableAdd(this.expectedMembers, joiner);
        this.persistentUUIDManager.addPersistentAddressMapping(joiner, joinInfo.getPersistentUUID());
        this.joiners = this.immutableAdd(this.joiners, joiner);
        if (log.isTraceEnabled()) {
            log.tracef("Added joiner %s to cache %s with persistent uuid %s: members = %s, joiners = %s", joiner, this.cacheName, joinInfo.getPersistentUUID(), this.expectedMembers, this.joiners);
        }
        return true;
    }

    @GuardedBy(value="this")
    private void validateJoiner(Address joiner, CacheJoinInfo joinInfo) {
        if (this.persistentState.isPresent()) {
            if (!joinInfo.getPersistentStateChecksum().isPresent()) {
                if (this.status == ComponentStatus.INSTANTIATED) {
                    throw Log.CLUSTER.nodeWithoutPersistentStateJoiningCacheWithState(joiner, this.cacheName);
                }
            } else if (this.persistentState.get().getChecksum() != joinInfo.getPersistentStateChecksum().get().intValue()) {
                throw Log.CLUSTER.nodeWithIncompatibleStateJoiningCache(joiner, this.cacheName);
            }
        } else if (joinInfo.getPersistentStateChecksum().isPresent()) {
            throw Log.CLUSTER.nodeWithPersistentStateJoiningClusterWithoutState(joiner, this.cacheName);
        }
    }

    @GuardedBy(value="this")
    private boolean removeMember(Address leaver) {
        if (!this.expectedMembers.contains(leaver)) {
            if (log.isTraceEnabled()) {
                log.tracef("Trying to remove node %s from cache %s, but it is not a member: members = %s", (Object)leaver, (Object)this.cacheName, (Object)this.expectedMembers);
            }
            return false;
        }
        this.expectedMembers = this.immutableRemove(this.expectedMembers, leaver);
        HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
        newCapacityFactors.remove(leaver);
        this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
        this.joiners = this.immutableRemove(this.joiners, leaver);
        if (log.isTraceEnabled()) {
            log.tracef("Removed node %s from cache %s: members = %s, joiners = %s", leaver, this.cacheName, this.expectedMembers, this.joiners);
        }
        return true;
    }

    @GuardedBy(value="this")
    private boolean retainMembers(List<Address> newClusterMembers) {
        if (newClusterMembers.containsAll(this.expectedMembers)) {
            if (log.isTraceEnabled()) {
                log.tracef("Cluster members updated for cache %s, no abrupt leavers detected: cache members = %s. Existing members = %s", (Object)this.cacheName, (Object)newClusterMembers, (Object)this.expectedMembers);
            }
            return false;
        }
        this.expectedMembers = this.immutableRetainAll(this.expectedMembers, newClusterMembers);
        this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
        if (log.isTraceEnabled()) {
            log.tracef("Cluster members updated for cache %s: members = %s, joiners = %s", (Object)this.cacheName, (Object)this.expectedMembers, (Object)this.joiners);
        }
        return true;
    }

    @GuardedBy(value="this")
    private void setCurrentTopology(CacheTopology newTopology) {
        this.currentTopology = newTopology;
        if (newTopology != null) {
            this.joiners = this.immutableRemoveAll(this.expectedMembers, newTopology.getCurrentCH().getMembers());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s topology updated: %s, members = %s, joiners = %s", this.cacheName, this.currentTopology, this.expectedMembers, this.joiners);
        }
        if (newTopology != null) {
            newTopology.logRoutingTableInformation(this.cacheName);
        }
    }

    @GuardedBy(value="this")
    private void setStableTopology(CacheTopology newTopology) {
        this.stableTopology = newTopology;
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s stable topology updated: members = %s, joiners = %s, topology = %s", this.cacheName, this.expectedMembers, this.joiners, newTopology);
        }
    }

    private boolean needConsistentHashUpdate() {
        return !this.expectedMembers.equals(this.currentTopology.getMembers());
    }

    private List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.expectedMembers);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceConfirmationCollector != null;
    }

    public RebalancingStatus getRebalancingStatus() {
        if (!this.isRebalanceEnabled()) {
            return RebalancingStatus.SUSPENDED;
        }
        if (this.rebalanceInProgress) {
            return RebalancingStatus.IN_PROGRESS;
        }
        if (this.queuedRebalanceMembers != null) {
            return RebalancingStatus.PENDING;
        }
        return RebalancingStatus.COMPLETE;
    }

    public synchronized void confirmRebalancePhase(Address member, int receivedTopologyId) throws Exception {
        if (this.currentTopology == null) {
            log.debugf("Ignoring rebalance confirmation from %s for cache %s because the cache has no members", (Object)member, (Object)this.cacheName);
            return;
        }
        if (receivedTopologyId < this.currentTopology.getTopologyId()) {
            log.debugf("Ignoring rebalance confirmation from %s for cache %s because the topology id is old (%d, expected %d)", member, this.cacheName, receivedTopologyId, this.currentTopology.getTopologyId());
            return;
        }
        if (this.rebalanceConfirmationCollector == null) {
            throw new CacheException(String.format("Received invalid rebalance confirmation from %s for cache %s, we don't have a rebalance in progress", member, this.cacheName));
        }
        Log.CLUSTER.rebalancePhaseConfirmedOnNode(this.currentTopology.getPhase(), this.cacheName, member, receivedTopologyId);
        this.rebalanceConfirmationCollector.confirmPhase(member, receivedTopologyId);
    }

    @GuardedBy(value="this")
    private void updateMembers() {
        if (this.rebalanceConfirmationCollector != null) {
            this.rebalanceConfirmationCollector.updateMembers(this.currentTopology.getMembers());
        }
    }

    public synchronized void doHandleClusterView(int viewId) {
        if (this.currentTopology == null) {
            return;
        }
        List<Address> newClusterMembers = this.transport.getMembers();
        int newViewId = this.transport.getViewId();
        if (newViewId != viewId) {
            log.debugf("Cache %s skipping members update for view %d, newer view received: %d", (Object)this.cacheName, (Object)viewId, (Object)newViewId);
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s updating members for view %d: %s", (Object)this.cacheName, (Object)viewId, (Object)newClusterMembers);
        }
        boolean cacheMembersModified = this.retainMembers(newClusterMembers);
        this.availabilityStrategy.onClusterViewChange(this, newClusterMembers);
        if (cacheMembersModified) {
            this.updateMembers();
        }
    }

    @GuardedBy(value="this")
    private void endRebalance() {
        CacheTopology newTopology;
        this.rebalanceInProgress = false;
        CacheTopology currentTopology = this.getCurrentTopology();
        if (currentTopology == null) {
            log.tracef("Rebalance finished because there are no more members in cache %s", (Object)this.cacheName);
            return;
        }
        assert (currentTopology.getPhase().isRebalance());
        int currentTopologyId = currentTopology.getTopologyId();
        List<Address> members = currentTopology.getMembers();
        switch (this.rebalanceType) {
            case FOUR_PHASE: {
                newTopology = new CacheTopology(currentTopologyId + 1, currentTopology.getRebalanceId(), currentTopology.getCurrentCH(), currentTopology.getPendingCH(), CacheTopology.Phase.READ_ALL_WRITE_ALL, members, this.persistentUUIDManager.mapAddresses(members));
                break;
            }
            case TWO_PHASE: {
                newTopology = new CacheTopology(currentTopologyId + 1, currentTopology.getRebalanceId(), currentTopology.getPendingCH(), null, CacheTopology.Phase.NO_REBALANCE, members, this.persistentUUIDManager.mapAddresses(members));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.setCurrentTopology(newTopology);
        this.rebalanceConfirmationCollector = newTopology.getPhase() != CacheTopology.Phase.NO_REBALANCE ? new RebalanceConfirmationCollector(this.cacheName, currentTopologyId + 1, members, this::endReadAllPhase) : null;
        this.availabilityStrategy.onRebalanceEnd(this);
        Log.CLUSTER.startingRebalancePhase(this.cacheName, newTopology);
        this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheRebalancePhaseChange(newTopology.getPhase(), newTopology.getTopologyId()));
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode);
        if (newTopology.getPhase() == CacheTopology.Phase.NO_REBALANCE) {
            this.startQueuedRebalance();
        }
    }

    @GuardedBy(value="this")
    private void endReadAllPhase() {
        CacheTopology currentTopology = this.getCurrentTopology();
        assert (currentTopology != null);
        assert (currentTopology.getPhase() == CacheTopology.Phase.READ_ALL_WRITE_ALL);
        List<Address> members = currentTopology.getMembers();
        CacheTopology newTopology = new CacheTopology(currentTopology.getTopologyId() + 1, currentTopology.getRebalanceId(), currentTopology.getCurrentCH(), currentTopology.getPendingCH(), CacheTopology.Phase.READ_NEW_WRITE_ALL, members, this.persistentUUIDManager.mapAddresses(members));
        this.setCurrentTopology(newTopology);
        this.rebalanceConfirmationCollector = new RebalanceConfirmationCollector(this.cacheName, currentTopology.getTopologyId() + 1, members, this::endReadNewPhase);
        Log.CLUSTER.startingRebalancePhase(this.cacheName, newTopology);
        this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheRebalancePhaseChange(newTopology.getPhase(), newTopology.getTopologyId()));
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode);
    }

    @GuardedBy(value="this")
    private void endReadNewPhase() {
        CacheTopology currentTopology = this.getCurrentTopology();
        assert (currentTopology != null);
        assert (currentTopology.getPhase() == CacheTopology.Phase.READ_NEW_WRITE_ALL);
        List<Address> members = currentTopology.getMembers();
        CacheTopology newTopology = new CacheTopology(currentTopology.getTopologyId() + 1, currentTopology.getRebalanceId(), currentTopology.getPendingCH(), null, CacheTopology.Phase.NO_REBALANCE, members, this.persistentUUIDManager.mapAddresses(members));
        this.setCurrentTopology(newTopology);
        this.rebalanceConfirmationCollector = null;
        Log.CLUSTER.finishedRebalance(this.cacheName, newTopology);
        this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.rebalanceFinished(newTopology.getMembers(), newTopology.getTopologyId()));
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode);
        this.startQueuedRebalance();
    }

    @Override
    public synchronized void updateCurrentTopology(List<Address> newMembers) {
        ConsistentHash newCurrentCH;
        List<Address> actualMembers;
        if (this.currentTopology == null) {
            this.createInitialCacheTopology();
        }
        ConsistentHashFactory consistentHashFactory = this.getJoinInfo().getConsistentHashFactory();
        int topologyId = this.currentTopology.getTopologyId();
        int rebalanceId = this.currentTopology.getRebalanceId();
        ConsistentHash currentCH = this.currentTopology.getCurrentCH();
        ConsistentHash pendingCH = this.currentTopology.getPendingCH();
        if (!this.needConsistentHashUpdate()) {
            log.tracef("Cache %s members list was updated, but the cache topology doesn't need to change: %s", (Object)this.cacheName, (Object)this.currentTopology);
            return;
        }
        if (newMembers.isEmpty()) {
            log.tracef("Cache %s no longer has any members, removing topology", (Object)this.cacheName);
            this.setCurrentTopology(null);
            this.setStableTopology(null);
            this.rebalanceConfirmationCollector = null;
            this.status = ComponentStatus.INSTANTIATED;
            return;
        }
        if (this.totalCapacityFactors() == 0.0f) {
            Log.CLUSTER.debugf("All members have capacity factor 0, delaying topology update", new Object[0]);
            return;
        }
        List<Address> newCurrentMembers = this.pruneInvalidMembers(currentCH.getMembers());
        ConsistentHash newPendingCH = null;
        CacheTopology.Phase newPhase = CacheTopology.Phase.NO_REBALANCE;
        if (newCurrentMembers.isEmpty()) {
            log.tracef("All current members left, re-initializing status for cache %s", (Object)this.cacheName);
            this.rebalanceConfirmationCollector = null;
            actualMembers = newCurrentMembers = this.getExpectedMembers();
            newCurrentCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), newCurrentMembers, this.getCapacityFactors());
        } else {
            newCurrentCH = consistentHashFactory.updateMembers(currentCH, newCurrentMembers, this.getCapacityFactors());
            actualMembers = newCurrentMembers;
            if (pendingCH != null) {
                newPhase = this.currentTopology.getPhase();
                List<Address> newPendingMembers = this.pruneInvalidMembers(pendingCH.getMembers());
                newPendingCH = consistentHashFactory.updateMembers(pendingCH, newPendingMembers, this.getCapacityFactors());
                actualMembers = this.pruneInvalidMembers(newPendingMembers);
            }
        }
        CacheTopology newTopology = new CacheTopology(topologyId + 1, rebalanceId, newCurrentCH, newPendingCH, newPhase, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
        this.setCurrentTopology(newTopology);
        if (this.rebalanceConfirmationCollector != null) {
            log.debugf("Cancelling topology confirmation %s because of another topology update", (Object)this.rebalanceConfirmationCollector);
            this.rebalanceConfirmationCollector = null;
        }
        Log.CLUSTER.updatingTopology(this.cacheName, newTopology, this.availabilityMode);
        this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheMembersUpdated(actualMembers, newTopology.getTopologyId()));
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode);
    }

    @GuardedBy(value="this")
    private float totalCapacityFactors() {
        float totalCapacityFactors = 0.0f;
        for (Float factor : this.capacityFactors.values()) {
            totalCapacityFactors += factor.floatValue();
        }
        return totalCapacityFactors;
    }

    private boolean setAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        if (newAvailabilityMode == this.availabilityMode) {
            return false;
        }
        log.tracef("Cache %s availability changed: %s -> %s", (Object)this.cacheName, (Object)this.availabilityMode, (Object)newAvailabilityMode);
        this.availabilityMode = newAvailabilityMode;
        return true;
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "ClusterCacheStatus{cacheName='" + this.cacheName + '\'' + ", members=" + this.expectedMembers + ", joiners=" + this.joiners + ", currentTopology=" + this.currentTopology + ", rebalanceConfirmationCollector=" + this.rebalanceConfirmationCollector + '}';
    }

    public synchronized void doMergePartitions(Map<Address, CacheStatusResponse> statusResponses) {
        try {
            if (statusResponses.isEmpty()) {
                throw new IllegalArgumentException("Should have at least one current topology");
            }
            HashMap<Address, CacheJoinInfo> joinInfos = new HashMap<Address, CacheJoinInfo>();
            HashSet<CacheTopology> currentTopologies = new HashSet<CacheTopology>();
            HashSet<CacheTopology> stableTopologies = new HashSet<CacheTopology>();
            for (Map.Entry<Address, CacheStatusResponse> e : statusResponses.entrySet()) {
                Address sender = e.getKey();
                CacheStatusResponse response = e.getValue();
                joinInfos.put(sender, response.getCacheJoinInfo());
                if (response.getCacheTopology() != null) {
                    currentTopologies.add(response.getCacheTopology());
                }
                if (response.getStableTopology() == null) continue;
                stableTopologies.add(response.getStableTopology());
            }
            log.debugf("Recovered %d partition(s) for cache %s: %s", currentTopologies.size(), (Object)this.cacheName, (Object)currentTopologies);
            this.recoverMembers(joinInfos, currentTopologies, stableTopologies);
            this.availabilityStrategy.onPartitionMerge(this, statusResponses);
        }
        catch (IllegalLifecycleStateException joinInfos) {
        }
        catch (Exception e) {
            log.failedToRecoverCacheState(this.cacheName, e);
        }
    }

    @GuardedBy(value="this")
    private void recoverMembers(Map<Address, CacheJoinInfo> joinInfos, Collection<CacheTopology> currentTopologies, Collection<CacheTopology> stableTopologies) {
        this.expectedMembers = Collections.emptyList();
        for (CacheTopology cacheTopology : stableTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (CacheTopology cacheTopology : currentTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (Map.Entry entry : joinInfos.entrySet()) {
            if (this.expectedMembers.contains(entry.getKey())) continue;
            this.addMember((Address)entry.getKey(), (CacheJoinInfo)entry.getValue());
        }
    }

    @GuardedBy(value="this")
    private void addMembers(Collection<Address> membersToAdd, Map<Address, CacheJoinInfo> joinInfos) {
        for (Address member : membersToAdd) {
            CacheJoinInfo joinInfo;
            if (this.expectedMembers.contains(member) || (joinInfo = joinInfos.get(member)) == null) continue;
            this.addMember(member, joinInfo);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public synchronized CacheStatusResponse doJoin(Address joiner, CacheJoinInfo joinInfo) {
        CacheTopology topologyBeforeRebalance;
        this.validateJoiner(joiner, joinInfo);
        boolean isFirstMember = this.getCurrentTopology() == null;
        boolean memberJoined = this.addMember(joiner, joinInfo);
        if (!memberJoined) {
            if (log.isTraceEnabled()) {
                log.tracef("Trying to add node %s to cache %s, but it is already a member: members = %s, joiners = %s", joiner, this.cacheName, this.expectedMembers, this.joiners);
            }
            return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
        }
        if (this.status == ComponentStatus.INSTANTIATED) {
            if (this.persistentState.isPresent()) {
                CacheTopology topology;
                if (log.isTraceEnabled()) {
                    log.tracef("Node %s joining. Attempting to reform previous cluster", (Object)joiner);
                }
                if ((topology = this.restoreCacheTopology(this.persistentState.get())) != null) {
                    this.status = ComponentStatus.RUNNING;
                    Log.CLUSTER.updatingTopology(this.cacheName, topology, this.availabilityMode);
                    this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheMembersUpdated(topology.getMembers(), topology.getTopologyId()));
                    this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, topology, this.availabilityMode);
                    this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, topology);
                    return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
                }
            } else if (isFirstMember) {
                CacheTopology initialTopology = this.createInitialCacheTopology();
                this.status = ComponentStatus.RUNNING;
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, initialTopology);
                this.hasInitialTopologyFuture.updateAsync(this, this.clusterTopologyManager.nonBlockingExecutor);
            }
        }
        if ((topologyBeforeRebalance = this.getCurrentTopology()) != null) {
            this.availabilityStrategy.onJoin(this, joiner);
        }
        return new CacheStatusResponse(null, topologyBeforeRebalance, this.stableTopology, this.availabilityMode);
    }

    CompletionStage<Void> nodeCanJoinFuture(CacheJoinInfo joinInfo) {
        if (joinInfo.getCapacityFactor() != 0.0f || this.getCurrentTopology() != null) {
            return CompletableFutures.completedNull();
        }
        return this.hasInitialTopologyFuture.newConditionStage(ccs -> ccs.getCurrentTopology() != null, () -> new TimeoutException("Timed out waiting for initial cache topology"), joinInfo.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @GuardedBy(value="this")
    protected CacheTopology restoreCacheTopology(ScopedPersistentState state) {
        ConsistentHash persistedCH;
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to restore CH for cache %s", (Object)this.cacheName);
        }
        if ((persistedCH = this.joinInfo.getConsistentHashFactory().fromPersistentState(state).remapAddresses(this.persistentUUIDManager.persistentUUIDToAddress())) == null || !this.getExpectedMembers().containsAll(persistedCH.getMembers())) {
            if (log.isTraceEnabled()) {
                log.tracef("Could not restore CH for cache %s, one or more addresses are missing", (Object)this.cacheName);
            }
            return null;
        }
        if (this.getExpectedMembers().size() > persistedCH.getMembers().size()) {
            ArrayList<Address> extraneousMembers = new ArrayList<Address>(this.getExpectedMembers());
            extraneousMembers.removeAll(persistedCH.getMembers());
            throw Log.CLUSTER.extraneousMembersJoinRestoredCache(extraneousMembers, this.cacheName);
        }
        CacheTopology initialTopology = new CacheTopology(this.initialTopologyId, 1, persistedCH, null, CacheTopology.Phase.NO_REBALANCE, persistedCH.getMembers(), this.persistentUUIDManager.mapAddresses(persistedCH.getMembers()));
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        this.rebalancingEnabled = true;
        this.availabilityMode = AvailabilityMode.AVAILABLE;
        return initialTopology;
    }

    @GuardedBy(value="this")
    protected CacheTopology createInitialCacheTopology() {
        log.tracef("Initializing status for cache %s", (Object)this.cacheName);
        List<Address> initialMembers = this.getExpectedMembers();
        Object initialCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), initialMembers, this.getCapacityFactors());
        CacheTopology initialTopology = new CacheTopology(this.initialTopologyId, 1, (ConsistentHash)initialCH, null, CacheTopology.Phase.NO_REBALANCE, initialMembers, this.persistentUUIDManager.mapAddresses(initialMembers));
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        return initialTopology;
    }

    public synchronized CompletionStage<Void> doLeave(Address leaver) throws Exception {
        if (this.currentTopology == null) {
            return CompletableFutures.completedNull();
        }
        boolean actualLeaver = this.removeMember(leaver);
        if (!actualLeaver) {
            return CompletableFutures.completedNull();
        }
        this.availabilityStrategy.onGracefulLeave(this, leaver);
        this.updateMembers();
        if (this.expectedMembers.isEmpty()) {
            this.clusterTopologyManager.removeCacheStatus(this.cacheName);
        }
        return CompletableFutures.completedNull();
    }

    public synchronized void startQueuedRebalance() {
        boolean removeMembers;
        if (this.conflictResolution != null) {
            log.tracef("Postponing rebalance for cache %s as conflict resolution is in progress", (Object)this.cacheName);
            return;
        }
        if (this.queuedRebalanceMembers == null) {
            if (this.stableTopology == null || this.stableTopology.getTopologyId() < this.currentTopology.getTopologyId()) {
                this.stableTopology = this.currentTopology;
                log.updatingStableTopology(this.cacheName, this.stableTopology);
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, this.stableTopology);
            }
            return;
        }
        CacheTopology cacheTopology = this.getCurrentTopology();
        if (!this.isRebalanceEnabled()) {
            log.tracef("Postponing rebalance for cache %s, rebalancing is disabled", (Object)this.cacheName);
            return;
        }
        if (this.rebalanceConfirmationCollector != null) {
            log.tracef("Postponing rebalance for cache %s, there's already a topology change in progress: %s", (Object)this.cacheName, (Object)this.rebalanceConfirmationCollector);
            return;
        }
        if (this.queuedRebalanceMembers.isEmpty()) {
            log.tracef("Ignoring request to rebalance cache %s, it doesn't have any member", (Object)this.cacheName);
            return;
        }
        if (cacheTopology == null) {
            this.createInitialCacheTopology();
            return;
        }
        List<Address> newMembers = ClusterCacheStatus.updateMembersPreservingOrder(cacheTopology.getMembers(), this.queuedRebalanceMembers);
        this.queuedRebalanceMembers = null;
        log.tracef("Rebalancing consistent hash for cache %s, members are %s", (Object)this.cacheName, (Object)newMembers);
        int newTopologyId = cacheTopology.getTopologyId() + 1;
        int newRebalanceId = cacheTopology.getRebalanceId() + 1;
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        if (currentCH == null) {
            log.tracef("Ignoring request to rebalance cache %s, it doesn't have a consistent hash", (Object)this.cacheName);
            return;
        }
        if (!this.expectedMembers.containsAll(newMembers)) {
            newMembers.removeAll(this.expectedMembers);
            log.tracef("Ignoring request to rebalance cache %s, we have new leavers: %s", (Object)this.cacheName, (Object)newMembers);
            return;
        }
        ConsistentHashFactory chFactory = this.getJoinInfo().getConsistentHashFactory();
        ConsistentHash updatedMembersCH = chFactory.updateMembers(currentCH, newMembers, this.getCapacityFactors());
        ConsistentHash balancedCH = chFactory.rebalance(updatedMembersCH);
        boolean bl = removeMembers = !this.expectedMembers.containsAll(currentCH.getMembers());
        if (removeMembers) {
            LinkedList<Address> unwantedMembers = new LinkedList<Address>(currentCH.getMembers());
            unwantedMembers.removeAll(this.expectedMembers);
            Log.CLUSTER.debugf("Removing unwanted members from the current consistent hash: %s", (Object)unwantedMembers);
            currentCH = updatedMembersCH;
        }
        boolean updateTopology = false;
        boolean rebalance = false;
        boolean updateStableTopology = false;
        if (this.rebalanceType == RebalanceType.NONE) {
            updateTopology = true;
        } else if (balancedCH.equals(currentCH)) {
            if (log.isTraceEnabled()) {
                log.tracef("The balanced CH is the same as the current CH, not rebalancing", new Object[0]);
            }
            updateTopology = cacheTopology.getPendingCH() != null || removeMembers;
            updateStableTopology = cacheTopology.getPendingCH() == null && (this.stableTopology == null || cacheTopology.getTopologyId() != this.stableTopology.getTopologyId());
        } else {
            rebalance = true;
        }
        if (updateTopology) {
            CacheTopology newTopology = new CacheTopology(newTopologyId, cacheTopology.getRebalanceId(), balancedCH, null, CacheTopology.Phase.NO_REBALANCE, balancedCH.getMembers(), this.persistentUUIDManager.mapAddresses(balancedCH.getMembers()));
            log.tracef("Updating cache %s topology without rebalance: %s", (Object)this.cacheName, (Object)newTopology);
            this.setCurrentTopology(newTopology);
            Log.CLUSTER.updatingTopology(this.cacheName, newTopology, this.availabilityMode);
            this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheMembersUpdated(newTopology.getMembers(), newTopology.getTopologyId()));
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.getAvailabilityMode());
        } else if (rebalance) {
            CacheTopology.Phase newPhase;
            switch (this.rebalanceType) {
                case FOUR_PHASE: {
                    newPhase = CacheTopology.Phase.READ_OLD_WRITE_ALL;
                    break;
                }
                case TWO_PHASE: {
                    newPhase = CacheTopology.Phase.TRANSITORY;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            CacheTopology newTopology = new CacheTopology(newTopologyId, newRebalanceId, currentCH, balancedCH, newPhase, balancedCH.getMembers(), this.persistentUUIDManager.mapAddresses(balancedCH.getMembers()));
            log.tracef("Updating cache %s topology for rebalance: %s", (Object)this.cacheName, (Object)newTopology);
            this.setCurrentTopology(newTopology);
            this.rebalanceInProgress = true;
            assert (this.rebalanceConfirmationCollector == null);
            this.rebalanceConfirmationCollector = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers(), this::endRebalance);
            Log.CLUSTER.startingRebalancePhase(this.cacheName, newTopology);
            this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.cacheRebalanceStart(newTopology.getMembers(), newTopology.getPhase(), newTopology.getTopologyId()));
            this.clusterTopologyManager.broadcastRebalanceStart(this.cacheName, newTopology);
        } else if (updateStableTopology) {
            this.stableTopology = this.currentTopology;
            this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, this.stableTopology);
        }
    }

    private static List<Address> updateMembersPreservingOrder(List<Address> oldMembers, List<Address> newMembers) {
        ArrayList<Address> membersPreservingOrder = new ArrayList<Address>(oldMembers);
        membersPreservingOrder.retainAll(newMembers);
        for (Address a : newMembers) {
            if (membersPreservingOrder.contains(a)) continue;
            membersPreservingOrder.add(a);
        }
        return membersPreservingOrder;
    }

    public boolean isRebalanceEnabled() {
        return this.rebalancingEnabled && this.clusterTopologyManager.isRebalancingEnabled();
    }

    public synchronized CompletionStage<Void> setRebalanceEnabled(boolean enabled) {
        this.rebalancingEnabled = enabled;
        if (this.rebalancingEnabled) {
            log.debugf("Rebalancing is now enabled for cache %s", (Object)this.cacheName);
            this.startQueuedRebalance();
        } else {
            log.debugf("Rebalancing is now disabled for cache %s", (Object)this.cacheName);
        }
        return CompletableFutures.completedNull();
    }

    public void forceRebalance() {
        this.queueRebalance(this.getCurrentTopology().getMembers());
    }

    public synchronized CompletionStage<Void> forceAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        if (this.currentTopology != null && newAvailabilityMode != this.availabilityMode) {
            this.availabilityStrategy.onManualAvailabilityChange(this, newAvailabilityMode);
        }
        return CompletableFutures.completedNull();
    }

    public synchronized CompletionStage<Void> shutdownCache() throws Exception {
        if (this.status == ComponentStatus.RUNNING) {
            this.status = ComponentStatus.STOPPING;
            this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, false);
            return this.clusterTopologyManager.broadcastShutdownCache(this.cacheName).thenRun(() -> {
                this.status = ComponentStatus.TERMINATED;
            });
        }
        return CompletableFutures.completedNull();
    }

    public synchronized void setInitialTopologyId(int initialTopologyId) {
        this.initialTopologyId = initialTopologyId;
    }

    @Override
    public boolean resolveConflictsOnMerge() {
        return this.resolveConflictsOnMerge && this.cacheManager.getStatus().allowInvocations() && this.clusterTopologyManager.isRebalancingEnabled() && this.rebalancingEnabled;
    }

    @Override
    public ConsistentHash calculateConflictHash(ConsistentHash preferredHash, Set<ConsistentHash> distinctHashes, List<Address> actualMembers) {
        ConsistentHashFactory chf = this.getJoinInfo().getConsistentHashFactory();
        ConsistentHash unionHash = distinctHashes.stream().reduce(preferredHash, chf::union);
        unionHash = chf.union(unionHash, chf.rebalance(unionHash));
        return chf.updateMembers(unionHash, actualMembers, this.capacityFactors);
    }

    @Override
    public synchronized void queueConflictResolution(CacheTopology conflictTopology, Set<Address> preferredNodes) {
        if (this.resolveConflictsOnMerge()) {
            this.conflictResolution = new ConflictResolution();
            CompletableFuture<Void> resolutionFuture = this.conflictResolution.queue(conflictTopology, preferredNodes);
            resolutionFuture.thenRun(this::completeConflictResolution);
        }
    }

    private synchronized void completeConflictResolution() {
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s conflict resolution future complete", (Object)this.cacheName);
        }
        this.availabilityMode = AvailabilityMode.AVAILABLE;
        CacheTopology conflictTopology = this.conflictResolution.topology;
        CacheTopology newTopology = new CacheTopology(conflictTopology.getTopologyId() + 1, conflictTopology.getRebalanceId(), conflictTopology.getCurrentCH(), null, CacheTopology.Phase.NO_REBALANCE, conflictTopology.getActualMembers(), this.persistentUUIDManager.mapAddresses(conflictTopology.getActualMembers()));
        this.conflictResolution = null;
        this.setCurrentTopology(newTopology);
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode);
        List<Address> actualMembers = conflictTopology.getActualMembers();
        List<Address> newMembers = this.getExpectedMembers();
        this.updateAvailabilityMode(actualMembers, this.availabilityMode, false);
        this.updateCurrentTopology(newMembers);
        this.queueRebalance(newMembers);
    }

    @Override
    public synchronized boolean restartConflictResolution(List<Address> members) {
        if (!this.resolveConflictsOnMerge() || this.conflictResolution == null) {
            return false;
        }
        if (members.size() == 1) {
            log.debugf("Cache %s cancelling conflict resolution as only one cluster member: members=%s", (Object)this.cacheName, (Object)members);
            this.conflictResolution.cancelCurrentAttempt();
            this.conflictResolution = null;
            return false;
        }
        if (!this.conflictResolution.restartRequired(members)) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s not restarting conflict resolution, existing conflict topology contains all members (%s)", (Object)this.cacheName, (Object)members);
            }
            return false;
        }
        CacheTopology conflictTopology = this.conflictResolution.topology;
        ConsistentHashFactory chf = this.getJoinInfo().getConsistentHashFactory();
        ConsistentHash newHash = chf.updateMembers(conflictTopology.getCurrentCH(), members, this.capacityFactors);
        this.currentTopology = conflictTopology = new CacheTopology(this.currentTopology.getTopologyId() + 1, this.currentTopology.getRebalanceId(), newHash, null, CacheTopology.Phase.CONFLICT_RESOLUTION, members, this.persistentUUIDManager.mapAddresses(members));
        log.debugf("Cache %s restarting conflict resolution with topology %s", (Object)this.cacheName, (Object)this.currentTopology);
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, conflictTopology, this.availabilityMode);
        this.queueConflictResolution(conflictTopology, this.conflictResolution.preferredNodes);
        return true;
    }

    private synchronized void cancelConflictResolutionPhase(CacheTopology resolutionTopology) {
        if (this.conflictResolution != null) {
            if (this.conflictResolution.topology.getTopologyId() > resolutionTopology.getTopologyId()) {
                return;
            }
            this.completeConflictResolution();
        }
    }

    private class ConflictResolution {
        final CompletableFuture<Void> future = new CompletableFuture();
        final AtomicBoolean cancelledLocally = new AtomicBoolean();
        final InternalConflictManager<?, ?> manager;
        volatile CacheTopology topology;
        volatile Set<Address> preferredNodes;

        ConflictResolution() {
            ComponentRegistry componentRegistry = ClusterCacheStatus.this.gcr.getNamedComponentRegistry(ClusterCacheStatus.this.cacheName);
            this.manager = componentRegistry.getComponent(InternalConflictManager.class);
        }

        synchronized CompletableFuture<Void> queue(CacheTopology topology, Set<Address> preferredNodes) {
            this.topology = topology;
            this.preferredNodes = preferredNodes;
            log.debugf("Cache %s queueing conflict resolution with members %s", (Object)ClusterCacheStatus.this.cacheName, (Object)topology.getMembers());
            Log.CLUSTER.startingConflictResolution(ClusterCacheStatus.this.cacheName, ClusterCacheStatus.this.currentTopology);
            ClusterCacheStatus.this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.conflictResolutionStarting(ClusterCacheStatus.this.currentTopology.getMembers(), ClusterCacheStatus.this.currentTopology.getTopologyId()));
            this.manager.resolveConflicts(topology, preferredNodes).whenComplete((Void2, t) -> {
                if (t == null) {
                    Log.CLUSTER.finishedConflictResolution(ClusterCacheStatus.this.cacheName, ClusterCacheStatus.this.currentTopology);
                    ClusterCacheStatus.this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.conflictResolutionFinished(topology.getMembers(), topology.getTopologyId()));
                    this.future.complete(null);
                } else if (this.cancelledLocally.get()) {
                    Log.CLUSTER.cancelledConflictResolution(ClusterCacheStatus.this.cacheName, topology);
                    ClusterCacheStatus.this.eventLogger.info(EventLogCategory.CLUSTER, Messages.MESSAGES.conflictResolutionCancelled(topology.getMembers(), topology.getTopologyId()));
                    ClusterCacheStatus.this.cancelConflictResolutionPhase(topology);
                } else if (t instanceof CompletionException) {
                    Throwable cause;
                    Throwable rootCause = t;
                    while ((cause = rootCause.getCause()) != null && rootCause != cause) {
                        rootCause = cause;
                    }
                    Log.CLUSTER.failedConflictResolution(ClusterCacheStatus.this.cacheName, topology, rootCause);
                    ClusterCacheStatus.this.eventLogger.error(EventLogCategory.CLUSTER, Messages.MESSAGES.conflictResolutionFailed(topology.getMembers(), topology.getTopologyId(), rootCause.getMessage()));
                    if (!(rootCause instanceof SuspectException)) {
                        ClusterCacheStatus.this.cancelConflictResolutionPhase(topology);
                    }
                }
            });
            return this.future;
        }

        synchronized void cancelCurrentAttempt() {
            this.cancelledLocally.set(true);
            this.manager.cancelConflictResolution();
        }

        synchronized boolean restartRequired(List<Address> newMembers) {
            assert (newMembers != null);
            return !newMembers.equals(this.topology.getMembers());
        }
    }
}

