/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.Writer;

public final class IndentWriter
extends Writer {
    private final StringBuilder sb = new StringBuilder(256);
    private static final int TAB_SIZE = 3;
    private int indent = 0;
    private boolean indentNeeded = false;

    public IndentWriter inc() {
        ++this.indent;
        return this;
    }

    public IndentWriter dec() {
        if (this.indent == 0) {
            throw new IllegalStateException();
        }
        --this.indent;
        return this;
    }

    @Override
    public void write(int c) {
        if (this.indentNeeded) {
            for (int i = this.indent * 3; i > 0; --i) {
                this.sb.append(' ');
            }
        }
        this.sb.append((char)c);
        this.indentNeeded = c == 10;
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.write(buf[i]);
        }
    }

    @Override
    public void write(String s2) {
        if (s2 == null) {
            s2 = "null";
        }
        this.write(s2, 0, s2.length());
    }

    @Override
    public void write(String s2, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.write(s2.charAt(i));
        }
    }

    @Override
    public IndentWriter append(CharSequence cs) {
        this.write(cs == null ? "null" : cs.toString());
        return this;
    }

    @Override
    public IndentWriter append(CharSequence cs, int start, int end) {
        if (cs == null) {
            cs = "null";
        }
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public IndentWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

