/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static <T> T doPrivilegedException(PrivilegedExceptionAction<T> action) throws FileNotFoundException {
        try {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return Security.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getCause();
            }
            throw new CacheConfigurationException(e);
        }
    }

    static boolean fileExists(File file) {
        return SecurityActions.doPrivileged(file::exists);
    }

    static FileChannel createChannel(File file) throws FileNotFoundException {
        return SecurityActions.doPrivilegedException(() -> new FileOutputStream(file).getChannel());
    }

    static FileChannel openFileChannel(File file) throws FileNotFoundException {
        return SecurityActions.doPrivilegedException(() -> new RandomAccessFile(file, "rw").getChannel());
    }

    public static boolean createDirectoryIfNeeded(File dir) {
        return SecurityActions.doPrivileged(() -> dir.mkdirs() || dir.exists());
    }
}

