/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.concurrent.locks.PendingLockPromise;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    @Inject
    PartitionHandlingManager partitionHandlingManager;
    @Inject
    PendingLockManager pendingLockManager;

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys2) {
        if (ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (t instanceof OutdatedTopologyException) {
                throw t;
            }
            this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
        });
    }

    final InvocationStage lockOrRegisterBackupLock(TxInvocationContext<?> ctx, VisitableCommand command, Object key, long lockTimeout) {
        switch (this.cdl.getCacheTopology().getDistribution(key).writeOwnership()) {
            case PRIMARY: {
                return this.checkPendingAndLockKey(ctx, command, key, lockTimeout);
            }
            case BACKUP: {
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
            }
        }
        return InvocationStage.completedNullStage();
    }

    final InvocationStage lockAllOrRegisterBackupLock(TxInvocationContext<?> ctx, VisitableCommand command, Collection<?> keys2, long lockTimeout) {
        if (keys2.isEmpty()) {
            return InvocationStage.completedNullStage();
        }
        ArrayList<Object> keysToLock = new ArrayList<Object>(keys2.size());
        Object cacheTransaction = ctx.getCacheTransaction();
        LocalizedCacheTopology cacheTopology = this.cdl.getCacheTopology();
        for (Object key : keys2) {
            if (((AbstractCacheTransaction)cacheTransaction).ownsLock(key)) continue;
            switch (cacheTopology.getDistribution(key).writeOwnership()) {
                case PRIMARY: {
                    keysToLock.add(key);
                    break;
                }
                case BACKUP: {
                    ((AbstractCacheTransaction)cacheTransaction).addBackupLockForKey(key);
                    break;
                }
            }
        }
        if (keysToLock.isEmpty()) {
            return InvocationStage.completedNullStage();
        }
        return this.checkPendingAndLockAllKeys(ctx, command, keysToLock, lockTimeout);
    }

    private InvocationStage checkPendingAndLockKey(TxInvocationContext<?> ctx, VisitableCommand command, Object key, long lockTimeout) {
        PendingLockPromise pendingLockPromise = this.pendingLockManager.checkPendingTransactionsForKey(ctx, key, lockTimeout, TimeUnit.MILLISECONDS);
        if (pendingLockPromise.isReady()) {
            return pendingLockPromise.hasTimedOut() ? pendingLockPromise.toInvocationStage() : this.lockAndRecord(ctx, command, key, lockTimeout);
        }
        return pendingLockPromise.toInvocationStage().thenApplyMakeStage(ctx, command, (rCtx, rCommand, rv) -> {
            long remaining = pendingLockPromise.getRemainingTimeout();
            return this.lockAndRecord(ctx, command, key, remaining);
        });
    }

    private InvocationStage checkPendingAndLockAllKeys(TxInvocationContext<?> ctx, VisitableCommand command, Collection<Object> keys2, long lockTimeout) {
        PendingLockPromise pendingLockPromise = this.pendingLockManager.checkPendingTransactionsForKeys(ctx, keys2, lockTimeout, TimeUnit.MILLISECONDS);
        if (pendingLockPromise.isReady()) {
            return pendingLockPromise.hasTimedOut() ? pendingLockPromise.toInvocationStage() : this.lockAllAndRecord(ctx, command, keys2, lockTimeout);
        }
        return pendingLockPromise.toInvocationStage().thenApplyMakeStage(ctx, command, (rCtx, rCommand, rv) -> {
            long remaining = pendingLockPromise.getRemainingTimeout();
            return this.lockAllAndRecord(ctx, command, keys2, remaining);
        });
    }

    void releaseLockOnTxCompletion(TxInvocationContext<?> ctx) {
        boolean shouldReleaseLocks;
        boolean bl = shouldReleaseLocks = ctx.isOriginLocal() && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction());
        if (shouldReleaseLocks) {
            this.lockManager.unlockAll(ctx);
        }
    }
}

