/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.statetransfer.StateTransferLock;
import org.jboss.logging.Logger;

public class L1WriteSynchronizer {
    private static final Logger log = Logger.getLogger(L1WriteSynchronizer.class);
    private final L1WriteSync sync = new L1WriteSync();
    private final long l1Lifespan;
    private final InternalDataContainer<Object, Object> dc;
    private final StateTransferLock stateTransferLock;
    private final ClusteringDependentLogic cdl;

    public L1WriteSynchronizer(InternalDataContainer dc, long l1Lifespan, StateTransferLock stateTransferLock, ClusteringDependentLogic cdl) {
        this.dc = dc;
        this.l1Lifespan = l1Lifespan;
        this.stateTransferLock = stateTransferLock;
        this.cdl = cdl;
    }

    public Object get() throws InterruptedException, ExecutionException {
        return this.sync.innerGet();
    }

    public Object get(long time, TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        return this.sync.innerGet(time, unit);
    }

    public boolean trySkipL1Update() {
        return this.sync.attemptToSkipFullRun();
    }

    public void retrievalEncounteredException(Throwable t) {
        this.sync.innerException(t);
    }

    public void runL1UpdateIfPossible(InternalCacheEntry ice) {
        try {
            Object key;
            if (ice != null && this.sync.attemptUpdateToRunning() && !this.dc.containsKey(key = ice.getKey())) {
                this.runL1Update(key, ice);
            }
        }
        finally {
            this.sync.innerSet(ice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runL1Update(Object key, InternalCacheEntry ice) {
        this.stateTransferLock.acquireSharedTopologyLock();
        try {
            if (!this.dc.containsKey(key) && !this.cdl.getCacheTopology().isWriteOwner(key)) {
                log.tracef("Caching remotely retrieved entry for key %s in L1", (Object)Util.toStr(key));
                long lifespan = ice.getLifespan() < 0L ? this.l1Lifespan : Math.min(ice.getLifespan(), this.l1Lifespan);
                Metadata newMetadata = ice.getMetadata().builder().lifespan(lifespan).maxIdle(-1L).build();
                this.dc.put(key, ice.getValue(), new L1Metadata(newMetadata));
            } else {
                log.tracef("Data container contained value after rehash for key %s", key);
            }
        }
        finally {
            this.stateTransferLock.releaseSharedTopologyLock();
        }
    }

    private static class L1WriteSync
    extends AbstractQueuedSynchronizer {
        private static final int READY = 0;
        private static final int RUNNING = 1;
        private static final int SKIP = 2;
        private static final int COMPLETED = 4;
        private Object result;
        private Throwable exception;

        private L1WriteSync() {
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.getState() == 4 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        boolean attemptUpdateToRunning() {
            if (this.getState() == 1) {
                return true;
            }
            return this.compareAndSetState(0, 1);
        }

        boolean attemptToSkipFullRun() {
            if (this.getState() == 2) {
                return true;
            }
            return this.compareAndSetState(0, 2);
        }

        Object innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        Object innerGet(long time, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
            if (!this.tryAcquireSharedNanos(0, unit.toNanos(time))) {
                throw new TimeoutException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        void innerSet(Object value) {
            int s2;
            do {
                if ((s2 = this.getState()) != 4) continue;
                return;
            } while (!this.compareAndSetState(s2, 4));
            this.result = value;
            this.releaseShared(0);
        }

        void innerException(Throwable t) {
            int s2;
            do {
                if ((s2 = this.getState()) != 4) continue;
                return;
            } while (!this.compareAndSetState(s2, 4));
            this.exception = t;
            this.releaseShared(0);
        }
    }
}

