/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import net.jcip.annotations.GuardedBy;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class TriangleOrderManager {
    private static final Log log = LogFactory.getLog(TriangleOrderManager.class);
    private final TriangleSequencer[] sequencers;
    @Inject
    DistributionManager distributionManager;

    public TriangleOrderManager(int segments) {
        TriangleSequencer[] triangleSequencers = new TriangleSequencer[segments];
        for (int segment = 0; segment < segments; ++segment) {
            triangleSequencers[segment] = new TriangleSequencer(segment);
        }
        this.sequencers = triangleSequencers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next(int segmentId, int commandTopologyId) {
        this.checkTopologyId(commandTopologyId);
        try {
            long l = this.getNext(segmentId, commandTopologyId);
            return l;
        }
        finally {
            this.checkTopologyId(commandTopologyId);
        }
    }

    public boolean isNext(int segmentId, long sequenceNumber, int commandTopologyId) {
        int topologyId = this.distributionManager.getCacheTopology().getTopologyId();
        return commandTopologyId < topologyId || commandTopologyId == topologyId && this.checkIfNext(segmentId, commandTopologyId, sequenceNumber);
    }

    public void markDelivered(int segmentId, long sequenceNumber, int commandTopologyId) {
        this.sequencers[segmentId].deliver(commandTopologyId, sequenceNumber);
    }

    public long latestSent(int segmentId, int topologyId) {
        return this.sequencers[segmentId].latestSent(topologyId);
    }

    private long getNext(int segmentId, int topologyId) {
        return this.sequencers[segmentId].next(topologyId);
    }

    private boolean checkIfNext(int segmentId, int topologyId, long sequenceNumber) {
        return this.sequencers[segmentId].isNext(topologyId, sequenceNumber);
    }

    private void checkTopologyId(int topologyId) {
        if (topologyId != this.distributionManager.getCacheTopology().getTopologyId()) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
    }

    private static class TriangleSequencer {
        private final int segment;
        @GuardedBy(value="this")
        private int senderTopologyId = -1;
        @GuardedBy(value="this")
        private int receiverTopologyId = -1;
        @GuardedBy(value="this")
        private long senderSequenceNumber = 1L;
        @GuardedBy(value="this")
        private long receiverSequenceNumber = 1L;

        private TriangleSequencer(int segment) {
            this.segment = segment;
        }

        private synchronized long next(int commandTopologyId) {
            if (this.senderTopologyId == commandTopologyId) {
                if (log.isTraceEnabled()) {
                    log.tracef("Sender %d new sequence %d:%d", (long)this.segment, (long)this.senderTopologyId, this.senderSequenceNumber);
                }
                return this.senderSequenceNumber++;
            }
            if (this.senderTopologyId < commandTopologyId) {
                if (log.isTraceEnabled()) {
                    log.tracef("Sender %d new sequence %d:1 (changed topology from %d)", this.segment, this.senderTopologyId, commandTopologyId);
                }
                this.senderTopologyId = commandTopologyId;
                this.senderSequenceNumber = 2L;
                return 1L;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Sender %d retrying because of outdated topology: %d < %d", this.segment, commandTopologyId, this.senderTopologyId);
            }
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }

        private synchronized long latestSent(int topologyId) {
            if (topologyId < this.senderTopologyId) {
                throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
            }
            if (this.senderTopologyId < topologyId) {
                return 0L;
            }
            return this.senderSequenceNumber - 1L;
        }

        private synchronized void deliver(int commandTopologyId, long sequenceNumber) {
            if (this.receiverTopologyId == commandTopologyId && this.receiverSequenceNumber == sequenceNumber) {
                ++this.receiverSequenceNumber;
                if (log.isTraceEnabled()) {
                    log.tracef("Receiver %d delivered sequence %d:%d", (long)this.segment, (long)commandTopologyId, sequenceNumber);
                }
            }
        }

        private synchronized boolean isNext(int commandTopologyId, long sequenceNumber) {
            if (log.isTraceEnabled()) {
                log.tracef("Receiver %d checking sequence %d:%d, current sequence is %d:%d", this.segment, commandTopologyId, sequenceNumber, this.receiverTopologyId, this.receiverSequenceNumber);
            }
            if (this.receiverTopologyId == commandTopologyId) {
                return this.receiverSequenceNumber == sequenceNumber;
            }
            if (this.receiverTopologyId < commandTopologyId) {
                this.receiverTopologyId = commandTopologyId;
                this.receiverSequenceNumber = 1L;
                return 1L == sequenceNumber;
            }
            return true;
        }
    }
}

