/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class MetadataTransientMortalCacheValue
extends MetadataMortalCacheValue
implements MetadataAware {
    long lastUsed;

    public MetadataTransientMortalCacheValue(Object value, Metadata metadata, long created, long lastUsed) {
        this(value, null, metadata, created, lastUsed);
    }

    protected MetadataTransientMortalCacheValue(Object value, PrivateMetadata internalMetadata, Metadata metadata, long created, long lastUsed) {
        super(value, internalMetadata, metadata, created);
        this.lastUsed = lastUsed;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new MetadataTransientMortalCacheEntry(key, this.value, this.internalMetadata, this.metadata, this.lastUsed, this.created);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public long getExpiryTime() {
        long muet;
        long lifespan = this.metadata.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", lastUsed=").append(this.lastUsed);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientMortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientMortalCacheValue value) throws IOException {
            output.writeObject(value.value);
            output.writeObject(value.internalMetadata);
            output.writeObject(value.metadata);
            UnsignedNumeric.writeUnsignedLong(output, value.created);
            UnsignedNumeric.writeUnsignedLong(output, value.lastUsed);
        }

        @Override
        public MetadataTransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientMortalCacheValue(value, internalMetadata, metadata, created, lastUsed);
        }

        @Override
        public Integer getId() {
            return 45;
        }

        @Override
        public Set<Class<? extends MetadataTransientMortalCacheValue>> getTypeClasses() {
            return Collections.singleton(MetadataTransientMortalCacheValue.class);
        }
    }
}

