/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.IntSets;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.InboundTransferTask;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.topology.CacheTopology;

@Listener
@Scope(value=Scopes.NAMED_CACHE)
public class StateReceiverImpl<K, V>
implements StateReceiver<K, V> {
    private static final Log log = LogFactory.getLog(StateReceiverImpl.class);
    @ComponentName(value="cacheName")
    @Inject
    String cacheName;
    @Inject
    CacheNotifier<K, V> cacheNotifier;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    InternalDataContainer<K, V> dataContainer;
    @Inject
    RpcManager rpcManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    ExecutorService nonBlockingExecutor;
    private LimitedExecutor stateReceiverExecutor;
    private final ConcurrentHashMap<Integer, SegmentRequest> requestMap = new ConcurrentHashMap();

    @Start
    public void start() {
        this.cacheNotifier.addListener(this);
        this.stateReceiverExecutor = new LimitedExecutor("StateReceiver-" + this.cacheName, this.nonBlockingExecutor, 1);
    }

    @Stop
    public void stop() {
        this.cancelRequests();
        this.stateReceiverExecutor.shutdownNow();
    }

    @Override
    public void cancelRequests() {
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s stop() called on StateReceiverImpl", (Object)this.cacheName);
        }
        for (SegmentRequest request : this.requestMap.values()) {
            request.cancel(null);
        }
    }

    @DataRehashed
    public void onDataRehash(DataRehashedEvent<K, V> dataRehashedEvent) {
        if (dataRehashedEvent.isPre()) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s received event: %s", (Object)this.cacheName, (Object)dataRehashedEvent);
            }
            for (SegmentRequest request : this.requestMap.values()) {
                request.cancel(new CacheException("Cancelling replica request as the owners of the requested segment have changed."));
            }
        }
    }

    @Override
    public CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> getAllReplicasForSegment(int segmentId, LocalizedCacheTopology topology, long timeout2) {
        return this.requestMap.computeIfAbsent(segmentId, id -> new SegmentRequest((int)id, topology, timeout2)).requestState();
    }

    @Override
    public void receiveState(Address sender, int topologyId, Collection<StateChunk> stateChunks) {
        if (stateChunks.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s ignoring received state from %s because stateChunks are empty", (Object)this.cacheName, (Object)sender);
            }
            return;
        }
        int segmentId = stateChunks.iterator().next().getSegmentId();
        SegmentRequest request = this.requestMap.get(segmentId);
        if (request == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s ignoring received state because the associated request was completed or cancelled", (Object)this.cacheName);
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s received state for %s", (Object)this.cacheName, (Object)request);
        }
        request.receiveState(sender, topologyId, stateChunks);
    }

    Map<K, Map<Address, CacheEntry<K, V>>> getKeyReplicaMap(int segmentId) {
        return this.requestMap.get((Object)Integer.valueOf((int)segmentId)).keyReplicaMap;
    }

    Map<Address, InboundTransferTask> getTransferTaskMap(int segmentId) {
        return this.requestMap.get((Object)Integer.valueOf((int)segmentId)).transferTaskMap;
    }

    InboundTransferTask createTransferTask(int segmentId, Address source2, CacheTopology topology, long transferTimeout) {
        return new InboundTransferTask(IntSets.immutableSet(segmentId), source2, topology.getTopologyId(), this.rpcManager, this.commandsFactory, transferTimeout, this.cacheName, false);
    }

    class SegmentRequest {
        final int segmentId;
        final LocalizedCacheTopology topology;
        final long timeout;
        final List<Address> replicaHosts;
        final Map<K, Map<Address, CacheEntry<K, V>>> keyReplicaMap = new HashMap();
        final Map<Address, InboundTransferTask> transferTaskMap = new ConcurrentHashMap<Address, InboundTransferTask>();
        CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> future;

        SegmentRequest(int segmentId, LocalizedCacheTopology topology, long timeout2) {
            this.segmentId = segmentId;
            this.topology = topology;
            this.timeout = timeout2;
            this.replicaHosts = topology.getSegmentDistribution(segmentId).writeOwners();
        }

        synchronized CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> requestState() {
            if (this.future != null) {
                assert (this.future.isCompletedExceptionally());
                if (log.isTraceEnabled()) {
                    log.tracef("Cache %s already cancelled replicas request for segment %s from %s with topology %s", StateReceiverImpl.this.cacheName, this.segmentId, this.replicaHosts, this.topology);
                }
                return this.future;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s attempting to receive replicas for segment %s from %s with topologyId=%s, timeout=%d", StateReceiverImpl.this.cacheName, this.segmentId, this.replicaHosts, this.topology.getTopologyId(), this.timeout);
            }
            this.future = new CompletableFuture();
            this.future.whenComplete((v, t) -> {
                if (t != null) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Cache %s segment request(s) cancelled due to exception=%s", (Object)StateReceiverImpl.this.cacheName, t);
                    }
                    this.cancel((Throwable)t);
                }
            });
            for (Address replica : this.replicaHosts) {
                if (replica.equals(StateReceiverImpl.this.rpcManager.getAddress())) {
                    StateReceiverImpl.this.dataContainer.forEach(entry -> {
                        int keySegment = this.topology.getDistribution(entry.getKey()).segmentId();
                        if (keySegment == this.segmentId) {
                            this.addKeyToReplicaMap(replica, (CacheEntry)entry);
                        }
                    });
                    if (this.replicaHosts.size() != 1) continue;
                    this.completeRequest();
                    continue;
                }
                InboundTransferTask transferTask = StateReceiverImpl.this.createTransferTask(this.segmentId, replica, this.topology, this.timeout);
                this.transferTaskMap.put(replica, transferTask);
                StateReceiverImpl.this.stateReceiverExecutor.execute(() -> {
                    if (!this.transferTaskMap.containsKey(replica)) {
                        return;
                    }
                    transferTask.requestSegments().exceptionally(throwable -> {
                        if (log.isTraceEnabled()) {
                            log.tracef((Throwable)throwable, "Cache %s exception when processing InboundTransferTask", (Object)StateReceiverImpl.this.cacheName);
                        }
                        this.cancel((Throwable)throwable);
                        return null;
                    });
                });
            }
            return this.future;
        }

        synchronized void clear() {
            this.keyReplicaMap.clear();
            this.transferTaskMap.clear();
            StateReceiverImpl.this.requestMap.remove(this.segmentId);
        }

        synchronized void receiveState(Address sender, int topologyId, Collection<StateChunk> stateChunks) {
            if (topologyId < this.topology.getTopologyId()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Cache %s discarding state response with old topology id %d, the smallest allowed topology id is %d", topologyId, this.topology.getTopologyId(), (Object)StateReceiverImpl.this.cacheName);
                }
                return;
            }
            InboundTransferTask transferTask = this.transferTaskMap.get(sender);
            if (transferTask == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Cache %s state received for an unknown request. No record of a state request exists for node %s", (Object)StateReceiverImpl.this.cacheName, (Object)sender);
                }
                return;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s state chunks received from %s, with topologyId %s, statechunks %s", StateReceiverImpl.this.cacheName, sender, topologyId, stateChunks);
            }
            for (StateChunk chunk : stateChunks) {
                boolean isLastChunk = chunk.isLastChunk();
                chunk.getCacheEntries().forEach(ice -> this.addKeyToReplicaMap(sender, (CacheEntry)ice));
                transferTask.onStateReceived(chunk.getSegmentId(), isLastChunk);
                if (!isLastChunk) continue;
                this.transferTaskMap.remove(sender);
                if (!this.transferTaskMap.isEmpty()) continue;
                this.completeRequest();
            }
        }

        synchronized void cancel(Throwable throwable) {
            if (this.future.isDone()) {
                return;
            }
            log.debugf(throwable, "Cache %s cancelling request for segment %s", (Object)StateReceiverImpl.this.cacheName, (Object)this.segmentId);
            if (this.future == null) {
                this.future = new CompletableFuture();
            }
            this.transferTaskMap.forEach((address, inboundTransferTask) -> inboundTransferTask.cancel());
            if (throwable != null) {
                this.future.completeExceptionally(throwable);
            } else {
                this.future.cancel(true);
            }
            this.clear();
        }

        synchronized void completeRequest() {
            ArrayList retVal = new ArrayList(this.keyReplicaMap.values());
            this.clear();
            this.future.complete(Collections.unmodifiableList(retVal));
        }

        void addKeyToReplicaMap(Address address, CacheEntry<K, V> ice) {
            this.keyReplicaMap.computeIfAbsent(ice.getKey(), k -> {
                HashMap map = new HashMap();
                this.replicaHosts.forEach(a -> map.put(a, NullCacheEntry.getInstance()));
                return map;
            }).put(address, ice);
        }

        public String toString() {
            return "SegmentRequest{segmentId=" + this.segmentId + ", topology=" + this.topology.getTopologyId() + ", replicaHosts=" + this.replicaHosts + ", keyReplicaMap=" + this.keyReplicaMap + ", transferTaskMap=" + this.transferTaskMap + ", future=" + this.future + '}';
        }
    }
}

