/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderContext;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationParserListener;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.util.logging.Log;

public class ConfigurationBuilderHolder
implements ConfigurationReaderContext {
    private final GlobalConfigurationBuilder globalConfigurationBuilder;
    private final Map<String, ConfigurationBuilder> namedConfigurationBuilders;
    private ConfigurationBuilder currentConfigurationBuilder;
    private final WeakReference<ClassLoader> classLoader;
    private final Deque<String> scope;
    private final JGroupsConfigurationBuilder jgroupsBuilder;
    private NamespaceMappingParser namespaceMappingParser;
    private final List<ConfigurationParserListener> listeners = new ArrayList<ConfigurationParserListener>();

    public ConfigurationBuilderHolder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ConfigurationBuilderHolder(ClassLoader classLoader) {
        this(classLoader, new GlobalConfigurationBuilder().classLoader(classLoader));
    }

    public ConfigurationBuilderHolder(ClassLoader classLoader, GlobalConfigurationBuilder globalConfigurationBuilder) {
        this.globalConfigurationBuilder = globalConfigurationBuilder;
        this.namedConfigurationBuilders = new HashMap<String, ConfigurationBuilder>();
        this.jgroupsBuilder = this.globalConfigurationBuilder.transport().jgroups();
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.scope = new ArrayDeque<String>();
        this.scope.push(ParserScope.GLOBAL.name());
    }

    public GlobalConfigurationBuilder getGlobalConfigurationBuilder() {
        return this.globalConfigurationBuilder;
    }

    public ConfigurationBuilder newConfigurationBuilder(String name) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.namedConfigurationBuilders.put(name, builder);
        this.currentConfigurationBuilder = builder;
        return builder;
    }

    public Map<String, ConfigurationBuilder> getNamedConfigurationBuilders() {
        return this.namedConfigurationBuilders;
    }

    public ConfigurationBuilder getCurrentConfigurationBuilder() {
        return this.currentConfigurationBuilder;
    }

    public ConfigurationBuilder getDefaultConfigurationBuilder() {
        if (this.globalConfigurationBuilder.defaultCacheName().isPresent()) {
            return this.namedConfigurationBuilders.get(this.globalConfigurationBuilder.defaultCacheName().get());
        }
        return null;
    }

    void pushScope(Enum<?> scope) {
        this.pushScope(scope.name());
    }

    public void pushScope(String scope) {
        this.scope.push(scope);
    }

    public String popScope() {
        return this.scope.pop();
    }

    public boolean inScope(String scope) {
        return this.getScope().equals(scope);
    }

    public boolean inScope(Enum<?> scope) {
        return this.inScope(scope.name());
    }

    public String getScope() {
        return this.scope.peek();
    }

    public void addParserListener(ConfigurationParserListener listener) {
        this.listeners.add(listener);
    }

    public void fireParserListeners() {
        for (ConfigurationParserListener listener : this.listeners) {
            listener.parsingComplete(this);
        }
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    public void validate() {
        this.globalConfigurationBuilder.defaultCacheName().ifPresent(name -> {
            if (!this.namedConfigurationBuilders.containsKey(name)) {
                throw Log.CONFIG.missingDefaultCacheDeclaration((String)name);
            }
        });
    }

    public void addJGroupsStack(FileJGroupsChannelConfigurator stack) {
        this.jgroupsBuilder.addStackFile(stack.getName()).fileChannelConfigurator(stack);
    }

    public void addJGroupsStack(EmbeddedJGroupsChannelConfigurator stack, String extend) {
        this.jgroupsBuilder.addStack(stack.getName()).extend(extend).channelConfigurator(stack);
    }

    boolean hasJGroupsStack(String name) {
        return this.jgroupsBuilder.hasStack(name);
    }

    public void setNamespaceMappingParser(NamespaceMappingParser namespaceMappingParser) {
        this.namespaceMappingParser = namespaceMappingParser;
    }

    @Override
    public void handleAnyElement(ConfigurationReader reader) {
        this.namespaceMappingParser.parseElement(reader, this);
    }

    @Override
    public void handleAnyAttribute(ConfigurationReader reader, int i) {
        this.namespaceMappingParser.parseAttribute(reader, i, this);
    }
}

