/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.parsing.ParseUtils;

public class GlobalStatePathConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalStatePathConfiguration> {
    private final AttributeSet attributes;
    private String elementName;
    private String location;

    GlobalStatePathConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String elementName) {
        super(globalConfig);
        this.elementName = elementName;
        this.attributes = GlobalStatePathConfiguration.attributeDefinitionSet();
    }

    public GlobalStatePathConfigurationBuilder location(String path, String relativeTo) {
        this.location = ParseUtils.resolvePath(path, relativeTo);
        this.attributes.attribute(GlobalStatePathConfiguration.PATH).set(path);
        this.attributes.attribute(GlobalStatePathConfiguration.RELATIVE_TO).set(relativeTo);
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public GlobalStatePathConfiguration create() {
        return new GlobalStatePathConfiguration(this.attributes.protect(), this.elementName);
    }

    public GlobalStatePathConfigurationBuilder read(GlobalStatePathConfiguration template) {
        this.attributes.read(template.attributes());
        this.location = template.getLocation();
        this.elementName = template.elementName();
        return this;
    }
}

