/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.BoundedThreadPoolConfiguration;
import org.infinispan.configuration.global.CachedThreadPoolConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.CoreExecutorFactory;
import org.infinispan.factories.threads.DefaultThreadFactory;

public class BoundedThreadPoolConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<BoundedThreadPoolConfiguration>,
ThreadPoolBuilderAdapter {
    private final AttributeSet attributes = BoundedThreadPoolConfiguration.attributeDefinitionSet();

    BoundedThreadPoolConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String name) {
        super(globalConfig);
        this.attributes.attribute(CachedThreadPoolConfiguration.NAME).set(name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public BoundedThreadPoolConfigurationBuilder threadFactory(String threadFactory2) {
        this.attributes.attribute(CachedThreadPoolConfiguration.THREAD_FACTORY).set(threadFactory2);
        return this;
    }

    public BoundedThreadPoolConfigurationBuilder maxThreads(Integer maxThreads) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.MAX_THREADS).set(maxThreads);
        return this;
    }

    public Integer maxThreads() {
        return this.attributes.attribute(BoundedThreadPoolConfiguration.MAX_THREADS).get();
    }

    public BoundedThreadPoolConfigurationBuilder coreThreads(Integer coreThreads) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.CORE_THREADS).set(coreThreads);
        return this;
    }

    public Integer coreThreads() {
        return this.attributes.attribute(BoundedThreadPoolConfiguration.CORE_THREADS).get();
    }

    public BoundedThreadPoolConfigurationBuilder keepAliveTime(Long keepAlive) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.KEEP_ALIVE_TIME).set(keepAlive);
        return this;
    }

    public Long keepAliveTime() {
        return this.attributes.attribute(BoundedThreadPoolConfiguration.KEEP_ALIVE_TIME).get();
    }

    public BoundedThreadPoolConfigurationBuilder queueLength(Integer queueLength) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.QUEUE_LENGTH).set(queueLength);
        return this;
    }

    public Integer queueLength() {
        return this.attributes.attribute(BoundedThreadPoolConfiguration.QUEUE_LENGTH).get();
    }

    public BoundedThreadPoolConfigurationBuilder nonBlocking(Boolean nonBlocking) {
        this.attributes.attribute(BoundedThreadPoolConfiguration.NON_BLOCKING).set(nonBlocking);
        return this;
    }

    public Boolean isNonBlocking() {
        return this.attributes.attribute(BoundedThreadPoolConfiguration.NON_BLOCKING).get();
    }

    public String name() {
        return this.attributes.attribute(CachedThreadPoolConfiguration.NAME).get();
    }

    @Override
    public BoundedThreadPoolConfiguration create() {
        return new BoundedThreadPoolConfiguration(this.attributes.protect());
    }

    public BoundedThreadPoolConfigurationBuilder read(BoundedThreadPoolConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String threadFactory() {
        return this.attributes.attribute(CachedThreadPoolConfiguration.THREAD_FACTORY).get();
    }

    public String toString() {
        return "BoundedThreadPoolConfigurationBuilder{attributes=" + this.attributes + '}';
    }

    @Override
    public ThreadPoolConfiguration asThreadPoolConfigurationBuilder() {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(this.getGlobalConfig());
        boolean isNonBlocking = this.isNonBlocking();
        builder.threadPoolFactory(CoreExecutorFactory.executorFactory(this.maxThreads(), this.coreThreads(), this.queueLength(), this.keepAliveTime(), isNonBlocking));
        builder.name(this.name());
        if (this.threadFactory() != null) {
            DefaultThreadFactory threadFactory2 = this.getGlobalConfig().threads().getThreadFactory(this.threadFactory()).create().getThreadFactory(isNonBlocking);
            builder.threadFactory(threadFactory2);
        }
        return builder.create();
    }
}

