/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.util.concurrent.IsolationLevel;

public class LockingConfiguration
extends ConfigurationElement<LockingConfiguration> {
    public static final AttributeDefinition<Integer> CONCURRENCY_LEVEL = AttributeDefinition.builder(Attribute.CONCURRENCY_LEVEL, Integer.valueOf(32)).immutable().build();
    public static final AttributeDefinition<IsolationLevel> ISOLATION_LEVEL = AttributeDefinition.builder(Attribute.ISOLATION, IsolationLevel.REPEATABLE_READ).immutable().build();
    public static final AttributeDefinition<Long> LOCK_ACQUISITION_TIMEOUT = AttributeDefinition.builder(Attribute.ACQUIRE_TIMEOUT, Long.valueOf(TimeUnit.SECONDS.toMillis(10L))).build();
    public static final AttributeDefinition<Boolean> USE_LOCK_STRIPING = AttributeDefinition.builder(Attribute.STRIPING, Boolean.valueOf(false)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> concurrencyLevel;
    private final org.infinispan.commons.configuration.attributes.Attribute<IsolationLevel> isolationLevel;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> lockAcquisitionTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> useLockStriping;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LockingConfiguration.class, CONCURRENCY_LEVEL, ISOLATION_LEVEL, LOCK_ACQUISITION_TIMEOUT, USE_LOCK_STRIPING);
    }

    LockingConfiguration(AttributeSet attributes) {
        super(Element.LOCKING, attributes, new ConfigurationElement[0]);
        this.concurrencyLevel = attributes.attribute(CONCURRENCY_LEVEL);
        this.isolationLevel = attributes.attribute(ISOLATION_LEVEL);
        this.lockAcquisitionTimeout = attributes.attribute(LOCK_ACQUISITION_TIMEOUT);
        this.useLockStriping = attributes.attribute(USE_LOCK_STRIPING);
    }

    public int concurrencyLevel() {
        return this.concurrencyLevel.get();
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel.get();
    }

    public long lockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout.get();
    }

    public LockingConfiguration lockAcquisitionTimeout(long timeout2) {
        this.lockAcquisitionTimeout.set(timeout2);
        return this;
    }

    public boolean useLockStriping() {
        return this.useLockStriping.get();
    }
}

