/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageInfo;

public class CachingPackageClient
extends PackageClient {
    private String cacheFolder;

    public CachingPackageClient(String address) {
        super(address);
        try {
            this.cacheFolder = Utilities.path(System.getProperty("user.home"), ".fhir", "package-client");
            Utilities.createDirectory(this.cacheFolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean exists(String id, String ver) throws IOException {
        List<PackageInfo> vl = this.getVersions(id);
        for (PackageInfo pi : vl) {
            if (!ver.equals(pi.getVersion())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream fetchCached(String url) throws IOException {
        File cacheFile = new File(Utilities.path(this.cacheFolder, this.fn(url)));
        if (cacheFile.exists()) {
            return new FileInputStream(cacheFile);
        }
        InputStream fetchedPackage = super.fetchCached(url);
        TextFile.bytesToFile(TextFile.streamToBytes(fetchedPackage), cacheFile);
        return new FileInputStream(cacheFile);
    }

    @Override
    public Date getNewPackages(Date lastCalled, List<PackageInfo> updates) {
        return null;
    }
}

