/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.EventStatus;

public class EventStatusEnumFactory
implements EnumFactory<EventStatus> {
    @Override
    public EventStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preparation".equals(codeString)) {
            return EventStatus.PREPARATION;
        }
        if ("in-progress".equals(codeString)) {
            return EventStatus.INPROGRESS;
        }
        if ("not-done".equals(codeString)) {
            return EventStatus.NOTDONE;
        }
        if ("on-hold".equals(codeString)) {
            return EventStatus.ONHOLD;
        }
        if ("stopped".equals(codeString)) {
            return EventStatus.STOPPED;
        }
        if ("completed".equals(codeString)) {
            return EventStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return EventStatus.ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return EventStatus.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown EventStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(EventStatus code) {
        if (code == EventStatus.PREPARATION) {
            return "preparation";
        }
        if (code == EventStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == EventStatus.NOTDONE) {
            return "not-done";
        }
        if (code == EventStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == EventStatus.STOPPED) {
            return "stopped";
        }
        if (code == EventStatus.COMPLETED) {
            return "completed";
        }
        if (code == EventStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == EventStatus.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(EventStatus code) {
        return code.getSystem();
    }
}

